/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ObjectQuery.crud.util;

import com.ibm.ObjectQuery.crud.util.ClassShortName;
import com.ibm.ObjectQuery.crud.util.Trace;
import com.ibm.ObjectQuery.crud.util.TreeNode;
import com.ibm.ObjectQuery.crud.util.VapStringReader;
import java.util.Iterator;

public class GenericTreeNode
extends TreeNode {
    private static final String copyright = "(c) Copyright IBM Corporation 2001.";
    private Object contextIvar;

    public GenericTreeNode() {
    }

    public GenericTreeNode(Object anObject) {
        this.context(anObject);
    }

    public Object context() {
        return this.contextIvar;
    }

    public void context(Object anObject) {
        this.contextIvar = anObject;
    }

    public static TreeNode example() {
        String str = "(Collection (Bag) (CompositeCollection) (EpHashDictionary) (EpLargeDictionary) (EpLargeIdentitySet) (EsLargeSymbolSet) (EsMultipleSets) (EsWeakSet (AbtWeakSet) (EsWeakIdentitySet) (SdgWeakSet)) (FastStack) (KeyedCollection (Dictionary (EsPoolDictionary) (EsSmalltalkDictionary) (SdgPersistentDictionary) (VapLocalImagePersistedInstancesCache)) (EsIndexedDictionary (AbtEsWeakDictionary) (AbtIndexedDictionary (AbtIndexedIdentityDictionary)) (EsIndexedIdentityDictionary) (EsOrderedDictionary (AbtOrderedDictionary (AbtOrderedIdentityDictionary) (SdgOrderedDictionary)) (EsOrderedIdentityDictionary)) (EsWeakDictionary (EsWeakIdentityDictionary) (SdgWeakDictionary))) (EsSmalltalkNamespace) (LookupTable (AbtWeakKeyLookupTable (AbtWeakKeyIdentityDictionary)) (AbtWeakValueLookupTable) (FixedSizeLookupTable) (IdentityDictionary (EpIdentityDictionary)))) (SequenceableCollection (AdditiveSequenceableCollection (OrderedCollection (EpUnorderedCollection) (KSCOrderedSet) (SdgOrderedSetSimple (SdgOrderedSet)) (SdgPrimaryKeyCollection) (Stack) (VapDataRow) (VapLiteCollection (VapPacketingLiteCollection)) (VapOrderedSetSimple (VapOrderedSet))) (SortedCollection)) (ArrayedCollection (Array (AbtPersistencyGroup) (ArrayAssociation (Range (RangeWithExclusions))) (EpAnnotationEntry) (EpLeafComponentAnnotationsEntry (EpComponentAnnotationsEntry)) (EsMethodArray) (EsWeakArray) (EswPrivateArray (EswInstVarNamesArray) (EswRootArray)) (GbLinkedArray) (SdgRelationalTuple)) (ByteArray (EsLeadEncodedBytes (HptLeadEncodedPSZ))) (EsLongArray) (EsString (DBString) (String (EswPrivateString) (HptStringPSZ) (Symbol)))) (GbLinkedCollection) (Interval)) (Set (EsIdentitySet) (EsSymbolSet (EsAtomSet)) (SdgDefineableEquivalenceSet) (VapEquivalenceSet)) (VapStack))";
        return GenericTreeNode.fromLispString(str);
    }

    public static void example2() {
        Iterator it = GenericTreeNode.example().iterator();
        Trace.traceOn();
        while (it.hasNext()) {
            Trace.show((TreeNode)it.next());
        }
    }

    public static void example3() {
        TreeNode aTree = GenericTreeNode.example();
        Trace.traceOn();
        Iterator it = aTree.leaves().iterator();
        while (it.hasNext()) {
            TreeNode aNode = (TreeNode)it.next();
            Iterator e2 = aNode.toRootIterator();
            while (e2.hasNext()) {
                Trace.show((TreeNode)e2.next());
            }
        }
    }

    public static void example4() {
        TreeNode aTree = GenericTreeNode.example();
        Trace.traceOn();
        Iterator it = aTree.breadthFirstIterator();
        while (it.hasNext()) {
            Trace.show((TreeNode)it.next());
        }
    }

    public static void example5() {
        TreeNode aTree = GenericTreeNode.example();
        Trace.traceOn();
        Iterator it = aTree.postOrderIterator();
        while (it.hasNext()) {
            Trace.show((TreeNode)it.next());
        }
    }

    public static int example6() {
        return GenericTreeNode.example().size();
    }

    public static TreeNode example7() {
        String str = "((VapCurrency (DELETE FROM CURRENCY  WHERE TYPE = ?))(VapAddress (DELETE FROM ADDRESS  WHERE ADDRNO = ?))(VapBankBranch (DELETE FROM BRANCH  WHERE BRANCHNO = ?))(VapAccount (DELETE FROM ACCOUNT  WHERE ACCNTNO = ?))(VapBankTransaction (DELETE FROM BANKXACT  WHERE TRANSNO = ?))(VapCustomer ((DELETE FROM CUSTOMER  WHERE CUSNO = ?)(DELETE FROM CUSTDATA  WHERE CUSNO = ?)))(VapBranchToCurrency (DELETE FROM BRNCHCURR  WHERE BRANCH = ? AND TYPE = ?))(VapDeposit (DELETE FROM BANKXACT  WHERE TRANSNO = ?))(VapSavingsAccount (DELETE FROM ACCOUNT  WHERE ACCNTNO = ?))(VapWithdrawal (DELETE FROM BANKXACT  WHERE TRANSNO = ?)) (VapCheckingAccount (DELETE FROM ACCOUNT  WHERE ACCNTNO = ?)))";
        return GenericTreeNode.fromLispString(str);
    }

    public static TreeNode fromLispString(String aString) {
        return GenericTreeNode.fromLispStringOn(new VapStringReader(aString));
    }

    public static TreeNode fromLispStringOn(VapStringReader aReader) {
        if (aReader.atEnd()) {
            return null;
        }
        aReader.skipSpaces();
        if (aReader.peek() == '(') {
            aReader.next();
            GenericTreeNode aNode = new GenericTreeNode(GenericTreeNode.nextNameFrom(aReader));
            aReader.skipSpaces();
            while (aReader.peek() != ')') {
                aNode.addChild(GenericTreeNode.fromLispStringOn(GenericTreeNode.nextBalancedChunkFrom(aReader)));
                aReader.skipSpaces();
            }
            aReader.next();
            return aNode;
        }
        throw new RuntimeException("not well-formed");
    }

    public static VapStringReader nextBalancedChunkFrom(VapStringReader aReader) {
        return new VapStringReader(aReader.nextBalancedChunkFrom('(', ')'));
    }

    private static String nextNameFrom(VapStringReader aReader) {
        StringBuffer aBuffer = new StringBuffer();
        while (!aReader.atEnd()) {
            char ch = aReader.peek();
            if (Character.isSpaceChar(ch) || ch == ')') {
                return aBuffer.toString();
            }
            aBuffer.append(aReader.next());
        }
        return aBuffer.toString();
    }

    public void printOn(StringBuffer aBuffer) {
        aBuffer.append(ClassShortName.name(this));
        aBuffer.append("(");
        aBuffer.append(this.context());
        aBuffer.append(", ");
        int[] anArray = this.levelId();
        int i = 0;
        while (i < anArray.length) {
            aBuffer.append(anArray[i]);
            if (i != anArray.length - 1) {
                aBuffer.append(" ");
            }
            ++i;
        }
        aBuffer.append(")");
    }
}

