/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ObjectQuery.crud.util;

import com.ibm.ObjectQuery.crud.util.ArrayIterator;
import com.ibm.ObjectQuery.crud.util.ClassName;
import com.ibm.ObjectQuery.crud.util.GenericNameFunction;
import com.ibm.ObjectQuery.crud.util.InclusionFunction;
import com.ibm.ObjectQuery.crud.util.NameFunction;
import com.ibm.ObjectQuery.crud.util.ObjectCollectionWrapper;
import com.ibm.ObjectQuery.crud.util.StDictionary;
import com.ibm.ObjectQuery.crud.util.StSet;
import com.ibm.ObjectQuery.crud.util.VapHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class HashedNamedCollection
implements Collection {
    private static final String copyright = "(c) Copyright IBM Corporation 2001.";
    private String nameString;
    private VapHashMap collectionValue;
    private NameFunction nameFunctionObj;

    public HashedNamedCollection() {
    }

    public HashedNamedCollection(NameFunction aFunction) {
        this.nameFunction(aFunction);
    }

    public HashedNamedCollection(String aName) {
        this.name(aName);
    }

    public HashedNamedCollection(String aName, NameFunction aFunction) {
        this.name(aName);
        this.nameFunction(aFunction);
    }

    public boolean add(Object anObj) {
        this.collection().put(this.nameFor(anObj), anObj);
        return true;
    }

    public boolean addAll(Object[] anArray) {
        return this.basicAddAll(new ArrayIterator(anArray));
    }

    public boolean addAll(Collection aCollection) {
        return this.basicAddAll(aCollection.iterator());
    }

    public boolean addIfAbsent(Object anObj) {
        if (!this.includes(anObj)) {
            return this.add(anObj);
        }
        return false;
    }

    public Object any() {
        return this.first();
    }

    public boolean basicAddAll(Iterator it) {
        boolean aFlag = true;
        while (it.hasNext()) {
            boolean bl = aFlag = aFlag && this.add(it.next());
        }
        return aFlag;
    }

    public void clear() {
        this.collectionValue = null;
    }

    public HashMap collection() {
        if (this.collectionValue == null) {
            this.collectionValue = new VapHashMap();
        }
        return this.collectionValue;
    }

    public boolean contains(Object anObj) {
        return this.includes(anObj);
    }

    public boolean containsAll(Collection aCollection) {
        Iterator it = aCollection.iterator();
        while (it.hasNext()) {
            if (this.contains(it.next())) continue;
            return false;
        }
        return true;
    }

    public NameFunction defaultNameFunction() {
        return new GenericNameFunction();
    }

    public Object first() {
        if (this.collection().size() == 0) {
            throw new RuntimeException("index out of bounds");
        }
        Iterator it = this.iterator();
        return it.next();
    }

    public Object get(String aName) {
        return this.named(aName);
    }

    public ObjectCollectionWrapper getWrapper() {
        return new ObjectCollectionWrapper();
    }

    public boolean hasName() {
        return this.nameString != null;
    }

    public boolean hasNameFunction() {
        return this.nameFunctionObj != null;
    }

    public boolean includes(Object anObj) {
        if (anObj == null) {
            return false;
        }
        return this.includesName(this.nameFor(anObj));
    }

    public boolean includesName(Object anObj) {
        if (anObj == null) {
            return false;
        }
        return this.includesName(this.nameFor(anObj));
    }

    public boolean includesName(String aName) {
        return this.named(aName) != null;
    }

    public boolean includesObject(Object anObj) {
        Iterator it = this.iterator();
        while (it.hasNext()) {
            if (it.next() != anObj) continue;
            return true;
        }
        return false;
    }

    public boolean isEmpty() {
        return this.collection().isEmpty();
    }

    public Iterator iterator() {
        return this.collection().values().iterator();
    }

    public String name() {
        if (this.nameString == null) {
            return "";
        }
        return this.nameString;
    }

    public void name(String aName) {
        this.nameString = aName;
    }

    public Object named(String aName) {
        return this.collection().get(aName);
    }

    public String nameFor(Object anObject) {
        return this.nameFunction().nameof(anObject);
    }

    public NameFunction nameFunction() {
        if (this.nameFunctionObj == null) {
            this.nameFunctionObj = this.defaultNameFunction();
        }
        return this.nameFunctionObj;
    }

    public void nameFunction(NameFunction anObj) {
        this.nameFunctionObj = anObj;
    }

    public Iterator nameIterator() {
        return this.collection().keySet().iterator();
    }

    public List names() {
        ArrayList<String> aList = new ArrayList<String>();
        Iterator it = this.iterator();
        while (it.hasNext()) {
            aList.add(this.nameFor(it.next()));
        }
        return aList;
    }

    public List reject(InclusionFunction aFunction) {
        ArrayList aList = new ArrayList();
        Iterator it = this.iterator();
        while (it.hasNext()) {
            Object each = it.next();
            if (aFunction.value(each)) continue;
            aList.add(each);
        }
        return aList;
    }

    public boolean remove(Object anObject) {
        return this.removeNamed(this.nameFor(anObject));
    }

    public boolean removeAll(Collection aCollection) {
        Iterator it = aCollection.iterator();
        boolean aFlag = true;
        while (it.hasNext()) {
            boolean bl = aFlag = aFlag && this.remove(it.next());
        }
        return aFlag;
    }

    public boolean removeNamed(Object anObject) {
        this.collection().remove(this.nameFor(anObject));
        return true;
    }

    public boolean removeNamed(String aName) {
        this.collection().remove(aName);
        return true;
    }

    public boolean retainAll(Collection aCollection) {
        Iterator it = aCollection.iterator();
        boolean aFlag = true;
        while (it.hasNext()) {
            Object each = it.next();
            if (aCollection.contains(each)) continue;
            boolean bl = aFlag = aFlag && this.remove(each);
        }
        return aFlag;
    }

    public int size() {
        return this.collection().size();
    }

    public Object[] toArray() {
        return this.collection().values().toArray();
    }

    public Object[] toArray(Object[] anArray) {
        return this.collection().values().toArray(anArray);
    }

    public Map toHashMap() {
        Iterator it = this.iterator();
        HashMap aMap = new HashMap();
        while (it.hasNext()) {
            Object each = it.next();
            aMap.put(this.nameFor(each), each);
        }
        return aMap;
    }

    public List toList() {
        Iterator it = this.iterator();
        ArrayList aList = new ArrayList();
        while (it.hasNext()) {
            aList.add(it.next());
        }
        return aList;
    }

    public StDictionary toStDictionary() {
        Iterator it = this.iterator();
        StDictionary aDictionary = new StDictionary();
        while (it.hasNext()) {
            Object each = it.next();
            aDictionary.put((Object)this.nameFor(each), each);
        }
        return aDictionary;
    }

    public String toString() {
        Iterator it = this.iterator();
        StringBuffer aBuffer = new StringBuffer();
        if (this.hasName()) {
            aBuffer.append(this.name());
        } else {
            aBuffer.append(ClassName.name(this));
        }
        aBuffer.append("[");
        while (it.hasNext()) {
            aBuffer.append(this.nameFor(it.next()));
            if (!it.hasNext()) continue;
            aBuffer.append(", ");
        }
        aBuffer.append("]");
        return aBuffer.toString();
    }

    public StSet toStSet() {
        Iterator it = this.iterator();
        StSet aSet = new StSet();
        while (it.hasNext()) {
            aSet.add(it.next());
        }
        return aSet;
    }
}

