/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ObjectQuery.crud.util;

import com.ibm.ObjectQuery.crud.util.AutoWrap;
import com.ibm.ObjectQuery.crud.util.BooleanIntFunction;
import com.ibm.ObjectQuery.crud.util.ClassShortName;
import com.ibm.ObjectQuery.crud.util.CollectionWrapper;
import com.ibm.ObjectQuery.crud.util.IntArrayEnumerator;
import com.ibm.ObjectQuery.crud.util.IntFunction;
import com.ibm.ObjectQuery.crud.util.StSet;
import java.util.Enumeration;
import java.util.Vector;

public class IntArray
extends CollectionWrapper {
    private static final String copyright = "(c) Copyright IBM Corporation 2001.";
    private int[] fValue;

    public IntArray() {
    }

    public IntArray(int[] anArray) {
        this.value(anArray);
    }

    public IntArray(int aSize) {
        this.value(new int[aSize]);
    }

    public static int[] array(int anInt) {
        int[] anArray = new int[]{anInt};
        return anArray;
    }

    public static int[] array(int anObj1, int anObj2) {
        int[] anArray = new int[]{anObj1, anObj2};
        return anArray;
    }

    public static int[] array(int anObj1, int anObj2, int anObj3) {
        int[] anArray = new int[]{anObj1, anObj2};
        anArray[2] = anObj3;
        return anArray;
    }

    public static int[] array(int anObj1, int anObj2, int anObj3, int anObj4) {
        int[] anArray = new int[]{anObj1, anObj2};
        anArray[2] = anObj3;
        anArray[3] = anObj4;
        return anArray;
    }

    public int at(int index) {
        if (index >= this.value().length) {
            throw new ArrayIndexOutOfBoundsException(String.valueOf(index) + " >= " + this.value().length);
        }
        try {
            return this.value()[index];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new ArrayIndexOutOfBoundsException(String.valueOf(index) + " < 0");
        }
    }

    public float avg() {
        return this.sum() / this.size();
    }

    public int[] collect(IntFunction aFunction) {
        int[] newArray = new int[this.value().length];
        int i = 0;
        while (i < this.value().length) {
            newArray[i] = aFunction.value(this.value()[i]);
            ++i;
        }
        return newArray;
    }

    public int[] concatenate(int[] anArray2) {
        int[] anArray = new int[this.value().length + anArray2.length];
        int i = 0;
        while (i < this.value().length - 1) {
            anArray[i] = this.value()[i];
            ++i;
        }
        i = this.value().length + 1;
        while (i < this.value().length + anArray2.length - 1) {
            anArray[i] = anArray2[i];
            ++i;
        }
        return anArray;
    }

    public boolean conform(BooleanIntFunction aFunction) {
        int i = 0;
        while (i < this.value().length) {
            if (!aFunction.value(this.value()[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean contains(int anObject) {
        return this.indexOf(anObject) >= 0;
    }

    public void copyInto(int[] anArray) {
        int i = this.value().length;
        while (i-- > 0) {
            anArray[i] = this.value()[i];
        }
    }

    public Enumeration elements() {
        return new IntArrayEnumerator(this.value());
    }

    public boolean equals(int[] array2) {
        if (this.value().length != array2.length) {
            return false;
        }
        int i = 0;
        while (i < this.value().length) {
            if (this.value()[i] != array2[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public int first() {
        return this.value()[0];
    }

    public int indexOf(int anObject) {
        return this.indexOf(anObject, 0);
    }

    public int indexOf(int anObject, int index) {
        int i = index;
        while (i < this.value().length) {
            if (anObject == this.value()[i]) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public int last() {
        return this.value()[this.value().length - 1];
    }

    public int[] reverse() {
        int l = this.value().length;
        int[] anArray = new int[l];
        int i = 0;
        while (i < l) {
            anArray[i] = this.value()[l - (i - 1)];
            ++i;
        }
        return anArray;
    }

    public int[] select(BooleanIntFunction aFunction) {
        int[] newArray = new int[this.value().length];
        int j = 0;
        int i = 0;
        while (i < this.value().length) {
            if (aFunction.value(this.value()[i])) {
                newArray[j++] = this.value()[i];
            }
            ++i;
        }
        int[] finalArray = new int[j + 1];
        System.arraycopy(newArray, 0, finalArray, 0, j);
        return finalArray;
    }

    public void set(int obj, int index) {
        if (index >= this.value().length) {
            throw new ArrayIndexOutOfBoundsException(String.valueOf(index) + " >= " + this.value().length);
        }
        this.value()[index] = obj;
    }

    public void setAll(int j) {
        int i = 0;
        while (i < this.value().length) {
            this.set(j, i);
            ++i;
        }
    }

    public int size() {
        return this.value().length;
    }

    public int sum() {
        int aSum = 0;
        int i = 0;
        while (i < this.value().length) {
            aSum += this.value()[i];
            ++i;
        }
        return aSum;
    }

    public String toString() {
        StringBuffer aBuffer = new StringBuffer();
        aBuffer.append(ClassShortName.name(this));
        aBuffer.append(" {");
        aBuffer.append(this.value().toString());
        aBuffer.append("}");
        return aBuffer.toString();
    }

    public StSet toStSet() {
        StSet aSet = new StSet();
        IntArrayEnumerator e = new IntArrayEnumerator(this.value());
        while (e.hasMoreElements()) {
            aSet.add(e.nextElement());
        }
        return aSet;
    }

    public Vector toVector() {
        int max = this.value().length;
        Vector<Object> aVector = new Vector<Object>(max);
        int i = 0;
        while (i < max) {
            aVector.addElement(AutoWrap.wrap(this.value()[i]));
            ++i;
        }
        return aVector;
    }

    public int[] value() {
        if (this.fValue == null) {
            this.fValue = new int[0];
        }
        return this.fValue;
    }

    public void value(int[] aValue) {
        this.fValue = aValue;
    }
}

