/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ObjectQuery.crud.util;

import com.ibm.ObjectQuery.crud.util.LListEnumerator;
import com.ibm.ObjectQuery.crud.util.ReverseArrayEnumerator;
import com.ibm.ObjectQuery.crud.util.ReverseVectorEnumerator;
import com.ibm.ObjectQuery.crud.util.Trace;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;

public class LList
implements Serializable,
Cloneable {
    private static final String copyright = "(c) Copyright IBM Corporation 2001.";
    private Object firstPart;
    private LList restPart;

    public LList() {
    }

    public LList(Object anObject) {
        this.replaceFirst(anObject);
    }

    public LList(Object anObj1, Object anObj2) {
        this.replaceFirst(anObj1);
        this.replaceRest(new LList(anObj2));
    }

    public LList(Object anObj1, Object anObj2, Object anObj3) {
        this.replaceFirst(anObj1);
        LList nextList = new LList(anObj2);
        this.replaceRest(nextList);
        nextList.replaceRest(new LList(anObj3));
    }

    public LList(Object anObj1, Object anObj2, Object anObj3, Object anObj4) {
        this.replaceFirst(anObj1);
        LList nextList = new LList(anObj2);
        this.replaceRest(nextList);
        LList nextList2 = new LList(anObj3);
        nextList.replaceRest(nextList2);
        nextList2.replaceRest(new LList(anObj4));
    }

    public LList allButLast() {
        if (this.isEmpty()) {
            throw new RuntimeException("allButLast is not legal on empty lists");
        }
        return this.rest().allButLast().precede(this.first());
    }

    public LList append(LList aList) {
        if (!this.isList(aList)) {
            throw new RuntimeException("cannot append a non-list to a list");
        }
        if (this.isEmpty()) {
            return aList;
        }
        if (this.hasTail()) {
            return this.rest().append(aList).precede(this.first());
        }
        return aList.precede(this.first());
    }

    public LList copy() {
        if (this.isEmpty()) {
            return this.emptyCopy();
        }
        return this.rest().copy().precede(this.first());
    }

    public Object element(int anInteger) {
        if (this.isEmpty() || anInteger <= 0) {
            new RuntimeException("index out of range");
        }
        if (anInteger == 1) {
            return this.first();
        }
        return this.rest().element(anInteger - 1);
    }

    public Enumeration elements() {
        return new LListEnumerator(this);
    }

    public LList emptyCopy() {
        return new LList();
    }

    public boolean equal(LList aList) {
        if (this == aList) {
            return true;
        }
        if (aList == null) {
            return false;
        }
        if (this.isEmpty() && aList.isEmpty()) {
            return true;
        }
        return this.equalHeads(this.first(), aList.first()) && this.equalTails(this.rest(), aList.rest());
    }

    public boolean equalHeads(Object anObj1, Object anObj2) {
        if (this.isList(anObj1) && this.isList(anObj2)) {
            return ((LList)anObj1).equal((LList)anObj2);
        }
        if (!this.isList(anObj1) && !this.isList(anObj2)) {
            return anObj1 == anObj2;
        }
        return false;
    }

    public boolean equalTails(LList aList1, LList aList2) {
        if (aList1 == null && aList2 == null) {
            return true;
        }
        return aList1.equal(aList2);
    }

    public static LList example() {
        return new LList("1").append(new LList(new LList("a", "b", "c", "d")));
    }

    public static LList example2() {
        Object[] anArray = new String[]{"a", "b", "c", "d"};
        return LList.from(anArray);
    }

    public static void example3() {
        Trace.traceOn();
        LList aList = new LList(new LList(new LList("a1", "a2", "a3")), new LList("b1", "b2", "b3"), "c", "d");
        Enumeration e = aList.elements();
        while (e.hasMoreElements()) {
            Trace.show(e.nextElement());
        }
    }

    public static LList example4() {
        return new LList(new LList(new LList("a1", "a2", "a3")), new LList("b1", "b2", "b3"), "c", "d");
    }

    public Object first() {
        return this.firstPart;
    }

    public LList follow(LList aList) {
        if (this.rest() == null) {
            return new LList().precede(aList);
        }
        LList aNewList = this.rest().follow(aList);
        return aNewList.precede(this.first());
    }

    public static LList from(Object[] anArray) {
        ReverseArrayEnumerator e = new ReverseArrayEnumerator(anArray);
        LList result = new LList();
        while (e.hasMoreElements()) {
            result = result.precede(e.nextElement());
        }
        return result;
    }

    public static LList from(Vector aVector) {
        ReverseVectorEnumerator e = new ReverseVectorEnumerator(aVector);
        LList result = new LList();
        while (e.hasMoreElements()) {
            result = result.precede(e.nextElement());
        }
        return result;
    }

    public boolean hasTail() {
        return this.restPart != null;
    }

    public boolean isEmpty() {
        return this.firstPart == null && this.restPart == null;
    }

    public boolean isFirstList() {
        return this.isList(this.first());
    }

    public boolean isList(Object anObject) {
        return anObject instanceof LList;
    }

    public Object last() {
        if (this.isEmpty()) {
            throw new RuntimeException("last is not legal on empty lists");
        }
        if (this.rest() == null) {
            return this.first();
        }
        return this.rest().last();
    }

    public int length() {
        return 1 + this.rest().length();
    }

    public LList precede(Object anObject) {
        LList aListElement = new LList();
        aListElement.replaceFirst(anObject);
        aListElement.replaceRest(this);
        return aListElement;
    }

    public LList prefix(int anInteger) {
        if (anInteger <= 0) {
            return this.emptyCopy();
        }
        return this.rest().prefix(anInteger - 1).precede(this.first());
    }

    public void printEmptyListOn(StringBuffer aBuffer) {
        aBuffer.append("()");
    }

    public void printOn(StringBuffer aBuffer) {
        if (!this.isEmpty()) {
            aBuffer.append('(');
            if (this.isFirstList()) {
                ((LList)this.first()).printOn(aBuffer);
            } else {
                aBuffer.append(this.first().toString());
            }
            if (this.hasTail()) {
                aBuffer.append(" ");
                this.rest().printTailOn(aBuffer);
            }
            aBuffer.append(')');
        } else {
            this.printEmptyListOn(aBuffer);
        }
    }

    public void printTailOn(StringBuffer aBuffer) {
        if (this.isFirstList()) {
            ((LList)this.first()).printOn(aBuffer);
        } else {
            aBuffer.append(this.first().toString());
        }
        if (!this.isEmpty() && this.hasTail()) {
            aBuffer.append(" ");
            this.rest().printTailOn(aBuffer);
        }
    }

    public void replaceFirst(Object anObject) {
        this.firstPart = anObject;
    }

    public void replaceRest(LList aList) {
        if (!aList.isEmpty()) {
            this.restPart = aList;
        }
    }

    public LList rest() {
        return this.restPart;
    }

    public int size() {
        return this.length();
    }

    public LList sublistFor(int start, int size) {
        return this.suffix(this.length() - start + 1).prefix(size);
    }

    public LList sublistTo(int start, int end) {
        return this.suffix(this.length() - start + 1).prefix(end - start + 1);
    }

    public LList suffix(int anInteger) {
        if (this.isEmpty()) {
            if (anInteger == 0) {
                return this;
            }
            throw new RuntimeException("illegal suffix length");
        }
        LList result = this;
        int size = this.length();
        if (anInteger < 0 || anInteger > this.length()) {
            throw new RuntimeException("illegal suffix length");
        }
        int i = 1;
        while (i < size - anInteger) {
            result = result.rest();
            ++i;
        }
        return result;
    }

    public String toString() {
        StringBuffer aBuffer = new StringBuffer();
        this.printOn(aBuffer);
        return aBuffer.toString();
    }
}

