/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ObjectQuery.crud.util;

import com.ibm.ObjectQuery.crud.util.GenericOrderRelation;
import com.ibm.ObjectQuery.crud.util.OrderRelation;
import com.ibm.ObjectQuery.crud.util.UnitIndexList;
import java.util.List;

public class ListSorter {
    private static final String copyright = "(c) Copyright IBM Corporation 2001.";
    OrderRelation orderRelation = new GenericOrderRelation();

    public ListSorter() {
    }

    public ListSorter(OrderRelation aRelation) {
        this.setOrderRelation(aRelation);
    }

    public int binarySearch(Object anObject, List v) {
        UnitIndexList mappedList = new UnitIndexList(v);
        int low = 1;
        int high = v.size();
        while (low <= high) {
            int mid = low + high / 2;
            if (this.precedes(mappedList.getAt(mid), anObject)) {
                low = mid + 1;
                continue;
            }
            high = mid - 1;
        }
        return low;
    }

    public void bubbleDownFrom(int anIndex, int heapTop, Object parent, List v) {
        int swapIndex;
        UnitIndexList mappedList = new UnitIndexList(v);
        int parentIndex = swapIndex = anIndex;
        int childIndex1 = parentIndex + parentIndex;
        while (childIndex1 <= heapTop) {
            Object temp;
            int childIndex2 = childIndex1 + 1;
            if (childIndex2 > heapTop) {
                swapIndex = childIndex1;
                temp = mappedList.getAt(swapIndex);
            } else if (this.precedes(mappedList.getAt(childIndex1), mappedList.getAt(childIndex2))) {
                swapIndex = childIndex2;
                temp = mappedList.getAt(swapIndex);
            } else {
                swapIndex = childIndex1;
                temp = mappedList.getAt(swapIndex);
            }
            if (!this.precedes(parent, temp)) {
                mappedList.setAt(parent, parentIndex);
                return;
            }
            mappedList.setAt(temp, parentIndex);
            parentIndex = swapIndex;
            childIndex1 = parentIndex + parentIndex;
        }
        mappedList.setAt(parent, parentIndex);
    }

    public int bubbleUpFrom(int start, Object child, List v) {
        UnitIndexList mappedList = new UnitIndexList(v);
        int parentIndex = start;
        int childIndex = start;
        while (childIndex > 1) {
            parentIndex = childIndex / 2;
            Object temp = mappedList.getAt(parentIndex);
            if (this.precedes(child, temp)) {
                mappedList.setAt(child, childIndex);
                return childIndex;
            }
            mappedList.setAt(temp, childIndex);
            childIndex = parentIndex;
        }
        mappedList.setAt(child, 1);
        return childIndex;
    }

    public OrderRelation getOrderRelation() {
        return this.orderRelation;
    }

    public void heapSort(List v) {
        Object rra;
        int n = v.size();
        if (n < 2) {
            return;
        }
        UnitIndexList ra = new UnitIndexList(v);
        int l = (n >> 1) + 1;
        int ir = n;
        while (true) {
            if (l > 1) {
                rra = ra.getAt(--l);
            } else {
                rra = ra.getAt(ir);
                ra.setAt(ra.getAt(1), ir);
                if (--ir == 1) break;
            }
            int i = l;
            int j = l + l;
            while (j <= ir) {
                if (j < ir && this.precedes(ra.getAt(j), ra.getAt(j + 1))) {
                    ++j;
                }
                if (this.precedes(rra, ra.getAt(j))) {
                    ra.setAt(ra.getAt(j), i);
                    i = j;
                    j <<= 1;
                    continue;
                }
                j = ir + 1;
            }
            ra.setAt(rra, i);
        }
        ra.setAt(rra, 1);
    }

    public boolean precedes(Object a, Object b) {
        return this.getOrderRelation().precedes(a, b);
    }

    public void setOrderRelation(OrderRelation newOrderRelation) {
        this.orderRelation = newOrderRelation;
    }

    public void sort(List v) {
        this.heapSort(v);
    }
}

