/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ObjectQuery.crud.util;

import com.ibm.ObjectQuery.crud.util.ArrayIterator;
import com.ibm.ObjectQuery.crud.util.BooleanFunction;
import com.ibm.ObjectQuery.crud.util.ClassName;
import com.ibm.ObjectQuery.crud.util.Function;
import com.ibm.ObjectQuery.crud.util.GenericNameFunction;
import com.ibm.ObjectQuery.crud.util.InclusionFunction;
import com.ibm.ObjectQuery.crud.util.ListSorter;
import com.ibm.ObjectQuery.crud.util.ListWrapper;
import com.ibm.ObjectQuery.crud.util.NameFunction;
import com.ibm.ObjectQuery.crud.util.NamedCollectionOrderRelation;
import com.ibm.ObjectQuery.crud.util.OrderRelation;
import com.ibm.ObjectQuery.crud.util.StDictionary;
import com.ibm.ObjectQuery.crud.util.StSet;
import com.ibm.ObjectQuery.crud.util.TwoValuedFunction;
import com.ibm.ObjectQuery.crud.util.TwoValuedIntFunction;
import com.ibm.ObjectQuery.crud.util.VoidFunction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class NamedCollection
implements Collection {
    private static final String copyright = "(c) Copyright IBM Corporation 2001.";
    private String nameString;
    private List collectionValue;
    private NameFunction nameFunctionObj;
    private OrderRelation orderRelationObj;

    public NamedCollection() {
    }

    public NamedCollection(NameFunction aFunction) {
        this.nameFunction(aFunction);
    }

    public NamedCollection(NameFunction aFunction, OrderRelation aRelation) {
        this.nameFunction(aFunction);
        this.orderRelation(aRelation);
    }

    public NamedCollection(OrderRelation aRelation) {
        this.orderRelation(aRelation);
    }

    public NamedCollection(String aName) {
        this.name(aName);
    }

    public NamedCollection(String aName, NameFunction aFunction) {
        this.name(aName);
        this.nameFunction(aFunction);
    }

    public boolean add(Object anObj) {
        int i = this.indexOf(anObj);
        if (i == -1) {
            return this.collection().add(anObj);
        }
        this.collection().set(i, anObj);
        return true;
    }

    public boolean addAll(Object[] anArray) {
        return this.basicAddAll(new ArrayIterator(anArray));
    }

    public boolean addAll(Collection aCollection) {
        return this.basicAddAll(aCollection.iterator());
    }

    public boolean addIfAbsent(Object anObj) {
        if (!this.includes(anObj)) {
            this.collection().add(anObj);
            return true;
        }
        return false;
    }

    public Object any() {
        return this.first();
    }

    public void apply(VoidFunction aFunction) {
        this.getWrapper().apply(aFunction);
    }

    public void applyWith(NamedCollection aCollection, TwoValuedFunction aFunction) {
        this.getWrapper().applyWith(aCollection.collection(), aFunction);
    }

    public void applyWith(List aList, TwoValuedFunction aFunction) {
        this.getWrapper().applyWith(aList, aFunction);
    }

    public void applyWithIndex(TwoValuedIntFunction aFunction) {
        this.getWrapper().applyWithIndex(aFunction);
    }

    public boolean basicAddAll(Iterator it) {
        boolean aFlag = true;
        while (it.hasNext()) {
            boolean bl = aFlag = aFlag && this.add(it.next());
        }
        return aFlag;
    }

    public void clear() {
        this.collectionValue = null;
    }

    public List collect(Function aFunction) {
        return this.getWrapper().collect(aFunction);
    }

    public List collection() {
        if (this.collectionValue == null) {
            this.collectionValue = new ArrayList();
        }
        return this.collectionValue;
    }

    public boolean conform(BooleanFunction aFunction) {
        return this.getWrapper().conform(aFunction);
    }

    public boolean contains(Object anObj) {
        return this.includes(anObj);
    }

    public boolean containsAll(Collection aCollection) {
        Iterator it = aCollection.iterator();
        while (it.hasNext()) {
            if (this.contains(it.next())) continue;
            return false;
        }
        return true;
    }

    public NameFunction defaultNameFunction() {
        return new GenericNameFunction();
    }

    public OrderRelation defaultOrderRelation() {
        return new NamedCollectionOrderRelation();
    }

    public Object detect(BooleanFunction aFunction) {
        return this.getWrapper().detect(aFunction);
    }

    public Object first() {
        if (this.collection().size() == 0) {
            throw new RuntimeException("index out of bounds");
        }
        return this.collection().get(0);
    }

    public ListWrapper getWrapper() {
        return new ListWrapper(this.collection());
    }

    public boolean hasName() {
        return this.nameString != null;
    }

    public boolean hasNameFunction() {
        return this.nameFunctionObj != null;
    }

    public boolean includes(Object anObj) {
        if (anObj == null) {
            return false;
        }
        return this.includesName(this.nameFor(anObj));
    }

    public boolean includesName(Object anObj) {
        if (anObj == null) {
            return false;
        }
        return this.includesName(this.nameFor(anObj));
    }

    public boolean includesName(String aName) {
        return this.named(aName) != null;
    }

    public boolean includesObject(Object anObj) {
        Iterator it = this.iterator();
        while (it.hasNext()) {
            if (it.next() != anObj) continue;
            return true;
        }
        return false;
    }

    public int indexOf(Object anObj) {
        return this.indexOfName(this.nameFor(anObj));
    }

    private int indexOfName(String aName) {
        int i = 0;
        while (i < this.size()) {
            if (aName.equals(this.nameFor(this.collection().get(i)))) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public boolean isEmpty() {
        return this.collection().isEmpty();
    }

    public Iterator iterator() {
        return this.collection().iterator();
    }

    public Object last() {
        int i = this.collection().size();
        if (i == 0) {
            throw new RuntimeException("index out of bounds");
        }
        return this.collection().get(i);
    }

    public String name() {
        if (this.nameString == null) {
            return "";
        }
        return this.nameString;
    }

    public void name(String aName) {
        this.nameString = aName;
    }

    public Object named(String aName) {
        int i = 0;
        while (i < this.size()) {
            Object each = this.collection().get(i);
            if (aName.equals(this.nameFor(each))) {
                return each;
            }
            ++i;
        }
        return null;
    }

    public String nameFor(Object anObject) {
        return this.nameFunction().nameof(anObject);
    }

    public NameFunction nameFunction() {
        if (this.nameFunctionObj == null) {
            this.nameFunctionObj = this.defaultNameFunction();
        }
        return this.nameFunctionObj;
    }

    public void nameFunction(NameFunction anObj) {
        this.nameFunctionObj = anObj;
    }

    public Iterator nameIterator() {
        return this.collection().iterator();
    }

    public List names() {
        ArrayList<String> aList = new ArrayList<String>();
        Iterator it = this.iterator();
        while (it.hasNext()) {
            aList.add(this.nameFor(it.next()));
        }
        return aList;
    }

    public OrderRelation orderRelation() {
        if (this.orderRelationObj == null) {
            this.orderRelationObj = this.defaultOrderRelation();
        }
        return this.orderRelationObj;
    }

    public void orderRelation(OrderRelation aRel) {
        this.orderRelationObj = aRel;
    }

    public List reject(InclusionFunction aFunction) {
        ArrayList aList = new ArrayList();
        Iterator it = this.iterator();
        while (it.hasNext()) {
            Object each = it.next();
            if (aFunction.value(each)) continue;
            aList.add(each);
        }
        return aList;
    }

    public boolean remove(Object anObject) {
        return this.removeNamed(this.nameFor(anObject));
    }

    public boolean removeAll(Collection aCollection) {
        Iterator it = aCollection.iterator();
        boolean aFlag = true;
        while (it.hasNext()) {
            boolean bl = aFlag = aFlag && this.remove(it.next());
        }
        return aFlag;
    }

    public boolean removeNamed(Object anObject) {
        int i = this.indexOf(anObject);
        if (i == -1) {
            return false;
        }
        this.collection().remove(i);
        return true;
    }

    public boolean removeNamed(String aName) {
        int i = this.indexOfName(aName);
        if (i == -1) {
            return false;
        }
        this.collection().remove(i);
        return true;
    }

    public boolean retainAll(Collection aCollection) {
        Iterator it = aCollection.iterator();
        boolean aFlag = true;
        while (it.hasNext()) {
            Object each = it.next();
            if (aCollection.contains(each)) continue;
            boolean bl = aFlag = aFlag && this.remove(each);
        }
        return aFlag;
    }

    public List select(BooleanFunction aFunction) {
        return this.getWrapper().select(aFunction);
    }

    public int size() {
        return this.collection().size();
    }

    public void sort() {
        ListSorter aSorter = new ListSorter(this.orderRelation());
        aSorter.heapSort(this.collection());
    }

    public Object[] toArray() {
        return this.getWrapper().toArray();
    }

    public Object[] toArray(Object[] anArray) {
        return this.getWrapper().toArray(anArray);
    }

    public Map toHashMap() {
        Iterator it = this.iterator();
        HashMap aMap = new HashMap();
        while (it.hasNext()) {
            Object each = it.next();
            aMap.put(this.nameFor(each), each);
        }
        return aMap;
    }

    public List toList() {
        Iterator it = this.iterator();
        ArrayList aList = new ArrayList();
        while (it.hasNext()) {
            aList.add(it.next());
        }
        return aList;
    }

    public StDictionary toStDictionary() {
        Iterator it = this.iterator();
        StDictionary aDictionary = new StDictionary();
        while (it.hasNext()) {
            Object each = it.next();
            aDictionary.put((Object)this.nameFor(each), each);
        }
        return aDictionary;
    }

    public String toString() {
        StringBuffer aBuffer = new StringBuffer();
        if (this.hasName()) {
            aBuffer.append(this.name());
        } else {
            aBuffer.append(ClassName.name(this));
        }
        this.detailOn(aBuffer);
        return aBuffer.toString();
    }

    public void detailOn(StringBuffer aBuffer) {
        Iterator it = this.collection().iterator();
        aBuffer.append("[");
        while (it.hasNext()) {
            aBuffer.append(this.nameFor(it.next()));
            if (!it.hasNext()) continue;
            aBuffer.append(", ");
        }
        aBuffer.append("]");
    }

    public StSet toStSet() {
        Iterator it = this.iterator();
        StSet aSet = new StSet();
        while (it.hasNext()) {
            aSet.add(it.next());
        }
        return aSet;
    }
}

