/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ObjectQuery.crud.util;

import com.ibm.ObjectQuery.crud.util.StSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;

public class OrderedSet
implements List {
    private static final String copyright = "(c) Copyright IBM Corporation 2001.";
    private List orderedCollection = new ArrayList();
    private Set hashCollection = new HashSet();

    public OrderedSet() {
    }

    public OrderedSet(int initialSize) {
        this.orderedCollection = new ArrayList(initialSize);
        this.hashCollection = new HashSet(initialSize);
    }

    public void add(int i, Object anObject) {
        if (!this.contains(anObject)) {
            this.getOrdered().add(i, anObject);
            this.getHashed().add(anObject);
        }
    }

    public boolean add(Object anObject) {
        if (!this.contains(anObject)) {
            this.getOrdered().add(anObject);
            this.getHashed().add(anObject);
            return true;
        }
        return false;
    }

    public boolean addAll(int i, Collection aList) {
        Iterator it = aList.iterator();
        boolean aFlag = true;
        int j = i;
        while (it.hasNext()) {
            Object each = it.next();
            if (!this.contains(each)) {
                this.add(j++, each);
                continue;
            }
            aFlag = false;
        }
        return aFlag;
    }

    public boolean addAll(Collection aList) {
        Iterator it = aList.iterator();
        boolean aFlag = true;
        while (it.hasNext()) {
            boolean bl = aFlag = this.add(it.next()) && aFlag;
        }
        return aFlag;
    }

    public void clear() {
        this.getOrdered().clear();
        this.getHashed().clear();
    }

    public boolean contains(Object anObject) {
        return this.getHashed().contains(anObject);
    }

    public boolean containsAll(Collection aCollection) {
        return this.getHashed().containsAll(aCollection);
    }

    public Object first() {
        return this.getOrdered().get(0);
    }

    public Object get(int index) {
        return this.getOrdered().get(index);
    }

    private Set getHashed() {
        return this.hashCollection;
    }

    private List getOrdered() {
        return this.orderedCollection;
    }

    public int indexOf(Object anObject) {
        return this.getOrdered().indexOf(anObject);
    }

    public boolean isEmpty() {
        return this.getOrdered().isEmpty();
    }

    public Iterator iterator() {
        return this.getOrdered().iterator();
    }

    public Object last() {
        if (this.size() == 0) {
            return null;
        }
        return this.getOrdered().get(this.size() - 1);
    }

    public int lastIndexOf(Object anObject) {
        return this.getOrdered().lastIndexOf(anObject);
    }

    public ListIterator listIterator() {
        return this.getOrdered().listIterator();
    }

    public ListIterator listIterator(int i) {
        return this.getOrdered().listIterator(i);
    }

    public Object remove(int index) {
        Object anObject = this.getOrdered().get(index);
        this.getOrdered().remove(index);
        this.getHashed().remove(anObject);
        return anObject;
    }

    public boolean remove(Object anObject) {
        if (this.contains(anObject)) {
            this.getOrdered().remove(anObject);
            this.getHashed().remove(anObject);
            return true;
        }
        return false;
    }

    public boolean removeAll(Collection aCollection) {
        boolean aFlag = true;
        aFlag = aFlag && this.getOrdered().removeAll(aCollection);
        aFlag = aFlag && this.getHashed().removeAll(aCollection);
        return aFlag;
    }

    public boolean retainAll(Collection aList) {
        boolean aFlag = true;
        aFlag = aFlag && this.getHashed().retainAll(aList);
        aFlag = aFlag && this.getOrdered().retainAll(aList);
        return aFlag;
    }

    public Object set(int index, Object anObject) {
        Object old = this.get(index);
        this.getHashed().remove(old);
        this.getOrdered().set(index, anObject);
        this.getHashed().add(anObject);
        return anObject;
    }

    public Object set(Object anObject, int index) {
        if (!this.getHashed().contains(anObject)) {
            this.getOrdered().set(index, anObject);
            this.getHashed().add(anObject);
        }
        return anObject;
    }

    private void setHashed(StSet aSet) {
        this.hashCollection = aSet;
    }

    public int size() {
        return this.getOrdered().size();
    }

    public List subList(int i, int j) {
        return this.getOrdered().subList(i, j);
    }

    public Object[] toArray() {
        return this.getOrdered().toArray();
    }

    public Object[] toArray(Object[] anArray) {
        return this.getOrdered().toArray(anArray);
    }

    public List toList() {
        return (List)((ArrayList)this.getOrdered()).clone();
    }

    public String toString() {
        return this.getOrdered().toString();
    }
}

