/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ObjectQuery.crud.util;

import com.ibm.ObjectQuery.crud.util.Printable;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;

public class OutputDevice
implements Printable {
    private StringBuffer stringBuffer = null;
    private PrintWriter printWriter = null;
    private PrintStream printStream = null;
    private static final String copyright = "Licensed Materials -- Property of IBM\n(c) Copyright International Business Machines Corporation, 1999";

    public OutputDevice() {
        this(System.out);
    }

    public OutputDevice(FileOutputStream aStream) {
        this(new PrintWriter(aStream));
    }

    public OutputDevice(PrintStream aStream) {
        this(new PrintWriter(aStream, true));
        this.setPrintStream(aStream);
    }

    public OutputDevice(PrintWriter aWriter) {
        this.setPrintWriter(aWriter);
    }

    public OutputDevice(StringBuffer aBuffer) {
        this.setStringBuffer(aBuffer);
    }

    public void close() {
        if (this.isUsingPrintWriter()) {
            this.getPrintWriter().close();
        }
    }

    public void flush() {
        if (this.isUsingPrintWriter()) {
            this.getPrintWriter().flush();
        }
    }

    private String getNewLine() {
        return System.getProperties().getProperty("line.separator");
    }

    public PrintStream getPrintStream() {
        return this.printStream;
    }

    public PrintWriter getPrintWriter() {
        return this.printWriter;
    }

    public StringBuffer getStringBuffer() {
        return this.stringBuffer;
    }

    private boolean isUsingPrintWriter() {
        return this.printWriter != null;
    }

    private boolean isUsingStringBuffer() {
        return this.stringBuffer != null;
    }

    public boolean isUsingSystemOut() {
        return this.getPrintStream() != null && this.getPrintStream() == System.out;
    }

    public void newLine() {
        this.print(this.getNewLine());
    }

    public void print(char[] aChar) {
        if (this.isUsingStringBuffer()) {
            this.getStringBuffer().append(aChar);
            return;
        }
        if (this.isUsingPrintWriter()) {
            this.getPrintWriter().print(aChar);
        }
    }

    public void print(char aChar) {
        if (this.isUsingStringBuffer()) {
            this.getStringBuffer().append(aChar);
            return;
        }
        if (this.isUsingPrintWriter()) {
            this.getPrintWriter().print(aChar);
        }
    }

    public void print(double aDouble) {
        if (this.isUsingStringBuffer()) {
            this.getStringBuffer().append(aDouble);
            return;
        }
        if (this.isUsingPrintWriter()) {
            this.getPrintWriter().print(aDouble);
        }
    }

    public void print(float aFloat) {
        if (this.isUsingStringBuffer()) {
            this.getStringBuffer().append(aFloat);
            return;
        }
        if (this.isUsingPrintWriter()) {
            this.getPrintWriter().print(aFloat);
        }
    }

    public void print(int anInt) {
        if (this.isUsingStringBuffer()) {
            this.getStringBuffer().append(anInt);
            return;
        }
        if (this.isUsingPrintWriter()) {
            this.getPrintWriter().print(anInt);
        }
    }

    public void print(long aLong) {
        if (this.isUsingStringBuffer()) {
            this.getStringBuffer().append(aLong);
            return;
        }
        if (this.isUsingPrintWriter()) {
            this.getPrintWriter().print(aLong);
        }
    }

    public void print(Object anObject) {
        if (this.isUsingStringBuffer()) {
            this.getStringBuffer().append(anObject);
            return;
        }
        if (this.isUsingPrintWriter()) {
            this.getPrintWriter().print(anObject);
        }
    }

    public void print(boolean aBoolean) {
        if (this.isUsingStringBuffer()) {
            this.getStringBuffer().append(aBoolean);
            return;
        }
        if (this.isUsingPrintWriter()) {
            this.getPrintWriter().print(aBoolean);
        }
    }

    public void println() {
        if (this.isUsingStringBuffer()) {
            this.getStringBuffer().append(this.getNewLine());
            return;
        }
        if (this.isUsingPrintWriter()) {
            this.getPrintWriter().println();
        }
    }

    public void println(char[] aChar) {
        this.print(aChar);
        this.println();
    }

    public void println(char aChar) {
        this.print(aChar);
        this.println();
    }

    public void println(double aDouble) {
        this.print(aDouble);
        this.println();
    }

    public void println(float aFloat) {
        this.print(aFloat);
        this.println();
    }

    public void println(int anInt) {
        this.print(anInt);
        this.println();
    }

    public void println(long aLong) {
        this.print(aLong);
        this.println();
    }

    public void println(Object anObject) {
        this.print(anObject);
        this.println();
    }

    public void println(boolean aBoolean) {
        this.print(aBoolean);
        this.println();
    }

    public void setPrintStream(PrintStream aStream) {
        this.printStream = aStream;
    }

    public void setPrintWriter(PrintWriter aWriter) {
        this.printWriter = aWriter;
    }

    public void setStringBuffer(StringBuffer aBuffer) {
        this.stringBuffer = aBuffer;
    }
}

