/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ObjectQuery.crud.util;

import com.ibm.ObjectQuery.crud.util.ListWrapper;
import com.ibm.ObjectQuery.crud.util.VapStringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class SelectTokenizer {
    public static final String SELECT = "select";
    public static final String DISTINCT = "distinct";
    public static final String INTO = "into";
    public static final char OPEN_PAREN = '(';
    public static final char CLOSE_PAREN = ')';
    public static final char COMMA = ',';
    public static final char SPACE = ' ';
    public static final String DELIMITERS = " ,.(";
    public static final char QUOTE = '\"';
    public static final String PAREN_SPACE = "( ";
    private VapStringReader fReader;

    public SelectTokenizer(String aQuery) {
        this.reader(new VapStringReader(aQuery));
    }

    public int selectClauseSize(String aQuery) {
        String token = this.readSelect();
        if (token == null) {
            return -1;
        }
        return this.selectClauseElements().size();
    }

    public VapStringReader reader() {
        return this.fReader;
    }

    public void reader(VapStringReader aReader) {
        this.fReader = aReader;
    }

    public ListWrapper tokenize() {
        ListWrapper aList = new ListWrapper();
        String aPiece = this.readSelect();
        if (aPiece == null) {
            return null;
        }
        aList.add(aPiece);
        aList.addIfNotNull(this.readDistinct());
        aList.addAll((Collection)this.selectClauseElements());
        aList.add(this.readIntoOrFrom());
        return aList;
    }

    public boolean isSelect() {
        return this.readSelect() != null;
    }

    public boolean isDistinct() {
        String aPiece = this.readSelect();
        if (aPiece == null) {
            return false;
        }
        return this.readDistinct() != null;
    }

    public boolean isSelectInto() {
        return ((String)this.tokenize().last()).equalsIgnoreCase(INTO);
    }

    public String readSelect() {
        this.reader().skipChar(PAREN_SPACE);
        String token = this.reader().next(6);
        if (!token.equalsIgnoreCase(SELECT)) {
            return null;
        }
        return token;
    }

    public String readDistinct() {
        this.reader().skipSpaces();
        String token = this.reader().peek(8);
        if (token.equalsIgnoreCase(DISTINCT)) {
            this.reader().next(8);
            return token;
        }
        return null;
    }

    public String readIntoOrFrom() {
        this.reader().skipSpaces();
        return this.reader().next(4);
    }

    public List selectClauseElements() {
        ArrayList<String> aList = new ArrayList<String>();
        while (!this.reader().atEnd()) {
            this.reader().skipSpaces();
            aList.add(this.nextSelectClauseElement());
            this.reader().skipSpaces();
            if (this.reader().peek() != ',') {
                return aList;
            }
            this.reader().next();
        }
        return aList;
    }

    public String nextSelectClauseElement() {
        StringBuffer aBuffer = new StringBuffer();
        while (true) {
            this.nextDottedNameChunkOn(aBuffer);
            char ch = this.reader().peek();
            if (ch == ',' || ch == ' ') {
                return aBuffer.toString();
            }
            aBuffer.append(this.reader().next());
        }
    }

    public void nextDottedNameChunkOn(StringBuffer aBuffer) {
        if (this.reader().peek() == '\"') {
            aBuffer.append(this.reader().nextDoubleQuotedChunk());
        } else {
            aBuffer.append(this.reader().gatherUntil(DELIMITERS));
            if (this.reader().peek() == '(') {
                aBuffer.append(this.reader().nextBalancedChunkFrom('(', ')'));
            }
        }
    }
}

