/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ObjectQuery.crud.util;

import com.ibm.ObjectQuery.crud.util.ArrayIterator;
import com.ibm.ObjectQuery.crud.util.ClassShortName;
import com.ibm.ObjectQuery.crud.util.EqualityRelation;
import com.ibm.ObjectQuery.crud.util.GenericEqualityRelation;
import com.ibm.ObjectQuery.crud.util.GenericHashFunction;
import com.ibm.ObjectQuery.crud.util.HashFunction;
import com.ibm.ObjectQuery.crud.util.IteratorWithIndex;
import com.ibm.ObjectQuery.crud.util.StSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Vector;

public abstract class StCollection
implements Collection {
    private static final String copyright = "(c) Copyright IBM Corporation 2001.";
    private EqualityRelation fEqualityRelation;
    private HashFunction fHashFunction;

    public StCollection() {
        this.initialize(StCollection.minimumSize());
    }

    public StCollection(EqualityRelation aRelation) {
        this.equalityRelation(aRelation);
        this.initialize(StCollection.minimumSize());
    }

    public StCollection(HashFunction aFuntion) {
        this.hashFunction(aFuntion);
        this.initialize(StCollection.minimumSize());
    }

    public StCollection(HashFunction aFuntion, EqualityRelation aRelation) {
        this.equalityRelation(aRelation);
        this.hashFunction(aFuntion);
        this.initialize(StCollection.minimumSize());
    }

    public abstract boolean add(Object var1);

    public boolean addAll(Object[] aCollection) {
        return this.basicAddAll(new ArrayIterator(aCollection));
    }

    public boolean addAll(Collection aCollection) {
        return this.basicAddAll(aCollection.iterator());
    }

    public Object any() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        Enumeration e = this.elements();
        return e.nextElement();
    }

    public Object[] asArray() {
        Object[] answer = new Object[this.size()];
        this.toArray(answer);
        return answer;
    }

    public List asList() {
        ArrayList aList = new ArrayList(this.size());
        Enumeration e = this.elements();
        while (e.hasMoreElements()) {
            aList.add(e.nextElement());
        }
        return aList;
    }

    public StSet asSet() {
        StSet aSet = new StSet(this.size());
        Enumeration e = this.elements();
        while (e.hasMoreElements()) {
            aSet.add(e.nextElement());
        }
        return aSet;
    }

    public Vector asVector() {
        Vector aVector = new Vector(this.size());
        Enumeration e = this.elements();
        while (e.hasMoreElements()) {
            aVector.addElement(e.nextElement());
        }
        return aVector;
    }

    public boolean basicAddAll(Iterator it) {
        boolean aFlag = true;
        while (it.hasNext()) {
            boolean bl = aFlag = aFlag && this.add(it.next());
        }
        return aFlag;
    }

    public boolean contains(Object anObject) {
        return this.includes(anObject);
    }

    public boolean containsAll(Collection aCollection) {
        Iterator it = aCollection.iterator();
        while (it.hasNext()) {
            if (this.contains(it.next())) continue;
            return false;
        }
        return true;
    }

    public EqualityRelation defaultEqualityRelation() {
        return new GenericEqualityRelation();
    }

    public HashFunction defaultHashFunction() {
        return new GenericHashFunction();
    }

    public abstract Enumeration elements();

    public boolean eq(Object anObject1, Object anObject2) {
        return this.equalityRelation().equals(anObject1, anObject2);
    }

    public EqualityRelation equalityRelation() {
        return this.fEqualityRelation;
    }

    public void equalityRelation(EqualityRelation aRelation) {
        this.fEqualityRelation = aRelation;
    }

    public Object first() {
        return this.any();
    }

    public String getNewLine() {
        return System.getProperties().getProperty("line.separator");
    }

    public HashFunction hashFunction() {
        return this.fHashFunction;
    }

    public void hashFunction(HashFunction aFunction) {
        this.fHashFunction = aFunction;
    }

    public abstract boolean includes(Object var1);

    public void initialize(int anInt) {
        this.hashFunction(this.defaultHashFunction());
        this.equalityRelation(this.defaultEqualityRelation());
    }

    public abstract boolean isEmpty();

    public static int minimumSize() {
        return 11;
    }

    public abstract boolean remove(Object var1);

    public boolean removeAll(Collection aCollection) {
        Iterator i = aCollection.iterator();
        boolean flag = true;
        while (i.hasNext()) {
            boolean bl = flag = flag && this.remove(i.next());
        }
        return flag;
    }

    public boolean retainAll(Collection aCollection) {
        return true;
    }

    public abstract int size();

    public Object[] toArray() {
        Object[] answer = new Object[this.size()];
        this.toArray(answer);
        return answer;
    }

    public Object[] toArray(Object[] anArray) {
        Iterator it = this.iterator();
        int i = 0;
        while (i < anArray.length) {
            anArray[i] = it.next();
            ++i;
        }
        return anArray;
    }

    public List toList() {
        ArrayList aList = new ArrayList();
        Iterator it = this.iterator();
        while (it.hasNext()) {
            aList.add(it.next());
        }
        return aList;
    }

    public synchronized String toString() {
        StringBuffer aBuffer = new StringBuffer();
        aBuffer.append(ClassShortName.name(this));
        if (this.size() - 1 < 100) {
            this.toStringForSmallOn(aBuffer);
        } else {
            this.toStringForLargeOn(aBuffer);
        }
        return aBuffer.toString();
    }

    public void toStringForLargeOn(StringBuffer buf) {
        IteratorWithIndex e = new IteratorWithIndex(this.iterator(), this.size());
        buf.append("{");
        while (e.hasNext()) {
            buf.append(e.next());
            if (e.isLast()) continue;
            buf.append(",");
        }
        buf.append("......etc......");
        e.skip(this.size() - 29);
        while (e.hasNext()) {
            buf.append(e.next());
            if (e.isLast()) continue;
            buf.append(this.getNewLine());
        }
        buf.append("}");
    }

    public void toStringForSmallOn(StringBuffer buf) {
        int max = this.size() - 1;
        boolean i = false;
        IteratorWithIndex e = new IteratorWithIndex(this.iterator(), this.size());
        buf.append("{");
        while (e.hasNext()) {
            buf.append(e.next());
            if (e.isLast()) continue;
            buf.append(this.getNewLine());
        }
        buf.append("}");
    }

    public abstract Iterator iterator();

    public abstract void clear();
}

