/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ObjectQuery.crud.util;

import com.ibm.ObjectQuery.crud.util.ArrayIterator;
import com.ibm.ObjectQuery.crud.util.Association;
import com.ibm.ObjectQuery.crud.util.DictionaryEnumerator;
import com.ibm.ObjectQuery.crud.util.DictionaryKeyEnumerator;
import com.ibm.ObjectQuery.crud.util.EqualityRelation;
import com.ibm.ObjectQuery.crud.util.HashFunction;
import com.ibm.ObjectQuery.crud.util.SetEnumerator;
import com.ibm.ObjectQuery.crud.util.StCollection;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

public class StDictionary
extends StCollection {
    private static final String copyright = "(c) Copyright IBM Corporation 2001.";
    private int elementCount;
    private Association[] elementsArray;

    public StDictionary() {
        this.initialize(StCollection.minimumSize());
    }

    public StDictionary(int anInt) {
        this.initialize(anInt + Math.max(anInt, StCollection.minimumSize()));
    }

    public StDictionary(EqualityRelation aRelation) {
        super(aRelation);
    }

    public StDictionary(HashFunction aFuntion) {
        this.hashFunction(aFuntion);
    }

    public StDictionary(HashFunction aFuntion, EqualityRelation aRelation) {
        super(aFuntion, aRelation);
    }

    private void aboutToAdd(int numberOfElements) {
        if (numberOfElements * 2 > this.elementsArray.length) {
            this.rehash(numberOfElements * 2);
        }
    }

    public boolean add(Association anAssociation) {
        Association each;
        int hashIndex;
        int elementsSize = this.elementsArray.length;
        Object key = anAssociation.key();
        int i = hashIndex = this.hashIndex(key);
        while (i < elementsSize) {
            each = this.elementsArray[i];
            if (each == null) {
                this.elementsArray[i] = anAssociation;
                if (this.elementCount++ > elementsSize / 2) {
                    this.expand();
                }
                return true;
            }
            if (this.eq(each.key(), key)) {
                each.value(anAssociation.value());
                return true;
            }
            ++i;
        }
        i = 0;
        while (i < hashIndex - 1) {
            each = this.elementsArray[i];
            if (each == null) {
                this.elementsArray[i] = anAssociation;
                if (this.elementCount++ > elementsSize / 2) {
                    this.expand();
                }
                return true;
            }
            if (this.eq(each.key(), key)) {
                each.value(anAssociation.value());
                return true;
            }
            ++i;
        }
        this.expand().add(anAssociation);
        return true;
    }

    public boolean add(Object anObj) {
        return this.add((Association)anObj);
    }

    public Dictionary addAll(Dictionary aDictionary) {
        this.aboutToAdd(aDictionary.size());
        return aDictionary;
    }

    public Object associationAt(Object aKey) {
        Association each;
        int hashIndex;
        int elementsSize = this.elementsArray.length;
        int i = hashIndex = this.hashIndex(aKey);
        while (i < elementsSize) {
            each = this.elementsArray[i];
            if (each == null) {
                return null;
            }
            if (this.eq(each.key(), aKey)) {
                return each;
            }
            ++i;
        }
        i = 0;
        while (i < hashIndex - 1) {
            each = this.elementsArray[i];
            if (each == null) {
                return null;
            }
            if (this.eq(each.key(), aKey)) {
                return each;
            }
            ++i;
        }
        return null;
    }

    public Enumeration associationElements() {
        return new SetEnumerator(this);
    }

    private Object atUnique(int aKey, Object anObject) {
        return this.atUnique(new Integer(aKey), anObject);
    }

    private Object atUnique(Object aKey, Object anObject) {
        int hashIndex;
        int elementsSize = this.elementsArray.length;
        int i = hashIndex = this.hashIndex(aKey);
        while (i < elementsSize) {
            if (this.elementsArray[i] == null) {
                this.elementsArray[i] = new Association(aKey, anObject);
                ++this.elementCount;
                if (this.elementCount > elementsSize / 2) {
                    this.expand();
                }
                return anObject;
            }
            ++i;
        }
        i = 0;
        while (i < hashIndex - 1) {
            if (this.elementsArray[i] == null) {
                this.elementsArray[i] = new Association(aKey, anObject);
                ++this.elementCount;
                if (this.elementCount > elementsSize / 2) {
                    this.expand();
                }
                return anObject;
            }
            ++i;
        }
        return this.expand().atUnique(aKey, anObject);
    }

    public void clear() {
        int i = 0;
        while (i < this.elementsArray.length) {
            this.elementsArray[i] = null;
            ++i;
        }
        this.elementCount = 0;
    }

    public Enumeration elements() {
        return new DictionaryEnumerator(this);
    }

    private StDictionary expand() {
        return this.rehash(this.elementsArray.length + this.elementsArray.length);
    }

    public Object get(char aChar) {
        return this.get(new Character(aChar));
    }

    public Object get(int anInteger) {
        return this.get(new Integer(anInteger));
    }

    public Object get(Object aKey) {
        Association each;
        int hashIndex;
        int elementsSize = this.elementsArray.length;
        int i = hashIndex = this.hashIndex(aKey);
        while (i < elementsSize) {
            each = this.elementsArray[i];
            if (each == null) {
                return null;
            }
            if (this.eq(each.key(), aKey)) {
                return each.value();
            }
            ++i;
        }
        i = 0;
        while (i < hashIndex - 1) {
            each = this.elementsArray[i];
            if (each == null) {
                return null;
            }
            if (this.eq(each.key(), aKey)) {
                return each.value();
            }
            ++i;
        }
        return null;
    }

    public Object get(boolean aBoolean) {
        return this.get(new Boolean(aBoolean));
    }

    protected Association[] getElementsArray() {
        return this.elementsArray;
    }

    private int hashIndex(Object anObject) {
        return this.hashIndex(anObject, this.elementsArray.length);
    }

    private int hashIndex(Object anObject, int aSize) {
        return (this.hashFunction().hashValue(anObject) & Integer.MAX_VALUE) % aSize;
    }

    public boolean includes(Object anObject) {
        int i = 0;
        while (i < this.elementsArray.length) {
            if (this.elementsArray[i] != null && this.valueEq(this.elementsArray[i].value(), anObject)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean includesKey(char aChar) {
        return this.includesKey(new Character(aChar));
    }

    public boolean includesKey(int anInteger) {
        return this.includesKey(new Integer(anInteger));
    }

    public boolean includesKey(Object aKey) {
        Association each;
        int hashIndex;
        int elementsSize = this.elementsArray.length;
        int i = hashIndex = this.hashIndex(aKey);
        while (i < elementsSize) {
            each = this.elementsArray[i];
            if (each == null) {
                return false;
            }
            if (this.eq(each.key(), aKey)) {
                return true;
            }
            ++i;
        }
        i = 0;
        while (i < hashIndex - 1) {
            each = this.elementsArray[i];
            if (each == null) {
                return false;
            }
            if (this.eq(each.key(), aKey)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean includesKey(boolean aBoolean) {
        return this.includesKey(new Boolean(aBoolean));
    }

    public void initialize(int anInt) {
        super.initialize(anInt);
        this.elementCount = 0;
        this.elementsArray = new Association[anInt];
    }

    public boolean isEmpty() {
        return this.elementCount == 0;
    }

    public Iterator iterator() {
        return new DictionaryEnumerator(this);
    }

    public Enumeration keyElements() {
        return new DictionaryKeyEnumerator(this);
    }

    public Vector keys() {
        Enumeration e = this.associationElements();
        Vector<Object> aVector = new Vector<Object>(this.size());
        while (e.hasMoreElements()) {
            aVector.addElement(((Association)e.nextElement()).key());
        }
        return aVector;
    }

    public boolean notEmpty() {
        return this.elementCount != 0;
    }

    private void primRemoveAllKeys(Iterator e) {
        int elementsSize = this.elementsArray.length;
        while (e.hasNext()) {
            Object aKey = ((Association)e.next()).key();
            int hashIndex = this.hashIndex(aKey);
            boolean done = false;
            while (!done) {
                Association each;
                if (hashIndex >= elementsSize) {
                    hashIndex = 0;
                }
                if ((each = this.elementsArray[hashIndex]) == null) {
                    done = true;
                    continue;
                }
                if (each.key() == this || !this.eq(each.key(), aKey)) continue;
                this.rehashTo(hashIndex);
                --this.elementCount;
                done = true;
            }
        }
    }

    public Object put(char[] aKey, Object aValue) {
        return this.put((Object)new String(aKey), aValue);
    }

    public Object put(char aKey, Object aValue) {
        return this.put((Object)new Character(aKey), aValue);
    }

    public Object put(int aKey, int aValue) {
        return this.put((Object)new Integer(aKey), (Object)new Integer(aValue));
    }

    public Object put(int aKey, Object aValue) {
        return this.put((Object)new Integer(aKey), aValue);
    }

    public Object put(Object aKey, char aValue) {
        return this.put(aKey, (Object)new Character(aValue));
    }

    public Object put(Object aKey, int aValue) {
        return this.put(aKey, (Object)new Integer(aValue));
    }

    public Object put(Object aKey, Object aValue) {
        Association each;
        int hashIndex;
        int elementsSize = this.elementsArray.length;
        int i = hashIndex = this.hashIndex(aKey);
        while (i < elementsSize) {
            each = this.elementsArray[i];
            if (each == null) {
                this.elementsArray[i] = new Association(aKey, aValue);
                ++this.elementCount;
                if (this.elementCount > elementsSize / 2) {
                    this.expand();
                }
                return aValue;
            }
            if (this.eq(each.key(), aKey)) {
                each.value(aValue);
                return aValue;
            }
            ++i;
        }
        i = 0;
        while (i < hashIndex - 1) {
            each = this.elementsArray[i];
            if (each == null) {
                this.elementsArray[i] = new Association(aKey, aValue);
                ++this.elementCount;
                if (this.elementCount > elementsSize / 2) {
                    this.expand();
                }
                return aValue;
            }
            if (this.eq(each.key(), aKey)) {
                each.value(aValue);
                return aValue;
            }
            ++i;
        }
        return this.expand().put(aKey, aValue);
    }

    public Object put(Object aKey, boolean aValue) {
        return this.put(aKey, (Object)new Boolean(aValue));
    }

    public Object put(boolean aKey, Object aValue) {
        return this.put((Object)new Boolean(aKey), aValue);
    }

    public Object putIfAbsent(Object aKey, Object aValue) {
        Association each;
        int hashIndex;
        int elementsSize = this.elementsArray.length;
        int i = hashIndex = this.hashIndex(aKey);
        while (i < elementsSize) {
            each = this.elementsArray[i];
            if (each == null) {
                this.elementsArray[i] = new Association(aKey, aValue);
                ++this.elementCount;
                if (this.elementCount > elementsSize / 2) {
                    this.expand();
                }
                return aValue;
            }
            if (this.eq(each.key(), aKey)) {
                return aValue;
            }
            ++i;
        }
        i = 0;
        while (i < hashIndex - 1) {
            each = this.elementsArray[i];
            if (each == null) {
                this.elementsArray[i] = new Association(aKey, aValue);
                ++this.elementCount;
                if (this.elementCount > elementsSize / 2) {
                    this.expand();
                }
                return aValue;
            }
            if (this.eq(each.key(), aKey)) {
                return aValue;
            }
            ++i;
        }
        return this.expand().put(aKey, aValue);
    }

    public StDictionary rehash() {
        return this.rehash(this.elementsArray.length);
    }

    private StDictionary rehash(int newSize) {
        Association[] newElements = new Association[newSize];
        if (this.elementCount > 0) {
            int i = 0;
            while (i < this.elementsArray.length) {
                Association each = this.elementsArray[i];
                if (each != null) {
                    int hashIndex = this.hashIndex(each.key(), newSize);
                    if (hashIndex > newSize - 1) {
                        hashIndex = 0;
                    }
                    while (newElements[hashIndex] != null) {
                        if (++hashIndex <= newSize - 1) continue;
                        hashIndex = 0;
                    }
                    newElements[hashIndex] = each;
                }
                ++i;
            }
        }
        this.elementsArray = newElements;
        return this;
    }

    private void rehashTo(int anIndex) {
        int index = anIndex;
        int target = anIndex;
        int elementsSize = this.elementsArray.length;
        if (++index > elementsSize) {
            index = 0;
        }
        Association each = this.elementsArray[index];
        while (each != null) {
            int hashIndex = this.hashIndex(each.key());
            if (index < target ? hashIndex <= target && hashIndex > index : hashIndex <= target || hashIndex > index) {
                this.elementsArray[target] = each;
                target = index;
            }
            if (++index > elementsSize) {
                index = 0;
            }
            each = this.elementsArray[index];
        }
        this.elementsArray[target] = null;
    }

    public boolean remove(Object anObject) {
        throw new RuntimeException("Objects are removed from Dictionaries based on their keys!");
    }

    public void removeAllKeys(Object[] anArray) {
        this.primRemoveAllKeys(new ArrayIterator(anArray));
    }

    public void removeAllKeys(List aList) {
        this.primRemoveAllKeys(aList.iterator());
    }

    public Object removeKey(char aChar) {
        return this.removeKey(new Character(aChar));
    }

    public Object removeKey(int anInt) {
        return this.removeKey(new Integer(anInt));
    }

    public Object removeKey(Object aKey) {
        Association each;
        int hashIndex;
        int elementsSize = this.elementsArray.length;
        int i = hashIndex = this.hashIndex(aKey);
        while (i < elementsSize) {
            each = this.elementsArray[i];
            if (each == null) {
                return null;
            }
            if (this.eq(each.key(), aKey)) {
                this.rehashTo(i);
                --this.elementCount;
                return each.value();
            }
            ++i;
        }
        i = 0;
        while (i < hashIndex - 1) {
            each = this.elementsArray[i];
            if (each == null) {
                return null;
            }
            if (this.eq(each.key(), aKey)) {
                this.rehashTo(i);
                --this.elementCount;
                return each.value();
            }
            ++i;
        }
        return null;
    }

    public Object removeKey(boolean aBoolean) {
        return this.removeKey(new Boolean(aBoolean));
    }

    public int size() {
        return this.elementCount;
    }

    public void toStringForLargeOn(StringBuffer buf) {
        int max = this.size() - 1;
        int i = 0;
        Enumeration e = this.associationElements();
        buf.append("{");
        while (e.hasMoreElements()) {
            ((Association)e.nextElement()).assocToStringOn(buf);
            if (i++ >= 30) continue;
            buf.append(this.getNewLine());
        }
        buf.append("}");
        buf.append("......etc......");
        buf.append(this.getNewLine());
        while (e.hasMoreElements()) {
            ((Association)e.nextElement()).assocToStringOn(buf);
            if (i++ >= max) continue;
            buf.append(this.getNewLine());
        }
        buf.append("}");
    }

    public void toStringForSmallOn(StringBuffer buf) {
        int max = this.size() - 1;
        int i = 0;
        Enumeration e = this.associationElements();
        buf.append("{");
        while (e.hasMoreElements()) {
            ((Association)e.nextElement()).assocToStringOn(buf);
            if (i++ >= max) continue;
            buf.append(this.getNewLine());
        }
        buf.append("}");
    }

    public boolean valueEq(Object anObject1, Object anObject2) {
        return anObject1.equals(anObject2);
    }

    public Vector values() {
        return this.asVector();
    }
}

