/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ObjectQuery.crud.util;

import com.ibm.ObjectQuery.crud.util.ArrayIterator;
import com.ibm.ObjectQuery.crud.util.Association;
import com.ibm.ObjectQuery.crud.util.EqualityRelation;
import com.ibm.ObjectQuery.crud.util.HashFunction;
import com.ibm.ObjectQuery.crud.util.LookupTableAssociationEnumerator;
import com.ibm.ObjectQuery.crud.util.LookupTableEnumerator;
import com.ibm.ObjectQuery.crud.util.LookupTableKeyEnumerator;
import com.ibm.ObjectQuery.crud.util.StCollection;
import com.ibm.ObjectQuery.crud.util.StSet;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

public class StLookupTable
extends StCollection {
    private static final String copyright = "(c) Copyright IBM Corporation 2001.";
    private int elementCount;
    private Object[] keyArray;
    private Object[] valueArray;

    public StLookupTable() {
        this.initialize(StCollection.minimumSize());
    }

    public StLookupTable(int anInt) {
        this.initialize(anInt + Math.max(anInt, StCollection.minimumSize()));
    }

    public StLookupTable(EqualityRelation aRelation) {
        super(aRelation);
    }

    public StLookupTable(HashFunction aFuntion) {
        this.hashFunction(aFuntion);
    }

    public StLookupTable(HashFunction aFuntion, EqualityRelation aRelation) {
        super(aFuntion, aRelation);
    }

    private void aboutToAdd(int numberOfElements) {
        if (numberOfElements * 2 > this.keyArray.length) {
            this.rehash(numberOfElements * 2);
        }
    }

    public boolean add(Association anAssoc) {
        this.put(anAssoc.first(), anAssoc.second());
        return true;
    }

    public boolean add(Object anObj) {
        return this.add((Association)anObj);
    }

    public Enumeration associationElements() {
        return new LookupTableAssociationEnumerator(this);
    }

    private Object atUnique(Object aKey, Object anObject) {
        int hashIndex;
        int elementsSize = this.keyArray.length;
        int i = hashIndex = this.hashIndex(aKey);
        while (i < elementsSize) {
            if (this.keyArray[i] == null) {
                this.keyArray[i] = aKey;
                this.valueArray[i] = anObject;
                ++this.elementCount;
                if (this.elementCount > elementsSize / 2) {
                    this.expand();
                }
                return anObject;
            }
            ++i;
        }
        i = 0;
        while (i < hashIndex - 1) {
            if (this.keyArray[i] == null) {
                this.keyArray[i] = aKey;
                this.valueArray[i] = anObject;
                ++this.elementCount;
                if (this.elementCount > elementsSize / 2) {
                    this.expand();
                }
                return anObject;
            }
            ++i;
        }
        return this.expand().atUnique(aKey, anObject);
    }

    public void clear() {
        int i = 0;
        while (i < this.keyArray.length) {
            this.keyArray[i] = null;
            this.valueArray[i] = null;
            ++i;
        }
        this.elementCount = 0;
    }

    public Enumeration elements() {
        return new LookupTableEnumerator(this);
    }

    private StLookupTable expand() {
        return this.rehash(this.keyArray.length + this.keyArray.length);
    }

    public Object get(Object aKey) {
        Object each;
        int hashIndex;
        int elementsSize = this.keyArray.length;
        int i = hashIndex = this.hashIndex(aKey);
        while (i < elementsSize) {
            each = this.keyArray[i];
            if (each == null) {
                return null;
            }
            if (this.eq(each, aKey)) {
                return this.valueArray[i];
            }
            ++i;
        }
        i = 0;
        while (i < hashIndex - 1) {
            each = this.keyArray[i];
            if (each == null) {
                return null;
            }
            if (this.eq(each, aKey)) {
                return this.valueArray[i];
            }
            ++i;
        }
        return null;
    }

    public Object[] getKeyArray() {
        return this.keyArray;
    }

    public Object[] getValueArray() {
        return this.valueArray;
    }

    private int hashIndex(Object anObject) {
        return this.hashIndex(anObject, this.keyArray.length);
    }

    private int hashIndex(Object anObject, int aSize) {
        return (this.hashFunction().hashValue(anObject) & Integer.MAX_VALUE) % aSize;
    }

    public boolean includes(Object anObject) {
        int i = 0;
        while (i < this.keyArray.length) {
            if (this.keyArray[i] != null && this.valueEq(this.valueArray[i], anObject)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean includesKey(char aChar) {
        return this.includesKey(new Character(aChar));
    }

    public boolean includesKey(int anInteger) {
        return this.includesKey(new Integer(anInteger));
    }

    public boolean includesKey(Object aKey) {
        Object each;
        int hashIndex;
        int elementsSize = this.keyArray.length;
        int i = hashIndex = this.hashIndex(aKey);
        while (i < elementsSize) {
            each = this.keyArray[i];
            if (each == null) {
                return false;
            }
            if (this.eq(each, aKey)) {
                return true;
            }
            ++i;
        }
        i = 0;
        while (i < hashIndex - 1) {
            each = this.keyArray[i];
            if (each == null) {
                return false;
            }
            if (this.eq(each, aKey)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean includesKey(boolean aBoolean) {
        return this.includesKey(new Boolean(aBoolean));
    }

    public void initialize(int anInt) {
        super.initialize(anInt);
        this.elementCount = 0;
        this.keyArray = new Object[anInt];
        this.valueArray = new Object[anInt];
    }

    public boolean isEmpty() {
        return this.elementCount == 0;
    }

    public Iterator iterator() {
        return new LookupTableEnumerator(this);
    }

    public Object keyAtValue(Object anObject) {
        int i = 0;
        while (i < this.keyArray.length) {
            if (this.keyArray[i] != null && this.valueEq(this.valueArray[i], anObject)) {
                return this.keyArray[i];
            }
            ++i;
        }
        return null;
    }

    public Enumeration keyElements() {
        return new LookupTableKeyEnumerator(this);
    }

    public StSet keys() {
        StSet aSet = new StSet(this.size());
        int i = 0;
        while (i < this.keyArray.length) {
            if (this.keyArray[i] != null) {
                aSet.add(this.keyArray[i]);
            }
            ++i;
        }
        return aSet;
    }

    public boolean notEmpty() {
        return this.elementCount != 0;
    }

    private void primRemoveAllKeys(Iterator e) {
        int elementsSize = this.keyArray.length;
        while (e.hasNext()) {
            Object aKey = e.next();
            int hashIndex = this.hashIndex(aKey);
            boolean done = false;
            while (!done) {
                Object each;
                if (hashIndex >= elementsSize) {
                    hashIndex = 0;
                }
                if ((each = this.keyArray[hashIndex]) == null) {
                    done = true;
                    continue;
                }
                if (each == this || !this.eq(each, aKey)) continue;
                this.rehashTo(hashIndex);
                --this.elementCount;
                done = true;
            }
        }
    }

    public Object put(char[] aKey, Object aValue) {
        return this.put((Object)new String(aKey), aValue);
    }

    public Object put(int aKey, int aValue) {
        return this.put((Object)new Integer(aKey), (Object)new Integer(aValue));
    }

    public Object put(int aKey, Object aValue) {
        return this.put((Object)new Integer(aKey), aValue);
    }

    public Object put(Object aKey, char aValue) {
        return this.put(aKey, (Object)new Character(aValue));
    }

    public Object put(Object aKey, int aValue) {
        return this.put(aKey, (Object)new Integer(aValue));
    }

    public Object put(Object aKey, Object aValue) {
        Object each;
        int hashIndex;
        int elementsSize = this.keyArray.length;
        int i = hashIndex = this.hashIndex(aKey);
        while (i < elementsSize) {
            each = this.keyArray[i];
            if (each == null) {
                this.keyArray[i] = aKey;
                this.valueArray[i] = aValue;
                ++this.elementCount;
                if (this.elementCount > elementsSize / 2) {
                    this.expand();
                }
                return aValue;
            }
            if (this.eq(each, aKey)) {
                this.valueArray[i] = aValue;
                return aValue;
            }
            ++i;
        }
        i = 0;
        while (i < hashIndex - 1) {
            each = this.keyArray[i];
            if (each == null) {
                this.keyArray[i] = aKey;
                this.valueArray[i] = aValue;
                ++this.elementCount;
                if (this.elementCount > elementsSize / 2) {
                    this.expand();
                }
                return aValue;
            }
            if (this.eq(each, aKey)) {
                this.valueArray[i] = aValue;
                return aValue;
            }
            ++i;
        }
        return this.expand().put(aKey, aValue);
    }

    public Object put(Object aKey, boolean aValue) {
        return this.put(aKey, (Object)new Boolean(aValue));
    }

    public Object put(boolean aKey, Object aValue) {
        return this.put((Object)new Boolean(aKey), aValue);
    }

    public Object putIfAbsent(Object aKey, Object aValue) {
        Object each;
        int hashIndex;
        int elementsSize = this.keyArray.length;
        int i = hashIndex = this.hashIndex(aKey);
        while (i < elementsSize) {
            each = this.keyArray[i];
            if (each == null) {
                this.keyArray[i] = aKey;
                this.valueArray[i] = aValue;
                ++this.elementCount;
                if (this.elementCount > elementsSize / 2) {
                    this.expand();
                }
                return aValue;
            }
            if (this.eq(each, aKey)) {
                return aValue;
            }
            ++i;
        }
        i = 0;
        while (i < hashIndex - 1) {
            each = this.keyArray[i];
            if (each == null) {
                this.keyArray[i] = aKey;
                this.valueArray[i] = aValue;
                ++this.elementCount;
                if (this.elementCount > elementsSize / 2) {
                    this.expand();
                }
                return aValue;
            }
            if (this.eq(each, aKey)) {
                return aValue;
            }
            ++i;
        }
        return this.expand().put(aKey, aValue);
    }

    public StLookupTable rehash() {
        return this.rehash(this.keyArray.length);
    }

    private StLookupTable rehash(int newSize) {
        Object[] newKeys = new Object[newSize];
        Object[] newValues = new Object[newSize];
        if (this.elementCount > 0) {
            int i = 0;
            while (i < this.keyArray.length) {
                Object each = this.keyArray[i];
                if (each != null) {
                    int hashIndex = this.hashIndex(each, newSize);
                    if (hashIndex > newSize - 1) {
                        hashIndex = 0;
                    }
                    while (newKeys[hashIndex] != null) {
                        if (++hashIndex <= newSize - 1) continue;
                        hashIndex = 0;
                    }
                    newKeys[hashIndex] = each;
                    newValues[hashIndex] = this.valueArray[i];
                }
                ++i;
            }
        }
        this.keyArray = newKeys;
        this.valueArray = newValues;
        return this;
    }

    private void rehashTo(int anIndex) {
        int index = anIndex;
        int target = anIndex;
        int elementsSize = this.keyArray.length;
        if (++index > elementsSize) {
            index = 0;
        }
        Object each = this.keyArray[index];
        while (each != null) {
            int hashIndex = this.hashIndex(each);
            if (index < target ? hashIndex <= target && hashIndex > index : hashIndex <= target || hashIndex > index) {
                this.keyArray[target] = each;
                this.valueArray[target] = this.valueArray[index];
                target = index;
            }
            if (++index > elementsSize) {
                index = 0;
            }
            each = this.keyArray[index];
        }
        this.keyArray[target] = null;
        this.valueArray[target] = null;
    }

    public boolean remove(Object anObject) {
        throw new RuntimeException("Objects are removed from Dictionaries based on their keys!");
    }

    public void removeAllKeys(Object[] anArray) {
        this.primRemoveAllKeys(new ArrayIterator(anArray));
    }

    public void removeAllKeys(List aList) {
        this.primRemoveAllKeys(aList.iterator());
    }

    public Object removeKey(char aChar) {
        return this.removeKey(new Character(aChar));
    }

    public Object removeKey(int anInt) {
        return this.removeKey(new Integer(anInt));
    }

    public Object removeKey(Object aKey) {
        Object each;
        int hashIndex;
        int elementsSize = this.keyArray.length;
        int i = hashIndex = this.hashIndex(aKey);
        while (i < elementsSize) {
            each = this.keyArray[i];
            if (each == null) {
                return null;
            }
            if (this.eq(each, aKey)) {
                Object aValue = this.valueArray[i];
                this.rehashTo(i);
                --this.elementCount;
                return aValue;
            }
            ++i;
        }
        i = 0;
        while (i < hashIndex - 1) {
            each = this.keyArray[i];
            if (each == null) {
                return null;
            }
            if (this.eq(each, aKey)) {
                Object aValue = this.valueArray[i];
                this.rehashTo(i);
                --this.elementCount;
                return aValue;
            }
            ++i;
        }
        return null;
    }

    public Object removeKey(boolean aBoolean) {
        return this.removeKey(new Boolean(aBoolean));
    }

    public int size() {
        return this.elementCount;
    }

    public void toStringForLargeOn(StringBuffer buf) {
        int max = this.size() - 1;
        int i = 0;
        Enumeration e = this.associationElements();
        buf.append("{");
        while (e.hasMoreElements()) {
            ((Association)e.nextElement()).assocToStringOn(buf);
            if (i++ >= 30) continue;
            buf.append(this.getNewLine());
        }
        buf.append("}");
        buf.append("......etc......");
        buf.append(this.getNewLine());
        while (e.hasMoreElements()) {
            ((Association)e.nextElement()).assocToStringOn(buf);
            if (i++ >= max) continue;
            buf.append(this.getNewLine());
        }
        buf.append("}");
    }

    public void toStringForSmallOn(StringBuffer buf) {
        int max = this.size() - 1;
        int i = 0;
        Enumeration e = this.associationElements();
        buf.append("{");
        while (e.hasMoreElements()) {
            ((Association)e.nextElement()).assocToStringOn(buf);
            if (i++ >= max) continue;
            buf.append(this.getNewLine());
        }
        buf.append("}");
    }

    public boolean valueEq(Object anObject1, Object anObject2) {
        return anObject1.equals(anObject2);
    }

    public Vector values() {
        Vector<Object> aVector = new Vector<Object>(this.size());
        int i = 0;
        while (i < this.keyArray.length) {
            if (this.keyArray[i] != null) {
                aVector.addElement(this.valueArray[i]);
            }
            ++i;
        }
        return aVector;
    }
}

