/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ObjectQuery.crud.util;

import com.ibm.ObjectQuery.crud.util.ArrayIterator;
import com.ibm.ObjectQuery.crud.util.EqualityRelation;
import com.ibm.ObjectQuery.crud.util.HashFunction;
import com.ibm.ObjectQuery.crud.util.NullValue;
import com.ibm.ObjectQuery.crud.util.SetEnumerator;
import com.ibm.ObjectQuery.crud.util.StCollection;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;

public class StSet
extends StCollection
implements Set {
    private static final String copyright = "(c) Copyright IBM Corporation 2001.";
    private int elementCount;
    private Object[] elementsArray;

    public StSet() {
    }

    public StSet(int anInteger) {
        this.initialize(Math.max(anInteger + anInteger, StCollection.minimumSize()));
    }

    public StSet(EqualityRelation aRelation) {
        super(aRelation);
    }

    public StSet(HashFunction aFunction) {
        super(aFunction);
    }

    public StSet(HashFunction aFuntion, EqualityRelation aRelation) {
        super(aFuntion, aRelation);
    }

    public StSet(Object anObject) {
        this.initialize(1);
        this.add(anObject);
    }

    public StSet(Object anObj, Object anObj2) {
        this.initialize(2);
        this.add(anObj);
        this.add(anObj2);
    }

    public StSet(Object anObj, Object anObj2, Object anObj3) {
        this.initialize(3);
        this.add(anObj);
        this.add(anObj2);
        this.add(anObj3);
    }

    public StSet(Object anObj, Object anObj2, Object anObj3, Object anObj4) {
        this.initialize(4);
        this.add(anObj);
        this.add(anObj2);
        this.add(anObj3);
        this.add(anObj4);
    }

    public static StSet setOn(Collection aCollection) {
        StSet aSet = new StSet();
        aSet.addAll(aCollection);
        return aSet;
    }

    public static StSet setOn(Object[] anArray) {
        StSet aSet = new StSet();
        aSet.addAll(anArray);
        return aSet;
    }

    public static StSet setOn(String[] anArray) {
        StSet aSet = new StSet();
        aSet.addAll(anArray);
        return aSet;
    }

    public boolean add(char aChar) {
        return this.add(new Character(aChar));
    }

    public boolean add(int anInteger) {
        return this.add(new Integer(anInteger));
    }

    public boolean add(Object anObject) {
        Object each;
        int hashIndex;
        int elementsSize = this.elementsArray.length;
        Object newObject = this.wrapNull(anObject);
        int i = hashIndex = this.hashIndex(newObject);
        while (i < elementsSize) {
            each = this.elementsArray[i];
            if (each == null) {
                this.elementsArray[i] = newObject;
                if (this.elementCount++ > elementsSize / 2) {
                    this.expand();
                }
                return true;
            }
            if (this.eq(each, newObject)) {
                return false;
            }
            ++i;
        }
        i = 0;
        while (i < hashIndex) {
            each = this.elementsArray[i];
            if (each == null) {
                this.elementsArray[i] = newObject;
                if (this.elementCount++ > elementsSize / 2) {
                    this.expand();
                }
                return true;
            }
            if (this.eq(each, newObject)) {
                return false;
            }
            ++i;
        }
        this.expand().add(newObject);
        return true;
    }

    public boolean addAll(Object[] anArray) {
        this.primAddAll(new ArrayIterator(anArray), anArray.length);
        return true;
    }

    public boolean addAll(Collection aCollection) {
        this.primAddAll(aCollection.iterator(), aCollection.size());
        return true;
    }

    public StSet addNonNull(Object anObject) {
        if (anObject != null) {
            this.add(anObject);
        }
        return this;
    }

    private Object addUnique(Object anElement) {
        int hashIndex;
        int elementsSize = this.elementsArray.length;
        Object anObject = this.wrapNull(anElement);
        int i = hashIndex = this.hashIndex(anObject);
        while (i < elementsSize) {
            if (this.elementsArray[i] == null) {
                this.elementsArray[i] = anObject;
                ++this.elementCount;
                if (this.elementCount > elementsSize / 2) {
                    this.expand();
                }
                return anObject;
            }
            ++i;
        }
        i = 0;
        while (i < hashIndex) {
            if (this.elementsArray[i] == null) {
                this.elementsArray[i] = anObject;
                ++this.elementCount;
                if (this.elementCount > elementsSize / 2) {
                    this.expand();
                }
                return anObject;
            }
            ++i;
        }
        return this.expand().addUnique(anObject);
    }

    public Object[] asArray() {
        Object[] answer = new Object[this.elementCount];
        int answerIndex = 0;
        int i = 0;
        while (i < this.elementsArray.length) {
            if (this.elementsArray[i] != null) {
                answer[answerIndex++] = this.elementsArray[i];
            }
            ++i;
        }
        return answer;
    }

    public Vector asVector() {
        Vector<Object> answer = new Vector<Object>(this.elementCount);
        int i = 0;
        while (i < this.elementsArray.length) {
            if (this.elementsArray[i] != null) {
                answer.addElement(this.elementsArray[i]);
            }
            ++i;
        }
        return answer;
    }

    public void clear() {
        int i = 0;
        while (i < this.elementsArray.length) {
            this.elementsArray[i] = null;
            ++i;
        }
        this.elementCount = 0;
    }

    public Enumeration elements() {
        return new SetEnumerator(this);
    }

    private StSet expand() {
        return this.rehash(this.elementsArray.length + this.elementsArray.length);
    }

    public Object[] getElementsArray() {
        return this.elementsArray;
    }

    private int hashIndex(Object anObject) {
        return this.hashIndex(anObject, this.elementsArray.length);
    }

    private int hashIndex(Object anObject, int aSize) {
        return (this.hashFunction().hashValue(anObject) & Integer.MAX_VALUE) % aSize;
    }

    public boolean includes(int anInteger) {
        return this.includes(new Integer(anInteger));
    }

    public boolean includes(Object anObj) {
        Object each;
        int hashIndex;
        int elementsSize = this.elementsArray.length;
        Object anObject = this.wrapNull(anObj);
        int i = hashIndex = this.hashIndex(anObject);
        while (i < elementsSize) {
            each = this.elementsArray[i];
            if (each == null) {
                return false;
            }
            if (this.eq(each, anObject)) {
                return true;
            }
            ++i;
        }
        i = 0;
        while (i < hashIndex) {
            each = this.elementsArray[i];
            if (each == null) {
                return false;
            }
            if (this.eq(each, anObject)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void initialize(int anInt) {
        super.initialize(anInt);
        this.elementCount = 0;
        this.elementsArray = new Object[anInt];
    }

    public boolean isEmpty() {
        return this.elementCount == 0;
    }

    public Iterator iterator() {
        return new SetEnumerator(this);
    }

    public boolean notEmpty() {
        return this.elementCount != 0;
    }

    public int occurrences(Object anObject) {
        if (this.includes(anObject)) {
            return 1;
        }
        return 0;
    }

    private void primAddAll(Iterator e, int aSize) {
        int newSize = aSize * 2;
        if (newSize > this.elementsArray.length) {
            this.rehash(newSize);
        }
        int elementsSize = this.elementsArray.length;
        int growSize = elementsSize / 2;
        while (e.hasNext()) {
            Object each = this.wrapNull(e.next());
            int hashIndex = this.hashIndex(each);
            boolean flag = false;
            while (!flag) {
                Object element = this.elementsArray[hashIndex];
                if (element == null) {
                    this.elementsArray[hashIndex] = each;
                    if (++this.elementCount > growSize) {
                        this.expand();
                        elementsSize = this.elementsArray.length;
                        growSize = elementsSize / 2;
                    }
                    flag = true;
                    continue;
                }
                flag = this.eq(element, each);
                if (flag || ++hashIndex < this.elementsArray.length) continue;
                hashIndex = 0;
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private void primRemoveAll(Iterator e, int aSize) {
        block14: {
            elementsSize = this.elementsArray.length;
            count = 0;
            marker = new Object();
            if (aSize < this.elementCount / 2) ** GOTO lbl57
            indexes = new int[aSize];
            while (e.hasNext()) {
                each = this.wrapNull(e.next());
                index = this.hashIndex(each);
                flag = false;
                while (!flag) {
                    if (index >= this.elementsArray.length) {
                        index = 0;
                    }
                    if ((element = this.elementsArray[index]) == null) {
                        i = 0;
                        while (i < count) {
                            this.elementsArray[i] = null;
                            ++i;
                        }
                        this.elementCount -= count;
                        if (this.elementCount == 0) {
                            this.initialize(StCollection.minimumSize());
                        } else {
                            this.rehash(this.elementCount + this.elementCount);
                        }
                        flag = true;
                    }
                    flag = this.eq(each, element);
                    ++index;
                }
                this.elementsArray[index] = marker;
                indexes[++count] = index;
            }
            i = 0;
            while (i < count) {
                indexes[i] = -1;
                ++i;
            }
            this.elementCount -= count;
            if (this.elementCount == 0) {
                this.initialize(StCollection.minimumSize());
            } else {
                this.rehash(this.elementCount + this.elementCount);
            }
            break block14;
lbl-1000:
            // 1 sources

            {
                each = this.wrapNull(e.next());
                index = this.hashIndex(each);
                flag = false;
                while (!flag) {
                    if (index >= this.elementsArray.length) {
                        index = 0;
                    }
                    if ((element = this.elementsArray[index]) == null) {
                        flag = true;
                    }
                    flag = this.eq(each, element);
                    ++index;
                }
                this.rehashTo(index);
                --this.elementCount;
lbl57:
                // 2 sources

                ** while (e.hasNext())
            }
        }
    }

    public StSet rehash() {
        return this.rehash(this.elementsArray.length);
    }

    private StSet rehash(int newSize) {
        Object[] newElements = new Object[newSize];
        if (this.elementCount > 0) {
            int i = 0;
            while (i < this.elementsArray.length) {
                Object each = this.elementsArray[i];
                if (each != null) {
                    int hashIndex = this.hashIndex(each, newSize);
                    if (hashIndex > newSize - 1) {
                        hashIndex = 0;
                    }
                    while (newElements[hashIndex] != null) {
                        if (++hashIndex <= newSize - 1) continue;
                        hashIndex = 0;
                    }
                    newElements[hashIndex] = each;
                }
                ++i;
            }
        }
        this.elementsArray = newElements;
        return this;
    }

    private void rehashTo(int anIndex) {
        int index = anIndex;
        int target = anIndex;
        int elementsSize = this.elementsArray.length;
        if (++index >= elementsSize) {
            index = 0;
        }
        Object each = this.elementsArray[index];
        while (each != null) {
            int hashIndex = this.hashIndex(each);
            if (index < target ? hashIndex <= target && hashIndex > index : hashIndex <= target || hashIndex > index) {
                this.elementsArray[target] = each;
                target = index;
            }
            if (++index >= elementsSize) {
                index = 0;
            }
            each = this.elementsArray[index];
        }
        this.elementsArray[target] = null;
    }

    public boolean remove(int anInt) {
        return this.remove(new Integer(anInt));
    }

    public boolean remove(Object anObject) {
        Object each;
        int hashIndex;
        int elementsSize = this.elementsArray.length;
        Object oldObject = this.wrapNull(anObject);
        int i = hashIndex = this.hashIndex(oldObject);
        while (i < elementsSize) {
            each = this.elementsArray[i];
            if (each == null) {
                return false;
            }
            if (this.eq(each, oldObject)) {
                this.rehashTo(i);
                --this.elementCount;
                return true;
            }
            ++i;
        }
        i = 0;
        while (i < hashIndex) {
            each = this.elementsArray[i];
            if (each == null) {
                return false;
            }
            if (this.eq(each, oldObject)) {
                this.rehashTo(i);
                --this.elementCount;
                return true;
            }
            ++i;
        }
        return false;
    }

    public void removeAll(Object[] anArray) {
        this.primRemoveAll(new ArrayIterator(anArray), anArray.length);
    }

    public boolean removeAll(Collection aCollection) {
        int urSize = this.size();
        this.primRemoveAll(aCollection.iterator(), aCollection.size());
        return urSize - aCollection.size() == this.size();
    }

    public int size() {
        return this.elementCount;
    }

    private Object wrapNull(Object anObject) {
        return anObject == null ? NullValue.singleton() : anObject;
    }
}

