/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ObjectQuery.crud.util;

import com.ibm.ObjectQuery.crud.util.ArrayIterator;
import com.ibm.ObjectQuery.crud.util.ClassShortName;
import com.ibm.ObjectQuery.crud.util.GenericTreeNode;
import com.ibm.ObjectQuery.crud.util.Trace;
import java.util.Iterator;
import java.util.List;

public class Stack {
    private static final String copyright = "(c) Copyright IBM Corporation 2001.";
    private Object[] elementsIvar;
    private int index;
    private int last;

    public Stack() {
        this.initialize(Stack.minimumSize());
    }

    public Stack(int anInt) {
        this.initialize(anInt);
    }

    public void clear() {
        this.initialize(Stack.minimumSize());
    }

    public boolean contains(Object anObject) {
        Iterator it = this.iterator();
        while (it.hasNext()) {
            if (!it.next().equals(anObject)) continue;
            return true;
        }
        return false;
    }

    private void copyAndGrowBy(int newCapacity) {
        int oldCapacity = this.getElements().length;
        Object[] oldArray = this.getElements();
        this.setElements(new Object[newCapacity + oldCapacity]);
        System.arraycopy(oldArray, 0, this.getElements(), 0, this.index + 1);
    }

    public static void example() {
        Stack aStack = new Stack();
        Trace.traceOn();
        int i = 0;
        while (i < 5) {
            aStack.push(new GenericTreeNode(new Integer(i).toString()));
            aStack.push(null);
            Trace.show(aStack);
            ++i;
        }
        while (!aStack.isEmpty()) {
            Trace.show(aStack.pop());
            Trace.show(aStack);
        }
    }

    private Object[] getElements() {
        return this.elementsIvar;
    }

    public void initialize(int anInt) {
        this.setElements(new Object[anInt]);
        this.index = -1;
        this.last = anInt - 1;
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public Iterator iterator() {
        return new ArrayIterator(this.getElements());
    }

    public static int minimumSize() {
        return 16;
    }

    public Object peek() {
        return this.getElements()[this.index];
    }

    public Object pop() {
        Object aNode = this.getElements()[this.index];
        this.getElements()[this.index] = null;
        --this.index;
        return aNode;
    }

    public Object push(Object anObject) {
        if (this.index == this.last) {
            this.copyAndGrowBy(Math.max(this.last / 2, 8));
            this.last = this.getElements().length - 1;
        }
        this.getElements()[++this.index] = anObject;
        return anObject;
    }

    public void pushAll(List aList) {
        Iterator it = aList.iterator();
        while (it.hasNext()) {
            this.push(it.next());
        }
    }

    private void setElements(Object[] anArray) {
        this.elementsIvar = anArray;
    }

    public int size() {
        return this.index + 1;
    }

    public Object[] toArray() {
        Object[] anArray = new Object[this.getElements().length];
        System.arraycopy(this.getElements(), 0, anArray, 0, this.getElements().length);
        return anArray;
    }

    public synchronized String toString() {
        int max = this.size() - 1;
        StringBuffer buf = new StringBuffer();
        Iterator it = this.iterator();
        buf.append(ClassShortName.name(this));
        buf.append("[");
        int i = 0;
        while (i <= max) {
            Object anObject = it.next();
            String s = anObject == null ? "null" : anObject.toString();
            buf.append(s);
            if (i < max) {
                buf.append(", ");
            }
            ++i;
        }
        buf.append("]");
        return buf.toString();
    }
}

