/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ObjectQuery.crud.util;

import com.ibm.ObjectQuery.crud.util.Association;
import com.ibm.ObjectQuery.crud.util.ClassShortName;
import com.ibm.ObjectQuery.crud.util.PairwiseIterator;
import com.ibm.ObjectQuery.crud.util.StLookupTable;
import com.ibm.ObjectQuery.crud.util.VapStringReader;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;

public class SymbolLookup {
    private static final String copyright = "(c) Copyright IBM Corporation 2001.";
    private StLookupTable table;

    public SymbolLookup(Object[] anArray) {
        this.initialize(new PairwiseIterator(anArray));
    }

    public SymbolLookup(String aString) {
        List aList = new VapStringReader(aString).asBlankDelimitedSubstrings();
        this.initialize(new PairwiseIterator(aList));
    }

    public SymbolLookup(List aList) {
        this.initialize(new PairwiseIterator(aList));
    }

    public String asString() {
        StringBuffer aBuffer = new StringBuffer();
        Enumeration e = this.getTable().associationElements();
        while (e.hasMoreElements()) {
            Association each = (Association)e.nextElement();
            aBuffer.append(" ");
            aBuffer.append((String)each.key());
            aBuffer.append(" ");
            aBuffer.append((String)each.value());
        }
        return aBuffer.toString();
    }

    public String get(String aKey) {
        return (String)this.getTable().get(aKey);
    }

    protected StLookupTable getTable() {
        if (this.table == null) {
            this.table = new StLookupTable();
        }
        return this.table;
    }

    public void initialize(PairwiseIterator e) {
        while (e.hasNext()) {
            Association each = (Association)e.next();
            this.getTable().put(each.first(), each.second());
        }
    }

    public void put(String aKey, String aValue) {
        this.getTable().put((Object)aKey, (Object)aValue);
    }

    public Vector symbols() {
        return this.getTable().keys().asVector();
    }

    public synchronized String toString() {
        StringBuffer aBuffer = new StringBuffer();
        aBuffer.append(ClassShortName.name(this));
        if (this.getTable().size() - 1 < 100) {
            this.getTable().toStringForSmallOn(aBuffer);
        } else {
            this.getTable().toStringForLargeOn(aBuffer);
        }
        return aBuffer.toString();
    }

    public Vector values() {
        return this.getTable().values();
    }
}

