/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ObjectQuery.crud.util;

import com.ibm.ObjectQuery.crud.util.Association;
import com.ibm.ObjectQuery.crud.util.ClassShortName;
import com.ibm.ObjectQuery.crud.util.PairwiseIterator;
import com.ibm.ObjectQuery.crud.util.StLookupTable;
import com.ibm.ObjectQuery.crud.util.VapStringReader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;

public class SymbolTable {
    public static int DEFAULT = -1;
    private StLookupTable table;

    public SymbolTable(Object[] anArray) {
        this.initialize(new PairwiseIterator(anArray));
    }

    public SymbolTable(String aString) {
        List aList = new VapStringReader(aString).asBlankDelimitedSubstrings();
        this.initialize(new PairwiseIterator(aList));
    }

    public SymbolTable(List aList) {
        this.initialize(new PairwiseIterator(aList));
    }

    public String asString() {
        StringBuffer aBuffer = new StringBuffer();
        Enumeration e = this.getTable().associationElements();
        while (e.hasMoreElements()) {
            Association each = (Association)e.nextElement();
            aBuffer.append(" ");
            aBuffer.append((String)each.key());
            aBuffer.append(" ");
            aBuffer.append((String)each.value());
        }
        return aBuffer.toString();
    }

    public int get(String aKey) {
        Object anInteger = this.getTable().get(aKey);
        if (anInteger == null) {
            return DEFAULT;
        }
        return (Integer)anInteger;
    }

    public String getSymbol(int i) {
        return (String)this.getTable().get(new Integer(i));
    }

    protected StLookupTable getTable() {
        if (this.table == null) {
            this.table = new StLookupTable();
        }
        return this.table;
    }

    public void initialize(PairwiseIterator e) {
        while (e.hasNext()) {
            Association each = (Association)e.next();
            int anInt = Integer.parseInt((String)each.second());
            this.getTable().put(each.first(), anInt);
            this.getTable().put(anInt, each.first());
        }
    }

    public void put(String aKey, int aValue) {
        this.getTable().put((Object)aKey, (Object)new Integer(aValue));
    }

    public List symbols() {
        ArrayList aList = new ArrayList();
        Iterator it = this.getTable().keys().iterator();
        while (it.hasNext()) {
            Object each = it.next();
            if (each instanceof Integer) continue;
            aList.add(each);
        }
        return aList;
    }

    public synchronized String toString() {
        StringBuffer aBuffer = new StringBuffer();
        aBuffer.append(ClassShortName.name(this));
        if (this.getTable().size() - 1 < 100) {
            this.getTable().toStringForSmallOn(aBuffer);
        } else {
            this.getTable().toStringForLargeOn(aBuffer);
        }
        return aBuffer.toString();
    }

    public List values() {
        return this.getTable().values();
    }
}

