/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ObjectQuery.crud.util;

import com.ibm.ObjectQuery.crud.util.ClassShortName;
import com.ibm.ObjectQuery.crud.util.OutputDevice;
import com.ibm.ObjectQuery.crud.util.Printable;
import com.ibm.ObjectQuery.crud.util.TraceBuffer;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Enumeration;
import java.util.Vector;

public class Trace {
    private static Trace soleInstance = new Trace();
    private int level = 0;
    private boolean logFlag = false;
    private boolean includeThreadFlag = false;
    private Vector queryLog = new Vector();
    private Printable out = new OutputDevice();
    private static final String copyright = "Licensed Materials -- Property of IBM\n(c) Copyright International Business Machines Corporation, 1999";

    public void basicLog(Object anObject) {
        if (this.isLoggingOn() && anObject != null) {
            this.getQueryLog().addElement(anObject);
        }
    }

    public int basicLogSize() {
        return this.getQueryLog().size();
    }

    public void basicShow() {
        if (this.isTraceOn()) {
            Trace trace = this;
            synchronized (trace) {
                this.getOut().println();
            }
        }
    }

    public void basicShow(String aComment, float[] anArray) {
        StringBuffer aBuffer = new StringBuffer();
        if (this.isTraceOn()) {
            Trace trace = this;
            synchronized (trace) {
                this.printThread();
                aBuffer.append(aComment);
                aBuffer.append("[");
                int aLen = anArray.length;
                int i = 0;
                while (i < aLen) {
                    aBuffer.append(anArray[i]);
                    if (i == aLen - 1) {
                        aBuffer.append("]");
                    } else {
                        aBuffer.append(" ");
                    }
                    ++i;
                }
                this.getOut().println(aBuffer.toString());
            }
        }
    }

    public void basicShow(String aComment, int[] anArray) {
        StringBuffer aBuffer = new StringBuffer();
        if (this.isTraceOn()) {
            Trace trace = this;
            synchronized (trace) {
                this.printThread();
                aBuffer.append(aComment);
                aBuffer.append("[");
                int aLen = anArray == null ? 0 : anArray.length;
                int i = 0;
                while (i < aLen) {
                    aBuffer.append(anArray[i]);
                    if (i != aLen - 1) {
                        aBuffer.append(" ");
                    }
                    ++i;
                }
                aBuffer.append("]");
                this.getOut().println(aBuffer.toString());
            }
        }
    }

    public void basicShow(String aComment, long[] anArray) {
        StringBuffer aBuffer = new StringBuffer();
        if (this.isTraceOn()) {
            Trace trace = this;
            synchronized (trace) {
                this.printThread();
                aBuffer.append(aComment);
                aBuffer.append("[");
                int aLen = anArray.length;
                int i = 0;
                while (i < aLen) {
                    aBuffer.append(anArray[i]);
                    if (i == aLen - 1) {
                        aBuffer.append("]");
                    } else {
                        aBuffer.append(" ");
                    }
                    ++i;
                }
                this.getOut().println(aBuffer.toString());
            }
        }
    }

    public void basicShow(String aComment, Object[] anArray) {
        StringBuffer aBuffer = new StringBuffer();
        if (this.isTraceOn()) {
            Trace trace = this;
            synchronized (trace) {
                this.printThread();
                aBuffer.append(aComment);
                aBuffer.append("[");
                int aLen = anArray.length;
                int i = 0;
                while (i < aLen) {
                    if (anArray[i] == null) {
                        aBuffer.append("null");
                    } else {
                        aBuffer.append(anArray[i].toString());
                    }
                    if (i == aLen - 1) {
                        aBuffer.append("]");
                    } else {
                        aBuffer.append(" ");
                    }
                    ++i;
                }
                this.getOut().println(aBuffer.toString());
            }
        }
    }

    public void basicShow(String aComment, boolean[] anArray) {
        StringBuffer aBuffer = new StringBuffer();
        if (this.isTraceOn()) {
            Trace trace = this;
            synchronized (trace) {
                this.printThread();
                aBuffer.append(aComment);
                aBuffer.append("[");
                int aLen = anArray.length;
                int i = 0;
                while (i < aLen) {
                    aBuffer.append(anArray[i]);
                    if (i == aLen - 1) {
                        aBuffer.append("]");
                    } else {
                        aBuffer.append(" ");
                    }
                    ++i;
                }
                this.getOut().println(aBuffer.toString());
            }
        }
    }

    public void basicShow(String aComment, Object anObject) {
        if (this.isTraceOn()) {
            Trace trace = this;
            synchronized (trace) {
                this.printThread();
                this.getOut().print(aComment);
                if (anObject == null) {
                    this.getOut().println("null");
                } else {
                    this.getOut().println(anObject);
                }
            }
        }
    }

    public void basicShow(String aComment, Enumeration e) {
        if (this.isTraceOn()) {
            Trace trace = this;
            synchronized (trace) {
                this.printThread();
                this.getOut().println(aComment);
                while (e.hasMoreElements()) {
                    this.getOut().println(e.nextElement().toString());
                }
            }
        }
    }

    private void basicShowException(Throwable anException, Object anObject, String aString, boolean aFlag) {
        if (this.isTraceOn()) {
            Trace trace = this;
            synchronized (trace) {
                this.printThread();
                StringBuffer buffer = this.getExceptionOccurredBuffer();
                if (anObject != null) {
                    buffer.append(ClassShortName.name(anObject));
                }
                buffer.append(">>");
                if (aString == null) {
                    buffer.append("<unknown method>");
                } else {
                    buffer.append(aString);
                }
                this.basicShowException(anException, buffer, aFlag);
            }
        }
    }

    private void basicShowException(Throwable anException, StringBuffer aStringBuffer, boolean aFlag) {
        StringBuffer buffer = aStringBuffer == null ? this.getExceptionOccurredBuffer() : aStringBuffer;
        buffer.append(" ");
        if (anException == null) {
            buffer.append("<unknown error>");
        } else {
            buffer.append(anException.getMessage());
        }
        this.getOut().println(buffer.toString());
        if (aFlag) {
            this.dumpStack(anException);
        }
    }

    public void basicShowLine() {
        if (this.isTraceOn()) {
            Trace trace = this;
            synchronized (trace) {
                this.getOut().println("_________________________________________________________");
            }
        }
    }

    public void basicShowSection(String aTitle) {
        if (this.isTraceOn()) {
            Trace trace = this;
            synchronized (trace) {
                this.printSection(aTitle);
            }
        }
    }

    public void basicShowStack(Exception e) {
        if (this.isTraceOn()) {
            Trace trace = this;
            synchronized (trace) {
                this.dumpStack(e);
            }
        }
    }

    public void basicShowWithClass(String aComment, Object anObject, Object anObject2) {
        StringBuffer aBuffer = new StringBuffer();
        aBuffer.append(ClassShortName.name(anObject));
        aBuffer.append(": ");
        aBuffer.append(aComment);
        Trace.getTrace().basicShow(aBuffer.toString(), anObject2 == null ? "" : anObject);
    }

    public void basicStartLog() {
        this.logFlagOn();
        this.resetQueryLog();
    }

    public void basicStopLog() {
        this.logFlagOff();
        this.resetQueryLog();
    }

    public void clearLog() {
        this.resetQueryLog();
    }

    public static void close() {
        if (Trace.getTrace().isUsingBuffer()) {
            Trace.getTrace().closeOut();
            return;
        }
        if (!Trace.getTrace().isUsingSystemOut()) {
            Trace.getTrace().closeOut();
        }
    }

    public void closeOut() {
        this.getOut().close();
    }

    public static void doNotIncludeThread() {
        Trace.getTrace().doNotIncludeThreadInTrace();
    }

    public void doNotIncludeThreadInTrace() {
        this.includeThreadFlag = false;
    }

    private void dumpStack(Throwable anException) {
        StringWriter aSw = new StringWriter();
        PrintWriter aPw = new PrintWriter(aSw);
        anException.printStackTrace(aPw);
        this.getOut().println(aSw.toString());
    }

    public static void error() {
        throw new RuntimeException();
    }

    public static void error(String aMsg) {
        throw new RuntimeException(aMsg);
    }

    private StringBuffer getExceptionOccurredBuffer() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("EXCEPTION OCCURRED => ");
        return buffer;
    }

    private int getLevel() {
        return this.level;
    }

    private boolean getLogFlag() {
        return this.logFlag;
    }

    public Printable getOut() {
        return this.out;
    }

    public Vector getQueryLog() {
        if (this.queryLog == null) {
            this.queryLog = new Vector();
        }
        return this.queryLog;
    }

    protected String getThreadName() {
        Thread aThread = Thread.currentThread();
        StringBuffer aBuffer = new StringBuffer();
        aBuffer.append(aThread.getName());
        aBuffer.append("-");
        aBuffer.append(aThread.getPriority());
        if (aThread.getThreadGroup() != null) {
            aBuffer.append("-");
            aBuffer.append(aThread.getThreadGroup().getName());
        }
        aBuffer.append(" <hc ");
        aBuffer.append(aThread.hashCode());
        aBuffer.append(">");
        return aBuffer.toString();
    }

    public static synchronized Trace getTrace() {
        if (soleInstance == null) {
            soleInstance = new Trace();
        }
        return soleInstance;
    }

    public static int getTraceLevel() {
        return Trace.getTrace().getLevel();
    }

    public static void halt() {
        throw new RuntimeException("halting");
    }

    public static void includeThread() {
        Trace.getTrace().includeThreadInTrace();
    }

    public void includeThreadInTrace() {
        this.includeThreadFlag = true;
    }

    public boolean isIncludingThreadInTrace() {
        return this.includeThreadFlag;
    }

    public static boolean isLevelOne() {
        return Trace.getTrace().getLevel() >= 1;
    }

    public static boolean isLevelThree() {
        return Trace.getTrace().getLevel() >= 3;
    }

    public static boolean isLevelTwo() {
        return Trace.getTrace().getLevel() >= 2;
    }

    public boolean isLoggingOn() {
        return this.getLogFlag();
    }

    public static boolean isOn() {
        return Trace.getTrace().isTraceOn();
    }

    public boolean isTraceOn() {
        return this.getLevel() > 0;
    }

    public boolean isUsingBuffer() {
        return this.getOut() instanceof TraceBuffer;
    }

    public boolean isUsingSystemOut() {
        return this.getOut().isUsingSystemOut();
    }

    public void levelOne() {
        this.setLevel(1);
    }

    public void levelThree() {
        this.setLevel(3);
    }

    public void levelTwo() {
        this.setLevel(2);
    }

    public static void log(Object anObject) {
        Trace.getTrace().basicLog(anObject);
    }

    public void logFlagOff() {
        this.setLogFlag(false);
    }

    public void logFlagOn() {
        this.setLogFlag(true);
    }

    public static int logSize() {
        return Trace.getTrace().basicLogSize();
    }

    public static void main(String[] args) {
        if (args[0].equalsIgnoreCase("on")) {
            Trace.traceOn();
            Trace.show("trace_is_now_on");
        } else {
            Trace.show("turning_trace_off");
            Trace.traceOff();
        }
    }

    public void noTrace() {
        this.setLevel(0);
    }

    public static void openTraceFile(String aFileName) throws IOException {
        FileOutputStream aFileStream = new FileOutputStream(aFileName);
        Trace.getTrace().setOut(aFileStream);
    }

    public void printSection(String aTitle) {
        String aString = aTitle == null ? "" : aTitle;
        StringBuffer aBuffer = new StringBuffer();
        int j = (80 - aString.length()) / 2;
        int i = 0;
        while (i < j) {
            aBuffer.append("=");
            ++i;
        }
        aBuffer.append(aString);
        i = 0;
        while (i < j) {
            aBuffer.append("=");
            ++i;
        }
        this.getOut().println(aBuffer.toString());
    }

    public void printThread() {
        if (!this.isIncludingThreadInTrace()) {
            return;
        }
        Thread aThread = Thread.currentThread();
        this.getOut().print("[");
        this.getOut().print(aThread);
        this.getOut().print(" <");
        this.getOut().print(aThread.hashCode());
        this.getOut().print(">] ");
    }

    public static void reset() {
        Trace.close();
        soleInstance = null;
    }

    private void resetQueryLog() {
        this.queryLog = null;
    }

    private void setLevel(int i) {
        this.level = i;
    }

    private void setLogFlag(boolean aFlag) {
        this.logFlag = aFlag;
    }

    public void setOut(Printable anOut) {
        this.out = anOut;
    }

    public void setOut(FileOutputStream aStream) {
        this.out = new OutputDevice(aStream);
    }

    public void setOut(PrintStream aStream) {
        this.out = new OutputDevice(aStream);
    }

    public void setOut(StringBuffer aBuffer) {
        this.out = new OutputDevice(aBuffer);
    }

    public void setToSystemOut() {
        this.setOut(System.out);
    }

    public void setToTraceBuffer() {
        this.setOut(new TraceBuffer());
    }

    public void setToTraceBuffer(FileOutputStream aStream) {
        this.setOut(new TraceBuffer(aStream));
    }

    public void setToTraceBuffer(PrintStream aStream) {
        this.setOut(new TraceBuffer(aStream));
    }

    public void setToTraceBuffer(StringBuffer aBuffer) {
        this.setOut(new TraceBuffer(aBuffer));
    }

    public void setTraceOff() {
        this.setLevel(0);
    }

    public void setTraceOn() {
        this.setLevel(1);
    }

    public static void show() {
        Trace.getTrace().basicShow();
    }

    public static void show(byte[] aByteArray) {
        Trace.getTrace().basicShow("", (Object)aByteArray);
    }

    public static void show(byte[] aByteArray, int anInteger) {
        if (Trace.getTrace().getLevel() >= anInteger) {
            Trace.getTrace().basicShow("", (Object)aByteArray);
        }
    }

    public static void show(char[] aChar) {
        Trace.getTrace().basicShow("", (Object)aChar);
    }

    public static void show(char[] aChar, int anInteger) {
        if (Trace.getTrace().getLevel() >= anInteger) {
            Trace.getTrace().basicShow("", (Object)aChar);
        }
    }

    public static void show(double[] aDouble) {
        Trace.getTrace().basicShow("", (Object)aDouble);
    }

    public static void show(double[] aDouble, int anInteger) {
        if (Trace.getTrace().getLevel() >= anInteger) {
            Trace.getTrace().basicShow("", (Object)aDouble);
        }
    }

    public static void show(float[] aFloatArray) {
        Trace.getTrace().basicShow("", aFloatArray);
    }

    public static void show(float[] aFloatArray, int anInteger) {
        if (Trace.getTrace().getLevel() >= anInteger) {
            Trace.getTrace().basicShow("", aFloatArray);
        }
    }

    public static void show(int[] anIntegerArray) {
        Trace.getTrace().basicShow("", anIntegerArray);
    }

    public static void show(int[] anIntegerArray, int anInteger) {
        if (Trace.getTrace().getLevel() >= anInteger) {
            Trace.getTrace().basicShow("", anIntegerArray);
        }
    }

    public static void show(long[] aLongArray) {
        Trace.getTrace().basicShow("", aLongArray);
    }

    public static void show(long[] aLongArray, int anInteger) {
        if (Trace.getTrace().getLevel() >= anInteger) {
            Trace.getTrace().basicShow("", aLongArray);
        }
    }

    public static void show(Object[] anObjectArray) {
        Trace.getTrace().basicShow("", anObjectArray);
    }

    public static void show(Object[] anObjectArray, int anInteger) {
        if (Trace.getTrace().getLevel() >= anInteger) {
            Trace.getTrace().basicShow("", anObjectArray);
        }
    }

    public static void show(char aChar) {
        Trace.getTrace().basicShow("", new Character(aChar));
    }

    public static void show(char aChar, int anInteger) {
        if (Trace.getTrace().getLevel() >= anInteger) {
            Trace.getTrace().basicShow("", new Character(aChar));
        }
    }

    public static void show(double aDouble) {
        Trace.getTrace().basicShow("", new Double(aDouble));
    }

    public static void show(double aDouble, int anInteger) {
        if (Trace.getTrace().getLevel() >= anInteger) {
            Trace.getTrace().basicShow("", new Double(aDouble));
        }
    }

    public static void show(float aFloat) {
        Trace.getTrace().basicShow("", new Float(aFloat));
    }

    public static void show(float aFloat, int anInteger) {
        if (Trace.getTrace().getLevel() >= anInteger) {
            Trace.getTrace().basicShow("", new Float(aFloat));
        }
    }

    public static void show(int anInteger) {
        Trace.getTrace().basicShow("", new Integer(anInteger));
    }

    public static void show(int anInteger, int anInteger2) {
        if (Trace.getTrace().getLevel() >= anInteger2) {
            Trace.getTrace().basicShow("", new Integer(anInteger));
        }
    }

    public static void show(long aLong) {
        Trace.getTrace().basicShow("", new Long(aLong));
    }

    public static void show(long aLong, int anInteger) {
        if (Trace.getTrace().getLevel() >= anInteger) {
            Trace.getTrace().basicShow("", new Long(aLong));
        }
    }

    public static void show(Exception anException) {
        Trace.showException(anException, null, null, false);
    }

    public static void show(Object anObject) {
        Trace.getTrace().basicShow("", anObject);
    }

    public static void show(Object anObject, int anInteger) {
        if (Trace.getTrace().getLevel() >= anInteger) {
            Trace.getTrace().basicShow("", anObject);
        }
    }

    public static void show(String aComment, byte[] aByteArray) {
        Trace.getTrace().basicShow(aComment, (Object)aByteArray);
    }

    public static void show(String aComment, byte[] aByteArray, int anInteger) {
        if (Trace.getTrace().getLevel() >= anInteger) {
            Trace.getTrace().basicShow(aComment, (Object)aByteArray);
        }
    }

    public static void show(String aComment, char[] aChar) {
        Trace.getTrace().basicShow(aComment, (Object)aChar);
    }

    public static void show(String aComment, char[] aChar, int anInteger) {
        if (Trace.getTrace().getLevel() >= anInteger) {
            Trace.getTrace().basicShow(aComment, (Object)aChar);
        }
    }

    public static void show(String aComment, double[] aDouble) {
        Trace.getTrace().basicShow(aComment, (Object)aDouble);
    }

    public static void show(String aComment, double[] aDouble, int anInteger) {
        if (Trace.getTrace().getLevel() >= anInteger) {
            Trace.getTrace().basicShow(aComment, (Object)aDouble);
        }
    }

    public static void show(String aComment, float[] aFloatArray) {
        Trace.getTrace().basicShow(aComment, aFloatArray);
    }

    public static void show(String aComment, float[] aFloatArray, int anInteger) {
        if (Trace.getTrace().getLevel() >= anInteger) {
            Trace.getTrace().basicShow(aComment, aFloatArray);
        }
    }

    public static void show(String aComment, int[] anIntegerArray) {
        Trace.getTrace().basicShow(aComment, anIntegerArray);
    }

    public static void show(String aComment, int[] anIntegerArray, int anInteger) {
        if (Trace.getTrace().getLevel() >= anInteger) {
            Trace.getTrace().basicShow(aComment, anIntegerArray);
        }
    }

    public static void show(String aComment, long[] aLongArray) {
        Trace.getTrace().basicShow(aComment, aLongArray);
    }

    public static void show(String aComment, long[] aLongArray, int anInteger) {
        if (Trace.getTrace().getLevel() >= anInteger) {
            Trace.getTrace().basicShow(aComment, aLongArray);
        }
    }

    public static void show(String aComment, Object[] anObjectArray) {
        Trace.getTrace().basicShow(aComment, anObjectArray);
    }

    public static void show(String aComment, Object[] anObjectArray, int anInteger) {
        if (Trace.getTrace().getLevel() >= anInteger) {
            Trace.getTrace().basicShow(aComment, anObjectArray);
        }
    }

    public static void show(String aComment, char aChar) {
        Trace.getTrace().basicShow(aComment, new Character(aChar));
    }

    public static void show(String aComment, char aChar, int anInteger) {
        if (Trace.getTrace().getLevel() >= anInteger) {
            Trace.getTrace().basicShow(aComment, new Character(aChar));
        }
    }

    public static void show(String aComment, double aDouble) {
        Trace.getTrace().basicShow(aComment, new Double(aDouble));
    }

    public static void show(String aComment, double aDouble, int anInteger) {
        if (Trace.getTrace().getLevel() >= anInteger) {
            Trace.getTrace().basicShow(aComment, new Double(aDouble));
        }
    }

    public static void show(String aComment, float aFloat) {
        Trace.getTrace().basicShow(aComment, new Float(aFloat));
    }

    public static void show(String aComment, float aFloat, int anInteger) {
        if (Trace.getTrace().getLevel() >= anInteger) {
            Trace.getTrace().basicShow(aComment, new Float(aFloat));
        }
    }

    public static void show(String aComment, int anInteger) {
        Trace.getTrace().basicShow(aComment, new Integer(anInteger));
    }

    public static void show(String aComment, int anInteger, int anInteger2) {
        if (Trace.getTrace().getLevel() >= anInteger2) {
            Trace.getTrace().basicShow(aComment, new Integer(anInteger));
        }
    }

    public static void show(String aComment, long aLong) {
        Trace.getTrace().basicShow(aComment, new Long(aLong));
    }

    public static void show(String aComment, long aLong, int anInteger) {
        if (Trace.getTrace().getLevel() >= anInteger) {
            Trace.getTrace().basicShow(aComment, new Long(aLong));
        }
    }

    public static void show(String aComment, Object anObject) {
        Trace.getTrace().basicShow(aComment, anObject);
    }

    public static void show(String aComment, Object anObject, int anInteger) {
        if (Trace.getTrace().getLevel() >= anInteger) {
            Trace.getTrace().basicShow(aComment, anObject);
        }
    }

    public static void show(String aComment, Enumeration aCollection) {
        Trace.getTrace().basicShow(aComment, aCollection);
    }

    public static void show(String aComment, boolean aBoolean) {
        Trace.getTrace().basicShow(aComment, new Boolean(aBoolean));
    }

    public static void show(String aComment, boolean aBoolean, int anInteger) {
        if (Trace.getTrace().getLevel() >= anInteger) {
            Trace.getTrace().basicShow(aComment, new Boolean(aBoolean));
        }
    }

    public static void show(Enumeration aCollection) {
        Trace.getTrace().basicShow("", aCollection);
    }

    public static void show(boolean aBoolean) {
        Trace.getTrace().basicShow("", new Boolean(aBoolean));
    }

    public static void show(boolean aBoolean, int anInteger) {
        if (Trace.getTrace().getLevel() >= anInteger) {
            Trace.getTrace().basicShow("", new Boolean(aBoolean));
        }
    }

    public static void showException(Exception anException, Object anObject, String aString) {
        Trace.showException(anException, anObject, aString, false);
    }

    public static void showException(Exception anException, Object anObject, String aString, boolean aFlag) {
        Trace.getTrace().basicShowException(anException, anObject, aString, aFlag);
    }

    public static void showException(Exception anException, String aString, boolean aFlag) {
        Trace.getTrace().basicShowException(anException, null, aString, aFlag);
    }

    public static void showLine() {
        Trace.getTrace().basicShowLine();
    }

    public static void showSection(String aTitle) {
        Trace.getTrace().basicShowSection(aTitle);
    }

    public static void showStack(Exception e) {
        Trace.getTrace().basicShowStack(e);
    }

    public static void showWithClass(String aComment, Object anObject, int anInt) {
        if (Trace.getTrace().getLevel() >= anInt) {
            Trace.getTrace().basicShowWithClass(aComment, anObject, null);
        }
    }

    public static void showWithClass(String aComment, Object anObject, Object anObject2, int anInt) {
        if (Trace.getTrace().getLevel() >= anInt) {
            Trace.getTrace().basicShowWithClass(aComment, anObject, anObject2);
        }
    }

    public static void startLog() {
        Trace.getTrace().basicStartLog();
    }

    public static void stopLog() {
        Trace.getTrace().basicStopLog();
    }

    public static void traceLevelOne() {
        Trace.getTrace().levelOne();
    }

    public static void traceLevelThree() {
        Trace.getTrace().levelThree();
    }

    public static void traceLevelTwo() {
        Trace.getTrace().levelTwo();
    }

    public static synchronized void traceOff() {
        Trace.getTrace().setTraceOff();
    }

    public static synchronized void traceOn() {
        Trace.getTrace().setTraceOn();
    }

    public static void useSystemOut() {
        Trace.getTrace().setToSystemOut();
    }

    public static void useTraceBuffer() {
        Trace.getTrace().setToTraceBuffer();
    }

    public static void useTraceBuffer(FileOutputStream aStream) {
        Trace.getTrace().setToTraceBuffer(aStream);
    }

    public static void useTraceBuffer(PrintStream aStream) {
        Trace.getTrace().setToTraceBuffer(aStream);
    }

    public static void useTraceBuffer(StringBuffer aBuffer) {
        Trace.getTrace().setToTraceBuffer(aBuffer);
    }
}

