/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.wdo.mediator.rdb.graphbuilder.impl;

import com.ibm.websphere.wdo.mediator.rdb.metadata.Column;
import com.ibm.ws.wdo.mediator.rdb.queryengine.QueryResultDescriptor;
import java.util.List;

public class GraphBuilderMetadata {
    private Column[] columns;
    private int columnCount;
    private boolean paged = false;

    public GraphBuilderMetadata(QueryResultDescriptor queryResultDescriptor, boolean bl) {
        this.paged = bl;
        this.columnCount = queryResultDescriptor.size();
        this.columns = new Column[this.getColumnCount()];
        List list = queryResultDescriptor.columns();
        if (this.isPagingEnabled()) {
            for (int i = 1; i < this.getColumnCount(); ++i) {
                this.columns[i] = (Column)list.get(i - 1);
            }
        } else {
            for (int i = 0; i < this.getColumnCount(); ++i) {
                this.columns[i] = (Column)list.get(i);
            }
        }
    }

    public String getColumnName(int n) {
        return this.columns[n - 1].getName();
    }

    public String getTableName(int n) {
        return this.columns[n - 1].getTable().getName();
    }

    public int getColumnCount() {
        return this.columnCount;
    }

    public int getType(int n) {
        return this.columns[n - 1].getType();
    }

    public int getStartIndex() {
        if (this.isPagingEnabled()) {
            return 2;
        }
        return 1;
    }

    public int getEndIndex() {
        return this.getColumnCount();
    }

    public boolean isPagingEnabled() {
        return this.paged;
    }
}

