/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.wdo.mediator.rdb.graphbuilder.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.etools.wdo.DataObject;
import com.ibm.websphere.wdo.mediator.rdb.exception.InvalidMetadataException;
import com.ibm.websphere.wdo.mediator.rdb.graphbuilder.PagedGraphInfo;
import com.ibm.websphere.wdo.mediator.rdb.graphbuilder.impl.GraphBuilderMetadata;
import com.ibm.websphere.wdo.mediator.rdb.graphbuilder.impl.ResultSetRow;
import com.ibm.websphere.wdo.mediator.rdb.graphbuilder.impl.TableRegistry;
import com.ibm.websphere.wdo.mediator.rdb.metadata.Column;
import com.ibm.websphere.wdo.mediator.rdb.metadata.Key;
import com.ibm.websphere.wdo.mediator.rdb.metadata.Metadata;
import com.ibm.websphere.wdo.mediator.rdb.metadata.Relationship;
import com.ibm.ws.wdo.mediator.rdb.queryengine.QueryResultDescriptor;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.util.EList;

public class ResultSetProcessor {
    protected static final TraceComponent tc = Tr.register((Class)(class$com$ibm$websphere$wdo$mediator$rdb$graphbuilder$impl$ResultSetProcessor == null ? (class$com$ibm$websphere$wdo$mediator$rdb$graphbuilder$impl$ResultSetProcessor = ResultSetProcessor.class$("com.ibm.websphere.wdo.mediator.rdb.graphbuilder.impl.ResultSetProcessor")) : class$com$ibm$websphere$wdo$mediator$rdb$graphbuilder$impl$ResultSetProcessor), (String)"JDBCMediator", (String)"jdbcmediator.properties");
    private DataObject dataGraph;
    private Metadata metadata;
    private TableRegistry registry;
    static /* synthetic */ Class class$com$ibm$websphere$wdo$mediator$rdb$graphbuilder$impl$ResultSetProcessor;

    public ResultSetProcessor(Metadata metadata, DataObject dataObject) {
        this.metadata = metadata;
        this.dataGraph = dataObject;
        this.registry = new TableRegistry();
    }

    public void process(ResultSet resultSet, PagedGraphInfo pagedGraphInfo, QueryResultDescriptor queryResultDescriptor, int n, boolean bl) throws SQLException, InvalidMetadataException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"process");
        }
        if (resultSet == null) {
            return;
        }
        boolean bl2 = pagedGraphInfo != null;
        GraphBuilderMetadata graphBuilderMetadata = new GraphBuilderMetadata(queryResultDescriptor, bl2);
        for (int i = 0; resultSet.next() && i < n; ++i) {
            ResultSetRow resultSetRow = new ResultSetRow(resultSet, graphBuilderMetadata);
            this.processRelationships(resultSetRow, bl);
            if (!bl2) continue;
            this.processPageInfo(pagedGraphInfo, i, resultSet);
        }
        resultSet.close();
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"process");
        }
    }

    protected void processPageInfo(PagedGraphInfo pagedGraphInfo, int n, ResultSet resultSet) throws SQLException {
        if (n == 0) {
            pagedGraphInfo.setFirstIndex(resultSet.getInt(1));
        } else {
            pagedGraphInfo.setLastIndex(resultSet.getInt(1));
        }
    }

    private void processRelationships(ResultSetRow resultSetRow, boolean bl) {
        EList eList;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"processRelationships");
        }
        if ((eList = this.metadata.getRelationships()).size() == 0) {
            this.getTable(resultSetRow, this.metadata.getRootTable().getPrimaryKey(), bl);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"processRelationships");
            }
            return;
        }
        Iterator iterator = eList.iterator();
        while (iterator.hasNext()) {
            DataObject dataObject;
            Relationship relationship = (Relationship)iterator.next();
            DataObject dataObject2 = this.getTable(resultSetRow, relationship.getParentKey().getTable().getPrimaryKey(), bl);
            if (dataObject2 == null || (dataObject = this.getTable(resultSetRow, relationship.getChildKey().getTable().getPrimaryKey(), bl)) == null) continue;
            if (relationship.isToMany()) {
                List list = (List)dataObject2.get(relationship.getName());
                list.add(dataObject);
                continue;
            }
            dataObject2.set(relationship.getName(), (Object)dataObject);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"processRelationships");
        }
    }

    private DataObject getTable(ResultSetRow resultSetRow, Key key, boolean bl) {
        DataObject dataObject;
        HashMap hashMap;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getTable");
        }
        if ((hashMap = resultSetRow.getTable(key.getTable().getName())) == null) {
            return null;
        }
        List list = this.createPrimaryKeyValue(key, hashMap);
        if (list == null) {
            return null;
        }
        boolean bl2 = false;
        if (bl && key.getTable().getMetadata().getRootTable().equals(key.getTable())) {
            bl2 = true;
        }
        if ((dataObject = this.registry.get(key.getTable().getName(), list)) == null && !bl2) {
            dataObject = this.dataGraph.createDataObject(key.getTable().getName());
            Iterator iterator = hashMap.keySet().iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                dataObject.set(string, hashMap.get(string));
            }
            this.registry.put(key.getTable().getName(), list, dataObject);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getTable");
        }
        return dataObject;
    }

    private List createPrimaryKeyValue(Key key, HashMap hashMap) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"createPrimaryKeyValue");
        }
        ArrayList arrayList = new ArrayList();
        Iterator iterator = key.getColumns().iterator();
        while (iterator.hasNext()) {
            Column column = (Column)iterator.next();
            Object v = hashMap.get(column.getName());
            if (v == null) {
                return null;
            }
            arrayList.add(v);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"createPrimaryKeyValue");
        }
        return arrayList;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

