/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.wdo.mediator.rdb.graphbuilder.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.wdo.mediator.rdb.exception.InvalidMetadataException;
import com.ibm.websphere.wdo.mediator.rdb.graphbuilder.impl.GraphBuilderMetadata;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;

public class ResultSetRow {
    protected static final TraceComponent tc = Tr.register((Class)(class$com$ibm$websphere$wdo$mediator$rdb$graphbuilder$impl$ResultSetRow == null ? (class$com$ibm$websphere$wdo$mediator$rdb$graphbuilder$impl$ResultSetRow = ResultSetRow.class$("com.ibm.websphere.wdo.mediator.rdb.graphbuilder.impl.ResultSetRow")) : class$com$ibm$websphere$wdo$mediator$rdb$graphbuilder$impl$ResultSetRow), (String)"JDBCMediator", (String)"jdbcmediator.properties");
    private HashMap tableMap = new HashMap();
    private final GraphBuilderMetadata metadata;
    static /* synthetic */ Class class$com$ibm$websphere$wdo$mediator$rdb$graphbuilder$impl$ResultSetRow;

    public ResultSetRow(ResultSet resultSet, GraphBuilderMetadata graphBuilderMetadata) throws SQLException, InvalidMetadataException {
        this.metadata = graphBuilderMetadata;
        this.processRow(resultSet);
    }

    private void processRow(ResultSet resultSet) throws SQLException, InvalidMetadataException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"processRow");
        }
        for (int i = this.metadata.getStartIndex(); i <= this.metadata.getEndIndex(); ++i) {
            Object object = this.getObject(resultSet, i);
            HashMap hashMap = this.getRawData(this.metadata.getTableName(i));
            hashMap.put(this.metadata.getColumnName(i), object);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"processRow");
        }
    }

    private Object getObject(ResultSet resultSet, int n) throws SQLException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getObject");
        }
        Object object = null;
        switch (this.metadata.getType(n)) {
            case 0: {
                object = new Integer(resultSet.getInt(n));
                break;
            }
            case 9: {
                object = resultSet.getBigDecimal(n);
                break;
            }
            case 13: {
                Blob blob = resultSet.getBlob(n);
                if (blob == null) break;
                object = blob.getBytes(1L, (int)blob.length());
                break;
            }
            case 1: {
                object = new Boolean(resultSet.getBoolean(n));
                break;
            }
            case 2: {
                object = new Byte(resultSet.getByte(n));
                break;
            }
            case 15: {
                object = resultSet.getBytes(n);
                break;
            }
            case 14: {
                Clob clob = resultSet.getClob(n);
                if (clob == null) break;
                object = clob.getSubString(1L, (int)clob.length());
                break;
            }
            case 10: {
                object = resultSet.getDate(n);
                break;
            }
            case 5: {
                object = new Double(resultSet.getDouble(n));
                break;
            }
            case 7: {
                object = new Float(resultSet.getFloat(n));
                break;
            }
            case 6: {
                object = new Long(resultSet.getLong(n));
                break;
            }
            case 3: {
                object = new Short(resultSet.getShort(n));
                break;
            }
            case 4: {
                object = resultSet.getString(n);
                break;
            }
            case 11: {
                object = resultSet.getTime(n);
                break;
            }
            case 12: {
                object = resultSet.getTimestamp(n);
                break;
            }
            default: {
                object = resultSet.getObject(n);
            }
        }
        if (resultSet.wasNull()) {
            object = null;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getObject", (Object)new Object[]{object});
        }
        return object;
    }

    public HashMap getTable(String string) {
        return (HashMap)this.tableMap.get(string);
    }

    private HashMap getRawData(String string) throws InvalidMetadataException {
        HashMap hashMap;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getRawData");
        }
        if ((hashMap = (HashMap)this.tableMap.get(string)) == null) {
            hashMap = new HashMap();
            this.tableMap.put(string, hashMap);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getRawData");
        }
        return hashMap;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

