/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.wdo.mediator.rdb.graphbuilder.schema;

import com.ibm.etools.wdo.datagraph.impl.WdoConfig;
import com.ibm.websphere.wdo.mediator.rdb.exception.InvalidMetadataException;
import com.ibm.websphere.wdo.mediator.rdb.graphbuilder.MetadataValidator;
import com.ibm.websphere.wdo.mediator.rdb.graphbuilder.RelationalGraphBuilderFactory;
import com.ibm.websphere.wdo.mediator.rdb.graphbuilder.schema.EReferenceMaker;
import com.ibm.websphere.wdo.mediator.rdb.graphbuilder.schema.RelationshipMaker;
import com.ibm.websphere.wdo.mediator.rdb.graphbuilder.schema.TableMaker;
import com.ibm.websphere.wdo.mediator.rdb.metadata.Metadata;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EcoreFactory;

public class ESchemaMaker {
    private final Metadata metadata;
    private EClass eSchema;
    private EPackage dataGraphPackage;

    public ESchemaMaker(Metadata metadata) throws InvalidMetadataException {
        this.metadata = metadata;
        MetadataValidator metadataValidator = RelationalGraphBuilderFactory.getMetadataValidator(metadata);
        metadataValidator.validate();
        this.createESchema();
    }

    public EClass getESchema() {
        return this.eSchema;
    }

    private void createESchema() {
        TableMaker tableMaker = new TableMaker(this.getEPackage());
        tableMaker.createSchemaForTables((List)this.metadata.getTables());
        RelationshipMaker relationshipMaker = new RelationshipMaker(this.getEPackage());
        relationshipMaker.createSchemaForRelationships((List)this.metadata.getRelationships());
        EReferenceMaker eReferenceMaker = new EReferenceMaker();
        EClass eClass = this.getEcoreFactory().createEClass();
        eClass.setName("DataGraphSchema");
        EClass eClass2 = this.getEcoreFactory().createEClass();
        eClass2.setName("RootDataObject");
        EReference eReference = eReferenceMaker.createEReference("root", eClass2, 0, 1, true);
        eClass.getEReferences().add((Object)eReference);
        Iterator iterator = tableMaker.getTableNames().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            EClass eClass3 = (EClass)this.getEPackage().getEClassifier(string);
            EReference eReference2 = eReferenceMaker.createOneToManyReference(string, eClass3, true);
            eClass2.getEReferences().add((Object)eReference2);
        }
        this.eSchema = eClass;
        this.getEPackage().getEClassifiers().add(0, (Object)this.eSchema);
        this.getEPackage().getEClassifiers().add((Object)eClass2);
        WdoConfig.initPackage((EPackage)this.getEPackage());
    }

    protected EcoreFactory getEcoreFactory() {
        return EcoreFactory.eINSTANCE;
    }

    public EPackage getEPackage() {
        if (this.dataGraphPackage == null) {
            this.dataGraphPackage = this.createEPackage();
        }
        return this.dataGraphPackage;
    }

    protected EPackage createEPackage() {
        EPackage ePackage = EcoreFactory.eINSTANCE.createEPackage();
        ePackage.setName("DataGraph");
        ePackage.setNsPrefix("datagraph");
        ePackage.setNsURI("datagraph.ecore");
        return ePackage;
    }
}

