/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wdo.mediator.rdb;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.wdo.mediator.rdb.ConnectionWrapper;
import com.ibm.websphere.wdo.mediator.rdb.exception.DBException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.wdo.mediator.rdb.JDBCAdapter;
import com.ibm.ws.wdo.mediator.rdb.queryengine.QueryPredicates;
import com.ibm.ws.wdo.mediator.rdb.queryengine.SelectPredicates;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;

public class ConnectionWrapperImpl
implements ConnectionWrapper {
    protected static final TraceComponent tc = Tr.register((Class)(class$com$ibm$ws$wdo$mediator$rdb$ConnectionWrapperImpl == null ? (class$com$ibm$ws$wdo$mediator$rdb$ConnectionWrapperImpl = ConnectionWrapperImpl.class$("com.ibm.ws.wdo.mediator.rdb.ConnectionWrapperImpl")) : class$com$ibm$ws$wdo$mediator$rdb$ConnectionWrapperImpl), (String)"JDBCMediator", (String)"jdbcmediator.properties");
    private static Map dbTypes;
    private String dbType;
    private Connection connection;
    private boolean managesTx;
    private JDBCAdapter adapter;
    static /* synthetic */ Class class$com$ibm$ws$wdo$mediator$rdb$ConnectionWrapperImpl;

    private static Map getDbTypes() {
        if (dbTypes == null) {
            ConnectionWrapperImpl.initializeDBTypes();
        }
        return dbTypes;
    }

    private static void initializeDBTypes() {
        dbTypes = new HashMap();
        dbTypes.put("DB2", "DB2UDBNT_V8");
        dbTypes.put("DBMS:db2j", "CLOUDSCAPE_V50");
        dbTypes.put("Microsoft SQL Server", "MSSQLSERVER_2000");
        dbTypes.put("Oracle", "ORACLE_V9");
        dbTypes.put("Informix Dynamic Server", "INFORMIX_V93");
        dbTypes.put("DSN", "DB2UDBOS390_V7");
        dbTypes.put("DSN07010", "DB2UDBOS390_V7");
        dbTypes.put("default", "DB2UDBNT_V8");
    }

    public ConnectionWrapperImpl(Connection connection) {
        this.connection = connection;
        this.managesTx = true;
        this.adapter = new JDBCAdapter(this);
    }

    public boolean managesTx() {
        return this.managesTx;
    }

    public void manageTx() {
        this.managesTx = true;
    }

    public Connection getConnection() {
        return this.connection;
    }

    public void tearDown() {
        this.connection = null;
    }

    public void commit() throws DBException {
        if (this.managesTx) {
            try {
                this.connection.commit();
            }
            catch (SQLException sQLException) {
                FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.wdo.mediator.rdb.ConnectionWrapperImpl.start()", (String)"1", (Object)this);
                throw new DBException("Exception when commiting" + sQLException, sQLException);
            }
        }
    }

    public void rollback() throws DBException {
        if (this.managesTx) {
            try {
                this.connection.rollback();
            }
            catch (SQLException sQLException) {
                FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.wdo.mediator.rdb.ConnectionWrapperImpl.rollback()", (String)"2", (Object)this);
                throw new DBException("Exception when rolling back" + sQLException, sQLException);
            }
        }
    }

    public void start() throws DBException {
        if (this.managesTx) {
            try {
                boolean bl = this.connection.getAutoCommit();
                if (bl) {
                    throw new DBException("AutoCommit is true but Mediator requires it to be false");
                }
            }
            catch (SQLException sQLException) {
                FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.wdo.mediator.rdb.ConnectionWrapperImpl.start()", (String)"3", (Object)this);
                throw new DBException("Could not getAutoCommit()" + sQLException, sQLException);
            }
        }
    }

    public boolean isNullWrapper() {
        return false;
    }

    public void dontManageTransaction() {
        this.managesTx = false;
    }

    public void discardResultSet(ResultSet resultSet) throws SQLException {
        this.adapter.discardResultSet(resultSet);
    }

    public int executeUpdate(String string, QueryPredicates queryPredicates) throws SQLException {
        return this.adapter.executeUpdate(string, queryPredicates);
    }

    public ResultSet executeSelect(String string, SelectPredicates selectPredicates) throws SQLException {
        return this.adapter.executeSelect(string, selectPredicates);
    }

    public ResultSet executeSelect(String string) throws SQLException {
        return this.adapter.executeSelect(string);
    }

    public ResultSet executeDirectQuery(String string) throws SQLException {
        return this.adapter.executeDirectQuery(string);
    }

    public int executeDirectUpdate(String string) throws SQLException {
        return this.adapter.executeDirectUpdate(string);
    }

    public String getDBType() {
        if (this.dbType == null) {
            this.initializeDbType();
        }
        return this.dbType;
    }

    private String getDefaultDBType() {
        return (String)ConnectionWrapperImpl.getDbTypes().get("default");
    }

    private void initializeDbType() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"initializeDbType");
        }
        String string = null;
        String string2 = null;
        String string3 = null;
        try {
            DatabaseMetaData databaseMetaData = this.connection.getMetaData();
            string2 = databaseMetaData.getDatabaseProductName();
            string3 = databaseMetaData.getDatabaseProductVersion();
            string = string2.startsWith("DB2") ? "DB2" : (string2.startsWith("DSN") ? "DSN" : string2);
        }
        catch (SQLException sQLException) {
            this.ffdcFilter(sQLException, "getDBType", "1");
            throw new Error("Unable to retrieve Product or version name");
        }
        if (ConnectionWrapperImpl.getDbTypes().containsKey(string)) {
            this.dbType = (String)ConnectionWrapperImpl.getDbTypes().get(string);
        } else {
            Tr.warning((TraceComponent)tc, (String)"initializeDbType", (Object)("Not a recognized database type => " + string2));
            this.dbType = this.getDefaultDBType();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"initializeDbType", (Object)new Object[]{string2, string3, this.dbType});
        }
    }

    private void ffdcFilter(Exception exception, String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getClass().getName()).append(".").append(string);
        FFDCFilter.processException((Throwable)exception, (String)stringBuffer.toString(), (String)string2, (Object)this);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

