/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wdo.mediator.rdb;

import com.ibm.etools.wdo.DataObject;
import com.ibm.websphere.wdo.mediator.CountingPager;
import com.ibm.websphere.wdo.mediator.Mediator;
import com.ibm.websphere.wdo.mediator.exception.MediatorException;
import com.ibm.websphere.wdo.mediator.rdb.exception.DBException;
import com.ibm.websphere.wdo.mediator.rdb.exception.RelationalMediatorException;
import com.ibm.ws.wdo.mediator.rdb.MediatorImpl;
import java.util.Map;

public class GenericPagerImpl
implements CountingPager {
    private int pageSize;
    private int pageNumber;
    private Map arguments;
    private int totalPages;

    public GenericPagerImpl(int n, Map map) {
        this.pageSize = n;
        this.arguments = map;
        this.totalPages = -1;
    }

    public GenericPagerImpl(int n) {
        this(n, null);
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public DataObject next(Mediator mediator) throws RelationalMediatorException {
        if (this.isLastPage(mediator)) {
            throw new RelationalMediatorException("Cannot move past the last page");
        }
        MediatorImpl mediatorImpl = (MediatorImpl)mediator;
        mediatorImpl.setPageSize(this.pageSize);
        int n = this.pageNumber * this.pageSize;
        DataObject dataObject = mediatorImpl.nextGenericPage(n, this.arguments);
        ++this.pageNumber;
        return dataObject;
    }

    public DataObject previous(Mediator mediator) throws RelationalMediatorException {
        if (this.pageNumber <= 1) {
            throw new RelationalMediatorException("Cannot move prior to the first page");
        }
        MediatorImpl mediatorImpl = (MediatorImpl)mediator;
        mediatorImpl.setPageSize(this.pageSize);
        int n = (this.pageNumber - 1) * this.pageSize + 1;
        DataObject dataObject = mediatorImpl.previousGenericPage(this.pageNumber - 1, this.arguments);
        --this.pageNumber;
        return dataObject;
    }

    public DataObject page(int n, Mediator mediator) throws MediatorException {
        if (n < 1) {
            throw new RelationalMediatorException("Cannot move prior to the first page");
        }
        if (n > this.lastPageNumber(mediator)) {
            throw new RelationalMediatorException("Cannot move past the last page");
        }
        MediatorImpl mediatorImpl = (MediatorImpl)mediator;
        mediatorImpl.setPageSize(this.pageSize);
        DataObject dataObject = mediatorImpl.genericPage(n, this.arguments);
        this.pageNumber = n;
        return dataObject;
    }

    public int pageCount(Mediator mediator) throws MediatorException {
        return this.totalPages(mediator);
    }

    public boolean isFirstPage(Mediator mediator) throws MediatorException {
        return this.pageNumber == 1;
    }

    public boolean isLastPage(Mediator mediator) throws RelationalMediatorException {
        return this.pageNumber == this.lastPageNumber(mediator);
    }

    private int lastPageNumber(Mediator mediator) throws DBException {
        return this.totalPages(mediator);
    }

    private int totalPages(Mediator mediator) throws DBException {
        if (this.totalPages == -1) {
            float f = ((MediatorImpl)mediator).rowCount(this.arguments);
            this.totalPages = (int)Math.ceil(f / (float)this.pageSize);
        }
        return this.totalPages;
    }
}

