/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wdo.mediator.rdb;

import com.ibm.etools.emf.event.Change;
import com.ibm.etools.wdo.DataObject;
import com.ibm.etools.wdo.datagraph.EventLog;
import com.ibm.etools.wdo.datagraph.impl.EDataObjectImpl;
import com.ibm.websphere.wdo.mediator.rdb.exception.DBException;
import com.ibm.websphere.wdo.mediator.rdb.metadata.Column;
import com.ibm.websphere.wdo.mediator.rdb.metadata.Metadata;
import com.ibm.websphere.wdo.mediator.rdb.metadata.Relationship;
import com.ibm.websphere.wdo.mediator.rdb.metadata.Table;
import com.ibm.ws.wdo.mediator.rdb.FieldSet;
import com.ibm.ws.wdo.mediator.rdb.GraphChange;
import com.ibm.ws.wdo.mediator.rdb.NewNode;
import com.ibm.ws.wdo.mediator.rdb.NodeDeleted;
import com.ibm.ws.wdo.mediator.rdb.queryengine.QueryEngine;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;

public class GraphChanges {
    private List changes;
    private QueryEngine queryEngine;
    private Metadata metadata;
    private EventLog eventLog;

    public GraphChanges(Metadata metadata, QueryEngine queryEngine, EventLog eventLog) {
        this.metadata = metadata;
        this.queryEngine = queryEngine;
        this.eventLog = eventLog;
        this.changes = new ArrayList();
        this.initialize();
    }

    private void initialize() {
        Iterator iterator = this.eventLog.getChangedDataObjects().iterator();
        while (iterator.hasNext()) {
            DataObject dataObject = (DataObject)iterator.next();
            if (((EObject)dataObject).eClass().getName().equals("RootDataObject")) continue;
            this.createChange(dataObject);
        }
    }

    public void createChange(DataObject dataObject) {
        if (this.eventLog.isCreated(dataObject)) {
            this.add(new NewNode(this.metadata, this.queryEngine, dataObject));
        } else if (this.eventLog.isDeleted(dataObject)) {
            this.add(new NodeDeleted(this.metadata, this.queryEngine, dataObject));
        } else if (this.isPersistenceChange(dataObject)) {
            this.bumpCollisionField(dataObject);
            this.add(new FieldSet(this.metadata, this.queryEngine, dataObject));
        }
    }

    private void add(GraphChange graphChange) {
        this.changes.add(graphChange);
    }

    private void doInserts() throws DBException {
        Iterator iterator = this.changes.iterator();
        while (iterator.hasNext()) {
            GraphChange graphChange = (GraphChange)iterator.next();
            if (!graphChange.isInsert()) continue;
            graphChange.applyChange();
        }
    }

    private void doUpdates() throws DBException {
        Iterator iterator = this.changes.iterator();
        while (iterator.hasNext()) {
            GraphChange graphChange = (GraphChange)iterator.next();
            if (!graphChange.isUpdate()) continue;
            graphChange.applyChange();
        }
    }

    private void doDeletes() throws DBException {
        Iterator iterator = this.changes.iterator();
        while (iterator.hasNext()) {
            GraphChange graphChange = (GraphChange)iterator.next();
            if (!graphChange.isDelete()) continue;
            graphChange.applyChange();
        }
    }

    public void applyChanges() throws DBException {
        this.doInserts();
        this.doUpdates();
        this.doDeletes();
    }

    private boolean isPersistenceChange(DataObject dataObject) {
        return !this.isAllParentRefChanges(dataObject);
    }

    private boolean isAllParentRefChanges(DataObject dataObject) {
        List list = this.eventLog.getOldValues(dataObject);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            EventLog.Setting setting = (EventLog.Setting)iterator.next();
            EStructuralFeature eStructuralFeature = (EStructuralFeature)((EObject)dataObject).eClass().getEAllStructuralFeatures().get(setting.getFeatureIndex());
            if (!(eStructuralFeature instanceof EReference)) {
                return false;
            }
            String string = setting.getFeatureName();
            Relationship relationship = this.relationshipFor(string);
            if (!this.isChild(relationship, string)) continue;
            if (relationship.isToMany()) {
                return false;
            }
            throw new Error("Cannot modify the PK");
        }
        return true;
    }

    private Relationship relationshipFor(String string) {
        Iterator iterator = this.metadata.getRelationships().iterator();
        while (iterator.hasNext()) {
            Relationship relationship = (Relationship)iterator.next();
            if (!relationship.getName().equals(string) && !relationship.getOppositeName().equals(string)) continue;
            return relationship;
        }
        throw new Error("No match on relationship name => " + string);
    }

    private boolean isParent(Relationship relationship, String string) {
        if (relationship.getName().equals(string)) {
            return true;
        }
        if (relationship.getOppositeName().equals(string)) {
            return false;
        }
        throw new Error("No match on relationship name" + string);
    }

    private boolean isChild(Relationship relationship, String string) {
        return !this.isParent(relationship, string);
    }

    private void bumpCollisionField(DataObject dataObject) {
        String string = this.classNameOf(dataObject);
        Table table = this.metadata.getTable(string);
        Column column = table.getCollisionColumn();
        if (column != null) {
            int n = dataObject.getInt(column.getName()) + 1;
            dataObject.setInt(column.getName(), n);
        }
    }

    private String classNameOf(DataObject dataObject) {
        EDataObjectImpl eDataObjectImpl = (EDataObjectImpl)dataObject;
        EClass eClass = eDataObjectImpl.eClass();
        return eClass.getName();
    }

    private boolean isSet(Change change) {
        return change.getNewEObject() != null && change.getOldEObject() != null;
    }

    private boolean isGraphAdd(Change change) {
        return change.getNewEObject() != null && change.getOldEObject() == null;
    }

    private boolean isGraphDelete(Change change) {
        return change.getNewEObject() == null && change.getOldEObject() != null;
    }
}

