/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wdo.mediator.rdb;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.etools.wdo.DataObject;
import com.ibm.etools.wdo.datagraph.EDataGraph;
import com.ibm.etools.wdo.datagraph.EventLog;
import com.ibm.websphere.wdo.mediator.exception.MediatorException;
import com.ibm.websphere.wdo.mediator.rdb.ConnectionWrapper;
import com.ibm.websphere.wdo.mediator.rdb.JDBCMediator;
import com.ibm.websphere.wdo.mediator.rdb.exception.DBException;
import com.ibm.websphere.wdo.mediator.rdb.exception.InvalidMetadataException;
import com.ibm.websphere.wdo.mediator.rdb.exception.RelationalMediatorException;
import com.ibm.websphere.wdo.mediator.rdb.graphbuilder.PagedGraphInfo;
import com.ibm.websphere.wdo.mediator.rdb.graphbuilder.RelationalGraphBuilder;
import com.ibm.websphere.wdo.mediator.rdb.graphbuilder.RelationalGraphBuilderFactory;
import com.ibm.websphere.wdo.mediator.rdb.metadata.Metadata;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.wdo.mediator.rdb.ConnectionWrapperImpl;
import com.ibm.ws.wdo.mediator.rdb.GraphChanges;
import com.ibm.ws.wdo.mediator.rdb.UniqueKeys;
import com.ibm.ws.wdo.mediator.rdb.queryengine.QueryEngine;
import com.ibm.ws.wdo.mediator.rdb.queryengine.QueryEngineException;
import com.ibm.ws.wdo.mediator.rdb.queryengine.QueryEngineFactoryImpl;
import com.ibm.ws.wdo.mediator.rdb.queryengine.QueryResult;
import java.util.Map;
import org.eclipse.emf.ecore.EClass;

public class MediatorImpl
implements JDBCMediator {
    protected static final TraceComponent tc = Tr.register((Class)(class$com$ibm$ws$wdo$mediator$rdb$MediatorImpl == null ? (class$com$ibm$ws$wdo$mediator$rdb$MediatorImpl = MediatorImpl.class$("com.ibm.ws.wdo.mediator.rdb.MediatorImpl")) : class$com$ibm$ws$wdo$mediator$rdb$MediatorImpl), (String)"JDBCMediator", (String)"jdbcmediator.properties");
    private QueryEngine queryEngine;
    private Metadata metadata;
    private RelationalGraphBuilder graphBuilder;
    private ConnectionWrapperImpl connectionWrapper;
    private int pageSize;
    private UniqueKeys uniqueKeys;
    static /* synthetic */ Class class$com$ibm$ws$wdo$mediator$rdb$MediatorImpl;

    public MediatorImpl(Metadata metadata, ConnectionWrapper connectionWrapper) throws InvalidMetadataException {
        this.metadata = metadata;
        this.connectionWrapper = (ConnectionWrapperImpl)connectionWrapper;
        this.initialize();
    }

    private void initialize() throws InvalidMetadataException {
        QueryEngineFactoryImpl queryEngineFactoryImpl = QueryEngineFactoryImpl.soleInstance();
        if (!this.connectionWrapper.isNullWrapper()) {
            String string = this.connectionWrapper.getDBType();
            this.queryEngine = queryEngineFactoryImpl.createQueryEngine(this.metadata, this, string);
        }
        this.pageSize = 0;
    }

    public void applyChanges(DataObject dataObject) throws RelationalMediatorException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"applyChanges");
        }
        EventLog eventLog = dataObject.getDataGraph().getEventLog();
        GraphChanges graphChanges = new GraphChanges(this.metadata, this.queryEngine, eventLog);
        try {
            this.connectionWrapper.start();
            graphChanges.applyChanges();
            this.connectionWrapper.commit();
            this.clearEvents(dataObject);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"applyChanges");
            }
        }
        catch (DBException dBException) {
            this.ffdcFilter(dBException, "applyChanges", "1");
            this.connectionWrapper.rollback();
            throw dBException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataObject getGraph(Map map) throws RelationalMediatorException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getGraph", (Object)new Object[]{map});
        }
        Object var2_2 = null;
        QueryResult queryResult = null;
        try {
            queryResult = this.queryEngine.executeSelect(map);
            this.checkException(queryResult, "select");
            DataObject dataObject = this.graphBuilder().graph(queryResult.getResults(), queryResult.getResultDescriptors());
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"getGraph");
            }
            DataObject dataObject2 = dataObject;
            return dataObject2;
        }
        finally {
            this.cleanup(queryResult);
        }
    }

    public DataObject getGraph() throws RelationalMediatorException {
        return this.getGraph(null);
    }

    public DataObject getEmptyGraph() throws RelationalMediatorException {
        return this.graphBuilder().emptyGraph();
    }

    public EClass getSchema() throws RelationalMediatorException {
        return this.graphBuilder().schema();
    }

    public long getKey() throws MediatorException {
        return this.uniqueKeys().getKey();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected PagedGraphInfo nextPage(int n, Map map) throws RelationalMediatorException {
        PagedGraphInfo pagedGraphInfo;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"nextPage", (Object)new Object[]{new Integer(n), map});
        }
        Object var3_3 = null;
        QueryResult queryResult = null;
        try {
            queryResult = this.queryEngine.executeSelectNextPage(map, n);
            this.checkException(queryResult, "select");
            PagedGraphInfo pagedGraphInfo2 = this.graphBuilder().pagedGraph(queryResult.getResults(), queryResult.getResultDescriptors());
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"nextPage");
            }
            pagedGraphInfo = pagedGraphInfo2;
        }
        catch (Throwable throwable) {
            this.cleanup(queryResult);
            throw throwable;
        }
        this.cleanup(queryResult);
        return pagedGraphInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DataObject nextGenericPage(int n, Map map) throws RelationalMediatorException {
        DataObject dataObject;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"nextGenericPage", (Object)new Object[]{new Integer(n), map});
        }
        Object var3_3 = null;
        QueryResult queryResult = null;
        try {
            queryResult = this.queryEngine.executeSelectNextPage(map, n);
            this.checkException(queryResult, "nextGenericPage");
            DataObject dataObject2 = this.graphBuilder().pagedGraph(queryResult.getResults(), queryResult.getResultDescriptors(), this.pageSize);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"nextGenericPage");
            }
            dataObject = dataObject2;
        }
        catch (Throwable throwable) {
            this.cleanup(queryResult);
            throw throwable;
        }
        this.cleanup(queryResult);
        return dataObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DataObject genericPage(int n, Map map) throws RelationalMediatorException {
        DataObject dataObject;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"genericPage", (Object)new Object[]{new Integer(n), map});
        }
        Object var3_3 = null;
        QueryResult queryResult = null;
        try {
            queryResult = this.queryEngine.executeSelectNextPage(map, n);
            this.checkException(queryResult, "genericPage");
            DataObject dataObject2 = this.graphBuilder().pagedGraph(queryResult.getResults(), queryResult.getResultDescriptors(), this.pageSize);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"genericPage");
            }
            dataObject = dataObject2;
        }
        catch (Throwable throwable) {
            this.cleanup(queryResult);
            throw throwable;
        }
        this.cleanup(queryResult);
        return dataObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DataObject previousGenericPage(int n, Map map) throws RelationalMediatorException {
        DataObject dataObject;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"previousGenericPage", (Object)new Object[]{new Integer(n), map});
        }
        Object var3_3 = null;
        QueryResult queryResult = null;
        try {
            queryResult = this.queryEngine.executeSelectPreviousPage(map, n);
            this.checkException(queryResult, "previousGenericPage");
            DataObject dataObject2 = this.graphBuilder().pagedGraph(queryResult.getResults(), queryResult.getResultDescriptors(), this.pageSize);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"previousGenericPage");
            }
            dataObject = dataObject2;
        }
        catch (Throwable throwable) {
            this.cleanup(queryResult);
            throw throwable;
        }
        this.cleanup(queryResult);
        return dataObject;
    }

    private UniqueKeys uniqueKeys() throws DBException {
        if (this.uniqueKeys == null) {
            this.uniqueKeys = new UniqueKeys(this, this.metadata);
        }
        return this.uniqueKeys;
    }

    protected void setPageSize(int n) {
        this.pageSize = n;
        this.queryEngine.setPageSize(n);
    }

    protected int getPageSize() {
        return this.pageSize;
    }

    private void clearEvents(DataObject dataObject) {
        EDataGraph eDataGraph = (EDataGraph)dataObject.getDataGraph();
        eDataGraph.getEventLog().clearLog();
    }

    private RelationalGraphBuilder graphBuilder() throws InvalidMetadataException {
        if (this.graphBuilder == null) {
            this.graphBuilder = RelationalGraphBuilderFactory.getRelationalGraphBuilder(this.metadata);
        }
        return this.graphBuilder;
    }

    private void cleanup(QueryResult queryResult) throws DBException {
        try {
            this.connectionWrapper.commit();
            if (queryResult != null) {
                queryResult.discard();
            }
        }
        catch (QueryEngineException queryEngineException) {
            this.ffdcFilter(queryEngineException, "cleanup", "2");
            throw new DBException("Error in finally:QE: " + queryEngineException, queryEngineException);
        }
    }

    private void checkException(QueryResult queryResult, String string) throws DBException {
        if (queryResult.hasException()) {
            QueryEngineException queryEngineException = queryResult.getException();
            throw new DBException("QE " + string + ":" + queryEngineException, queryEngineException);
        }
    }

    public void setConnectionWrapper(ConnectionWrapper connectionWrapper) {
        this.connectionWrapper = (ConnectionWrapperImpl)connectionWrapper;
    }

    public ConnectionWrapper getConnectionWrapper() {
        return this.connectionWrapper;
    }

    protected QueryEngine getQueryEngine() {
        return this.queryEngine;
    }

    private void ffdcFilter(Exception exception, String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getClass().getName()).append(".").append(string);
        FFDCFilter.processException((Throwable)exception, (String)stringBuffer.toString(), (String)string2, (Object)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long rowCount(Map map) throws DBException {
        try {
            long l = this.queryEngine.executeCount(map);
            return l;
        }
        finally {
            this.connectionWrapper.commit();
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

