/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wdo.mediator.rdb;

import com.ibm.etools.wdo.DataObject;
import com.ibm.websphere.wdo.mediator.Mediator;
import com.ibm.websphere.wdo.mediator.Pager;
import com.ibm.websphere.wdo.mediator.rdb.exception.RelationalMediatorException;
import com.ibm.websphere.wdo.mediator.rdb.graphbuilder.PagedGraphInfo;
import com.ibm.ws.wdo.mediator.rdb.MediatorImpl;
import java.util.Map;

public class PagerImpl
implements Pager {
    private int pageSize;
    private int lastIndex;
    private int firstIndex;
    private Map arguments;

    public PagerImpl(int n) {
        this.pageSize = n;
        this.arguments = null;
    }

    public PagerImpl(int n, Map map) {
        this.pageSize = n;
        this.arguments = map;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public DataObject next(Mediator mediator) throws RelationalMediatorException {
        MediatorImpl mediatorImpl = (MediatorImpl)mediator;
        mediatorImpl.setPageSize(this.pageSize);
        PagedGraphInfo pagedGraphInfo = mediatorImpl.nextPage(this.lastIndex, this.arguments);
        this.updateIndexes(pagedGraphInfo);
        return pagedGraphInfo.getGraph();
    }

    public DataObject previous(Mediator mediator) throws RelationalMediatorException {
        return null;
    }

    private void updateIndexes(PagedGraphInfo pagedGraphInfo) {
        int n = pagedGraphInfo.getFirstIndex();
        int n2 = pagedGraphInfo.getLastIndex();
        if (n != 0 || n2 != 0) {
            this.firstIndex = pagedGraphInfo.getFirstIndex();
            this.lastIndex = pagedGraphInfo.getLastIndex();
        }
    }
}

