/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wdo.mediator.rdb;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.wdo.mediator.rdb.JDBCMediator;
import com.ibm.websphere.wdo.mediator.rdb.exception.DBException;
import com.ibm.websphere.wdo.mediator.rdb.metadata.Column;
import com.ibm.websphere.wdo.mediator.rdb.metadata.Metadata;
import com.ibm.websphere.wdo.mediator.rdb.metadata.Table;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.wdo.mediator.rdb.ConnectionWrapperImpl;
import com.ibm.ws.wdo.mediator.rdb.MediatorImpl;
import com.ibm.ws.wdo.mediator.rdb.queryengine.QueryEngine;
import java.sql.ResultSet;
import java.sql.SQLException;

public class UniqueKeys {
    protected static final TraceComponent tc = Tr.register((Class)(class$com$ibm$ws$wdo$mediator$rdb$UniqueKeys == null ? (class$com$ibm$ws$wdo$mediator$rdb$UniqueKeys = UniqueKeys.class$("com.ibm.ws.wdo.mediator.rdb.UniqueKeys")) : class$com$ibm$ws$wdo$mediator$rdb$UniqueKeys), (String)"JDBCMediator", (String)"jdbcmediator.properties");
    private long currentKey;
    private long lastKeyInRange;
    private int keyBufferSize;
    private boolean initialized;
    private JDBCMediator mediator;
    private Metadata metadata;
    private String tableName;
    private String idColumnName;
    private String nextColumnName;
    static /* synthetic */ Class class$com$ibm$ws$wdo$mediator$rdb$UniqueKeys;

    public UniqueKeys(JDBCMediator jDBCMediator, Metadata metadata) throws DBException {
        this.mediator = jDBCMediator;
        this.metadata = metadata;
        this.keyBufferSize = metadata.getUniqueKeyBufferSize();
        if (this.keyBufferSize == 0) {
            throw new Error("Key buffer size cannot be zero");
        }
        this.initialized = false;
    }

    private void initialize() throws DBException {
        Table table = this.metadata.getUniqueKeyTable();
        this.tableName = table.qualifiedName();
        Column column = (Column)table.getColumns().get(0);
        this.idColumnName = column.getName();
        Column column2 = (Column)table.getColumns().get(1);
        this.nextColumnName = column2.getName();
        this.moreKeys();
        this.initialized = true;
    }

    public long getKey() throws DBException {
        if (!this.initialized) {
            this.initialize();
        }
        if (this.currentKey <= this.lastKeyInRange) {
            long l = this.currentKey++;
            return l;
        }
        this.moreKeys();
        return this.getKey();
    }

    private void moreKeys() throws DBException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"moreKeys");
        }
        String string = this.getQueryEngine().getUniqueKeySelectString();
        try {
            this.getConnectionWrapper().start();
            long l = 0L;
            ResultSet resultSet = this.getConnectionWrapper().executeDirectQuery(string);
            if (resultSet.next()) {
                l = resultSet.getLong(this.nextColumnName);
            } else {
                this.insertInitialRow();
                this.moreKeys();
            }
            this.getConnectionWrapper().discardResultSet(resultSet);
            this.currentKey = l;
            this.lastKeyInRange = l + (long)this.keyBufferSize - 1L;
            long l2 = l + (long)this.keyBufferSize;
            String string2 = this.getQueryEngine().getUniqueKeyUpdateString(l2);
            this.getConnectionWrapper().executeDirectUpdate(string2);
            this.getConnectionWrapper().commit();
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"moreKeys", (Object)new Object[]{new Integer(this.keyBufferSize), string2});
            }
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.wdo.mediator.rdb.UniqueKeys.moreKeys", (String)"1", (Object)this);
            this.getConnectionWrapper().rollback();
            throw new DBException("Unable to read the Key Table: " + sQLException, sQLException);
        }
    }

    private QueryEngine getQueryEngine() {
        return ((MediatorImpl)this.mediator).getQueryEngine();
    }

    private ConnectionWrapperImpl getConnectionWrapper() {
        return (ConnectionWrapperImpl)this.mediator.getConnectionWrapper();
    }

    private void insertInitialRow() throws SQLException {
        String string = this.getQueryEngine().getUniqueKeyInsertString();
        this.getConnectionWrapper().executeDirectUpdate(string);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

