/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wdo.mediator.rdb.queryengine;

import com.ibm.websphere.wdo.mediator.rdb.metadata.Filter;
import com.ibm.ws.wdo.mediator.rdb.queryengine.AbstractPagingSelectStatementCreator;
import com.ibm.ws.wdo.mediator.rdb.queryengine.SubSelectCreator;
import com.ibm.ws.wdo.mediator.rdb.queryengine.schema.RDBTable;
import com.ibm.ws.wdo.mediator.rdb.queryengine.sqlquerytree.ColumnName;
import com.ibm.ws.wdo.mediator.rdb.queryengine.sqlquerytree.FullOrSubSelect;
import com.ibm.ws.wdo.mediator.rdb.queryengine.sqlquerytree.SelectStatement;
import com.ibm.ws.wdo.mediator.rdb.queryengine.sqlquerytree.SqlIdentifier;
import com.ibm.ws.wdo.mediator.rdb.queryengine.sqlquerytree.SubSelect;
import com.ibm.ws.wdo.mediator.rdb.queryengine.sqlquerytree.TableReference;
import java.util.List;

public class CloudscapePagingSelectStatementCreator
extends AbstractPagingSelectStatementCreator {
    public static final String RANK_TABLE = "RANK_TBL";
    private SubSelect fRootSubSelect;
    private FullOrSubSelect fJoinedSelect;

    public CloudscapePagingSelectStatementCreator(SubSelect subSelect) {
        this.rootSubSelect(subSelect);
    }

    public CloudscapePagingSelectStatementCreator(SubSelect subSelect, FullOrSubSelect fullOrSubSelect) {
        this.rootSubSelect(subSelect);
        this.joinedSelect(fullOrSubSelect);
    }

    public SelectStatement build() {
        Object object;
        SelectStatement selectStatement = new SelectStatement();
        SubSelect subSelect = this.buildSingleSelectOnTableExpression();
        if (this.joinedSelect() != null) {
            object = this.joinedSelect().branches().iterator();
            while (object.hasNext()) {
                SubSelect subSelect2 = (SubSelect)object.next();
                ColumnName columnName = new ColumnName(new SqlIdentifier("R"));
                columnName.invariantTableAlias(this.getRootTable().getName());
                subSelect2.addColumnFirst(columnName);
                subSelect2.replaceTablesWith(this.getRootTable(), subSelect, this.getRootTable().getName());
            }
        }
        object = this.orderBys();
        if (this.joinedSelect() != null) {
            this.joinedSelect().createOrderByClause((List)object);
            selectStatement.select(this.joinedSelect());
        } else {
            subSelect.createOrderByClause((List)object);
            selectStatement.select(subSelect);
        }
        return selectStatement;
    }

    public SubSelect buildSingleSelectOnTableExpression() {
        RDBTable rDBTable = this.getRootTable();
        Filter filter = rDBTable.getWDOTable().getFilter();
        TableReference tableReference = new TableReference(this.rootSubSelect(), rDBTable.getName());
        SubSelectCreator subSelectCreator = new SubSelectCreator(tableReference);
        subSelectCreator.setSingle();
        subSelectCreator.buildSingleSelectFromInLineSelect();
        if (filter != null) {
            subSelectCreator.statement().addNativeFilter(filter.getPredicate());
        }
        return subSelectCreator.statement();
    }

    public void rootSubSelect(SubSelect subSelect) {
        this.fRootSubSelect = subSelect;
    }

    public SubSelect rootSubSelect() {
        return this.fRootSubSelect;
    }

    public FullOrSubSelect joinedSelect() {
        return this.fJoinedSelect;
    }

    public void joinedSelect(FullOrSubSelect fullOrSubSelect) {
        this.fJoinedSelect = fullOrSubSelect;
    }

    public RDBTable getRootTable() {
        return (RDBTable)this.rootSubSelect().tables().get(0);
    }
}

