/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wdo.mediator.rdb.queryengine;

import com.ibm.ObjectQuery.crud.util.ClassShortName;
import com.ibm.ws.wdo.mediator.rdb.queryengine.JoinMap;
import com.ibm.ws.wdo.mediator.rdb.queryengine.RootJoinMapNode;
import com.ibm.ws.wdo.mediator.rdb.queryengine.schema.Connection;
import com.ibm.ws.wdo.mediator.rdb.queryengine.schema.RDBTable;
import java.util.Iterator;
import java.util.List;

public class JoinMapNode
extends RootJoinMapNode {
    private static final String copyright = "(c) Copyright IBM Corporation 2001.";
    private static final String NORMAL = "normal";
    private static final String REVERSED = "reversed";
    private Connection fConnection;
    private String fDirection;
    private boolean fIncludeFlag = true;

    public JoinMapNode() {
    }

    public JoinMapNode(RDBTable rDBTable, Connection connection) {
        this.connection(connection);
        if (rDBTable.equals(connection.memberTable())) {
            this.reversed();
        } else {
            this.normal();
        }
    }

    public List childSideJoinColumns() {
        if (this.isNormal()) {
            return this.connection().memberKeyColumns();
        }
        return this.connection().parentKeyColumns();
    }

    public RDBTable childSideTable() {
        if (this.isNormal()) {
            return this.connection().memberTable();
        }
        return this.connection().parentTable();
    }

    public Connection connection() {
        return this.fConnection;
    }

    public void connection(Connection connection) {
        this.fConnection = connection;
    }

    public JoinMap copyEmpty() {
        return new JoinMapNode();
    }

    public String direction() {
        return this.fDirection;
    }

    public void direction(String string) {
        this.fDirection = string;
    }

    public JoinMap disconnectedCopy() {
        JoinMapNode joinMapNode = (JoinMapNode)super.disconnectedCopy();
        joinMapNode.connection(this.connection());
        joinMapNode.direction(this.direction());
        return joinMapNode;
    }

    public boolean includeFlag() {
        return this.fIncludeFlag;
    }

    public boolean isEquiJoin() {
        return this.connection().isExclusive();
    }

    public boolean isIncluded() {
        return this.includeFlag();
    }

    public boolean isNormal() {
        return this.direction().equals(NORMAL);
    }

    public boolean isOuterJoin() {
        return !this.isEquiJoin();
    }

    public boolean isRelationshipJoin() {
        return this.fConnection != null;
    }

    public boolean isReversed() {
        return this.direction().equals(REVERSED);
    }

    public boolean isRoot() {
        return false;
    }

    public void normal() {
        this.fDirection = NORMAL;
    }

    public List parentSideJoinColumns() {
        if (this.isNormal()) {
            return this.connection().parentKeyColumns();
        }
        return this.connection().memberKeyColumns();
    }

    public RDBTable parentSideTable() {
        if (this.isNormal()) {
            return this.connection().parentTable();
        }
        return this.connection().memberTable();
    }

    public void printOn(StringBuffer stringBuffer) {
        stringBuffer.append(ClassShortName.name(this));
        stringBuffer.append("(");
        if (this.connection() == null) {
            stringBuffer.append("non relationship");
        } else {
            stringBuffer.append("relationship: ");
            stringBuffer.append(this.connection().name());
        }
        if (this.hasConnections()) {
            stringBuffer.append("\n");
            stringBuffer.append("connections: ");
            Iterator iterator = this.connections().iterator();
            while (iterator.hasNext()) {
                stringBuffer.append(((Connection)iterator.next()).name());
                if (!iterator.hasNext()) continue;
                stringBuffer.append(", ");
            }
        }
        stringBuffer.append(")");
    }

    public void reversed() {
        this.fDirection = REVERSED;
    }
}

