/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wdo.mediator.rdb.queryengine;

import com.ibm.websphere.wdo.mediator.rdb.metadata.Metadata;
import com.ibm.ws.wdo.mediator.rdb.queryengine.OraclePagingSelectStatementCreator;
import com.ibm.ws.wdo.mediator.rdb.queryengine.PagingSelectStatementCreator;
import com.ibm.ws.wdo.mediator.rdb.queryengine.QueryEngineException;
import com.ibm.ws.wdo.mediator.rdb.queryengine.QueryEngineInfo;
import com.ibm.ws.wdo.mediator.rdb.queryengine.QueryInputDescriptor;
import com.ibm.ws.wdo.mediator.rdb.queryengine.QueryResultDescriptor;
import com.ibm.ws.wdo.mediator.rdb.queryengine.SelectBuilder;
import com.ibm.ws.wdo.mediator.rdb.queryengine.schema.RDBSchema;
import com.ibm.ws.wdo.mediator.rdb.queryengine.sqlquerytree.SelectStatement;
import com.ibm.ws.wdo.mediator.rdb.queryengine.sqlquerytree.SqlStatement;
import java.util.List;

public class PagingSelectBuilder
extends SelectBuilder {
    public PagingSelectBuilder(Metadata metadata, RDBSchema rDBSchema) throws QueryEngineException {
        super(metadata, rDBSchema);
    }

    public SqlStatement defaultStatement() throws QueryEngineException {
        if (!(QueryEngineInfo.isDB2() && !QueryEngineInfo.isOS390() || QueryEngineInfo.isOracle())) {
            throw new QueryEngineException("paging only currently supported on DB2 (Workstation and iSeries only) and Oracle databases!");
        }
        SelectBuilder selectBuilder = new SelectBuilder();
        selectBuilder.setMetadata(this.getMetadata());
        selectBuilder.setSchema(this.getSchema());
        selectBuilder.setToIgnoreOrderBys();
        selectBuilder.initialize();
        this.filterArguments().addAll(selectBuilder.filterArguments());
        PagingSelectStatementCreator pagingSelectStatementCreator = QueryEngineInfo.isDB2() ? new PagingSelectStatementCreator((SelectStatement)selectBuilder.statement(), selectBuilder.resultDescriptor()) : new OraclePagingSelectStatementCreator((SelectStatement)selectBuilder.statement(), selectBuilder.resultDescriptor());
        pagingSelectStatementCreator.orderBys(this.orderByColumns());
        SelectStatement selectStatement = pagingSelectStatementCreator.build();
        this.resultDescriptor(this.createResultDescriptor(pagingSelectStatementCreator.extraResultSetElements()));
        return selectStatement;
    }

    public QueryResultDescriptor createResultDescriptor(List list) {
        return new QueryResultDescriptor(list, this.getSchema().getTables(), this.getSchema().root());
    }

    public void initialize() throws QueryEngineException {
        this.statement();
        this.createInputDescriptor();
    }

    public void createInputDescriptor() throws QueryEngineException {
        QueryInputDescriptor queryInputDescriptor = new QueryInputDescriptor();
        queryInputDescriptor.addFilterArguments(this.filterArguments());
        queryInputDescriptor.addArguments(this.statement());
        this.inputDescriptor(queryInputDescriptor);
    }
}

