/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wdo.mediator.rdb.queryengine;

import com.ibm.ObjectQuery.crud.util.Association;
import com.ibm.ObjectQuery.crud.util.ListWrapper;
import com.ibm.ws.wdo.mediator.rdb.queryengine.AbstractPagingSelectStatementCreator;
import com.ibm.ws.wdo.mediator.rdb.queryengine.QueryEngineInfo;
import com.ibm.ws.wdo.mediator.rdb.queryengine.QueryResultDescriptor;
import com.ibm.ws.wdo.mediator.rdb.queryengine.QueryResultFieldDescriptor;
import com.ibm.ws.wdo.mediator.rdb.queryengine.schema.RDBColumn;
import com.ibm.ws.wdo.mediator.rdb.queryengine.sqlquerytree.ColumnName;
import com.ibm.ws.wdo.mediator.rdb.queryengine.sqlquerytree.DenseRankFunction;
import com.ibm.ws.wdo.mediator.rdb.queryengine.sqlquerytree.FullOrSubSelect;
import com.ibm.ws.wdo.mediator.rdb.queryengine.sqlquerytree.ResultSetElement;
import com.ibm.ws.wdo.mediator.rdb.queryengine.sqlquerytree.ResultSetExpression;
import com.ibm.ws.wdo.mediator.rdb.queryengine.sqlquerytree.SelectStatement;
import com.ibm.ws.wdo.mediator.rdb.queryengine.sqlquerytree.SqlIdentifier;
import com.ibm.ws.wdo.mediator.rdb.queryengine.sqlquerytree.SubSelect;
import com.ibm.ws.wdo.mediator.rdb.queryengine.sqlquerytree.TableExpression;
import com.ibm.ws.wdo.mediator.rdb.queryengine.sqlquerytree.TableReference;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class PagingSelectStatementCreator
extends AbstractPagingSelectStatementCreator {
    public static final String COR_ALIAS = "Z";

    public PagingSelectStatementCreator() {
    }

    public PagingSelectStatementCreator(SelectStatement selectStatement, QueryResultDescriptor queryResultDescriptor) {
        this.selectStatement(selectStatement);
        this.resultDescriptor(queryResultDescriptor);
    }

    public SelectStatement build() {
        SelectStatement selectStatement = this.selectStatement();
        TableExpression tableExpression = this.createTableExpressionFor(this.selectStatement().select());
        selectStatement.addTableExpression(tableExpression);
        ArrayList<ResultSetExpression> arrayList = new ArrayList<ResultSetExpression>();
        List list = tableExpression.toResultSetElements();
        List list2 = this.orderBys() == null ? this.getRootPKFrom(list) : this.orderBysAsTableExpressionColumnNames(tableExpression);
        ResultSetExpression resultSetExpression = this.createDenseRankFunction(list2);
        arrayList.add(resultSetExpression);
        this.extraResultSetElements().add(resultSetExpression);
        arrayList.addAll(list);
        SubSelect subSelect = new SubSelect(arrayList, ListWrapper.list(tableExpression));
        selectStatement.select(this.buildInLineView(subSelect));
        return selectStatement;
    }

    public TableExpression createTableExpressionFor(FullOrSubSelect fullOrSubSelect) {
        TableExpression tableExpression = new TableExpression("BASETABLE");
        tableExpression.fullSelect(fullOrSubSelect);
        tableExpression.addColumnsFromProjectionClause();
        return tableExpression;
    }

    public SubSelect buildInLineView(SubSelect subSelect) {
        Object object;
        SubSelect subSelect2 = new SubSelect();
        Iterator iterator = subSelect.selectClause().getResultSetElements().iterator();
        ArrayList<ResultSetElement> arrayList = new ArrayList<ResultSetElement>();
        SqlIdentifier sqlIdentifier = null;
        while (iterator.hasNext()) {
            ResultSetElement resultSetElement = (ResultSetElement)iterator.next();
            if (resultSetElement instanceof ResultSetExpression) {
                object = ((ResultSetExpression)resultSetElement).newName();
                SqlIdentifier sqlIdentifier2 = new SqlIdentifier((String)object);
                arrayList.add(new ColumnName(sqlIdentifier2));
                if (!((String)object).equalsIgnoreCase("R")) continue;
                sqlIdentifier = sqlIdentifier2;
                continue;
            }
            if (!(resultSetElement instanceof SqlIdentifier) && !(resultSetElement instanceof ColumnName)) continue;
            arrayList.add(resultSetElement);
        }
        object = QueryEngineInfo.isOracle() ? new TableReference(subSelect) : new TableReference(subSelect, COR_ALIAS);
        return new SubSelect(arrayList, ListWrapper.list(object), this.betweenPredicate(sqlIdentifier));
    }

    public ResultSetExpression createDenseRankFunction(List list) {
        DenseRankFunction denseRankFunction = new DenseRankFunction(list);
        return new ResultSetExpression(denseRankFunction, "R");
    }

    public List getRootPKFrom(List list) {
        Iterator iterator = this.resultDescriptor().rdbRootTable().getPrimaryKey().getMembers().iterator();
        ArrayList<Association> arrayList = new ArrayList<Association>();
        while (iterator.hasNext()) {
            RDBColumn rDBColumn = (RDBColumn)iterator.next();
            arrayList.add(new Association(list.get(this.resultDescriptor().position(rDBColumn.getWDOColumn()) - 1), new Boolean(true)));
        }
        return arrayList;
    }

    public List orderBysAsTableExpressionColumnNames(TableExpression tableExpression) {
        Iterator iterator = this.orderBys().iterator();
        ArrayList<Association> arrayList = new ArrayList<Association>();
        while (iterator.hasNext()) {
            Association association = (Association)iterator.next();
            SqlIdentifier sqlIdentifier = this.findTableExpressionColumnName(tableExpression, (RDBColumn)association.key());
            arrayList.add(new Association(sqlIdentifier, association.value()));
        }
        return arrayList;
    }

    public SqlIdentifier findTableExpressionColumnName(TableExpression tableExpression, RDBColumn rDBColumn) {
        Iterator iterator = this.resultDescriptor().fields().iterator();
        int n = 0;
        while (iterator.hasNext()) {
            Object object = ((QueryResultFieldDescriptor)iterator.next()).element();
            if (object instanceof RDBColumn && ((RDBColumn)object).equals(rDBColumn)) {
                return (SqlIdentifier)tableExpression.columnNames().get(n);
            }
            if (object instanceof ResultSetExpression && ((ResultSetExpression)object).isColumn() && ((ResultSetExpression)object).column().equals(rDBColumn)) {
                return new SqlIdentifier(((ResultSetExpression)object).newName());
            }
            ++n;
        }
        return null;
    }
}

