/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wdo.mediator.rdb.queryengine;

import com.ibm.ObjectQuery.crud.util.StDictionary;
import com.ibm.ObjectQuery.crud.util.SymbolTable;

public class QueryEngineInfo {
    private static final String copyright = "(c) Copyright IBM Corporation 2001.";
    private static QueryEngineInfo fSingleton;
    public static final String DB2 = "DB2NT";
    public static final String A_DB2 = "DB2";
    public static final String OS390 = "OS390";
    public static final String SQLSERVER = "SQLSERVER";
    public static final String SYBASE = "SYBASE";
    public static final String INFORMIX = "INFORMIX";
    public static final String CLOUDSCAPE = "CLOUDSCAPE";
    public static final String ORACLE = "ORACLE";
    private boolean useDefinedTableAliasFlag = false;
    private boolean useTableNameAsQualifierFlag = true;
    private boolean generateCastsFlag = true;
    private boolean fUseTableAliasFlag = false;
    private boolean useAliasesForSingleTableStmtsFlag = false;
    private boolean generateSubqueriesFlag = false;
    private boolean qualifyTableNamesFlag = true;
    private boolean useOuterJoinSyntaxFlag = true;
    private boolean generateParmMarkersFlag = true;
    private boolean useColumnNamesFlag = true;
    private boolean fUseDelimitedIdentifiers = false;
    private boolean fSupportsDelimitedIdentifiers = true;
    private boolean fExtraSpaces = true;
    private boolean fSQLJTarget = false;
    private boolean fGenerateSelectInto = false;
    private Integer fTargetVendor;
    private String targetDatabaseString = "DB2";
    private String fTargetDatabaseSubtype = null;
    private String fTargetDatabaseVersion = null;
    private String globalVariablePrefixString = "arg";
    private String globalOutputVariablePrefixString = "out";
    private String argumentIndicatorString = ":";
    private int FormattingLevel = 0;
    private boolean fSelectForUpdateWithColumns = false;
    private StDictionary fRdbQueryTemplates;
    private StDictionary fJdbcTypeMapper;
    private StDictionary fDBTypeMapper;
    private SymbolTable fDbVendorTable;

    public String argumentIndicator() {
        return this.argumentIndicatorString;
    }

    public void argumentIndicator(String string) {
        this.argumentIndicatorString = string;
    }

    public StDictionary defaultJdbcTypeMapper() {
        return null;
    }

    public int formatting() {
        return this.FormattingLevel;
    }

    private void formatting(int n) {
        this.FormattingLevel = n;
    }

    public void fullFormat() {
        this.formatting(2);
    }

    public boolean generateCasts() {
        return this.generateCastsFlag;
    }

    public void generateCasts(boolean bl) {
        this.generateCastsFlag = bl;
    }

    public boolean generateParmMarkers() {
        return this.generateParmMarkersFlag;
    }

    public void generateParmMarkers(boolean bl) {
        this.generateParmMarkersFlag = bl;
    }

    public boolean generateSubqueriesLeftOuterJoins() {
        return this.generateSubqueriesFlag;
    }

    public void generateSubqueriesLeftOuterJoins(boolean bl) {
        this.generateSubqueriesFlag = bl;
    }

    public String globalVariablePrefix() {
        return this.globalVariablePrefixString;
    }

    public void globalVariablePrefix(String string) {
        this.useColumnNames(false);
        this.globalVariablePrefixString = string;
    }

    public String globalOutputVariablePrefix() {
        return this.globalOutputVariablePrefixString;
    }

    public void globalOutputVariablePrefix(String string) {
        this.globalOutputVariablePrefixString = string;
    }

    public void noFormatting() {
        this.formatting(0);
    }

    public void selectForUpdateWithColumns(boolean bl) {
        this.fSelectForUpdateWithColumns = bl;
    }

    public void partialFormatting() {
        this.formatting(1);
    }

    public void qualifyTableNames(boolean bl) {
        this.qualifyTableNamesFlag = bl;
    }

    public Integer targetVendor() {
        return this.fTargetVendor;
    }

    public void targetVendor(Integer n) {
        this.fTargetVendor = n;
    }

    public String targetDatabase() {
        return this.targetDatabaseString;
    }

    public void targetDatabase(String string) {
        this.targetDatabaseString = string;
    }

    public boolean useAliasesForSingleTableStmts() {
        return this.useAliasesForSingleTableStmtsFlag;
    }

    public void useAliasesForSingleTableStmts(boolean bl) {
        this.useAliasesForSingleTableStmtsFlag = bl;
    }

    public boolean useColumnNames() {
        return this.useColumnNamesFlag;
    }

    public void useColumnNames(boolean bl) {
        this.useColumnNamesFlag = bl;
    }

    public boolean useDefinedTableAlias() {
        return this.useDefinedTableAliasFlag;
    }

    public boolean useDelimitedIdentifiers() {
        return this.fUseDelimitedIdentifiers;
    }

    public boolean supportsDelimitedIdentifiers() {
        return this.fSupportsDelimitedIdentifiers;
    }

    public void useTableAliases(boolean bl) {
        this.fUseTableAliasFlag = bl;
    }

    public boolean isUsingTableAliases() {
        return this.fUseTableAliasFlag;
    }

    public void supportsDelimitedIdentifiers(boolean bl) {
        this.fSupportsDelimitedIdentifiers = bl;
    }

    public void useDelimitedIdentifiers(boolean bl) {
        this.fUseDelimitedIdentifiers = bl;
    }

    public boolean useExtraSpaces() {
        return this.fExtraSpaces;
    }

    public void generateSelectInto(boolean bl) {
        this.fGenerateSelectInto = bl;
    }

    public void useSQLJ(boolean bl) {
        if (bl) {
            this.generateParmMarkers(false);
        }
        this.fSQLJTarget = bl;
    }

    public boolean useSQLJ() {
        return this.fSQLJTarget;
    }

    public void useExtraSpaces(boolean bl) {
        this.fExtraSpaces = bl;
    }

    public boolean useOuterJoinSyntax() {
        return this.useOuterJoinSyntaxFlag;
    }

    public boolean selectForUpdateWithColumns() {
        return this.fSelectForUpdateWithColumns;
    }

    public void useOuterJoinSyntax(boolean bl) {
        this.useOuterJoinSyntaxFlag = bl;
    }

    public boolean useQualifiedTableNames() {
        return this.qualifyTableNamesFlag;
    }

    public boolean useTableNameAsQualifier() {
        return this.useTableNameAsQualifierFlag;
    }

    public boolean isGeneratingSelectInto() {
        return this.fGenerateSelectInto;
    }

    public void useTableNameAsQualifier(boolean bl) {
        this.useTableNameAsQualifierFlag = bl;
    }

    public SymbolTable dbVendorTable() {
        if (this.fDbVendorTable == null) {
            this.fDbVendorTable = this.defaultDbVendorTable();
        }
        return this.fDbVendorTable;
    }

    public void dbVendorTable(String[] stringArray) {
        this.fDbVendorTable = this.createDbVendorTable(stringArray);
    }

    public SymbolTable defaultDbVendorTable() {
        String[] stringArray = new String[]{DB2, "1", DB2, "2", DB2, "3", DB2, "4", "DB2MVS", "5", DB2, "6", DB2, "15", "DB2MVS", "16", DB2, "17", DB2, "18", DB2, "23", DB2, "24", ORACLE, "7", ORACLE, "20", INFORMIX, "8", INFORMIX, "14", INFORMIX, "22", SYBASE, "9", SYBASE, "10", SYBASE, "21", SQLSERVER, "11", SQLSERVER, "15", "MYSQL", "12", CLOUDSCAPE, "19", DB2, "13"};
        return this.createDbVendorTable(stringArray);
    }

    public static SymbolTable vendorSymbols() {
        Object[] objectArray = new String[]{"SQL92", "1", "SQL99", "2", "DB2UDBNT_V61", "3", "DB2UDBNT_V71", "4", "DB2UDBOS390_V6", "5", "DB2UDBAS400_V4", "6", "ORACLE_V8", "7", "INFORMIX_V92", "8", "SYBASE_V1192", "9", "SYBASE_V12", "10", "MSSQLSERVER_V7", "11", "MYSQL_V323", "12", "INSTANTDB_V326", "13", "INFORMIX_V73", "14", "MSSQLSERVER_V70", "15", "DB2UDBOS390_V7", "16", "DB2UDBAS400_V5", "17", "DB2UDBNT_V72", "18", "CLOUDSCAPE_V50", "19", "ORACLE_V9", "20", "SYBASE_V125", "21", "INFORMIX_V93", "22", "DB2FAMILY", "23", "DB2UDBNT_V8", "24"};
        return new SymbolTable(objectArray);
    }

    public SymbolTable createDbVendorTable(String[] stringArray) {
        return new SymbolTable(stringArray);
    }

    public String getDatabaseVendor() {
        if (this.targetVendor() == null) {
            return DB2;
        }
        String string = this.dbVendorTable().getSymbol(this.targetVendor());
        if (string == null) {
            return DB2;
        }
        return string;
    }

    public static boolean isDB2() {
        return QueryEngineInfo.singleton().targetDatabase().indexOf(A_DB2) > -1;
    }

    public static boolean isOS390() {
        return QueryEngineInfo.singleton().targetDatabase().indexOf(OS390) > -1;
    }

    public static boolean isSQLServer() {
        return QueryEngineInfo.singleton().targetDatabase().indexOf(SQLSERVER) > -1;
    }

    public static boolean isSybase() {
        return QueryEngineInfo.singleton().targetDatabase().indexOf(SYBASE) > -1;
    }

    public static boolean isCloudscape() {
        return QueryEngineInfo.singleton().targetDatabase().indexOf(CLOUDSCAPE) > -1;
    }

    public static boolean isInformix() {
        return QueryEngineInfo.singleton().targetDatabase().indexOf(INFORMIX) > -1;
    }

    public static boolean isOracle() {
        return QueryEngineInfo.singleton().targetDatabase().indexOf(ORACLE) > -1;
    }

    public static boolean isSQLJ() {
        return QueryEngineInfo.singleton().useSQLJ();
    }

    public static boolean isGenerateSelectInto() {
        return QueryEngineInfo.singleton().isGeneratingSelectInto();
    }

    public static QueryEngineInfo singleton() {
        if (fSingleton == null) {
            fSingleton = new QueryEngineInfo();
        }
        return fSingleton;
    }
}

