/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wdo.mediator.rdb.queryengine;

import com.ibm.ObjectQuery.crud.util.Association;
import com.ibm.ObjectQuery.crud.util.ClassName;
import com.ibm.websphere.wdo.mediator.rdb.metadata.FilterArgument;
import com.ibm.ws.wdo.mediator.rdb.queryengine.QueryEngineException;
import com.ibm.ws.wdo.mediator.rdb.queryengine.QueryInputField;
import com.ibm.ws.wdo.mediator.rdb.queryengine.schema.RDBColumn;
import com.ibm.ws.wdo.mediator.rdb.queryengine.sqlquerytree.SqlStatement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class QueryInputDescriptor {
    private List fInputFields;

    public QueryInputDescriptor() {
    }

    public QueryInputDescriptor(SqlStatement sqlStatement) throws QueryEngineException {
        this.addArguments(sqlStatement);
    }

    public List fields() {
        if (this.fInputFields == null) {
            this.fInputFields = new ArrayList();
        }
        return this.fInputFields;
    }

    public void addField(QueryInputField queryInputField) {
        this.fields().add(queryInputField);
    }

    public void addArguments(SqlStatement sqlStatement) throws QueryEngineException {
        Iterator iterator = sqlStatement.argNamesAndColumns().iterator();
        int n = this.size() + 1;
        while (iterator.hasNext()) {
            Association association = (Association)iterator.next();
            this.addField(new QueryInputField((RDBColumn)association.key(), n++, (String)association.value()));
        }
    }

    public int size() {
        return this.fields().size();
    }

    public void addFilterArguments(List list) {
        Iterator iterator = list.iterator();
        int n = this.size() + 1;
        while (iterator.hasNext()) {
            FilterArgument filterArgument = (FilterArgument)iterator.next();
            this.addField(new QueryInputField(filterArgument.getName(), filterArgument.getType(), n++));
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(ClassName.name(this));
        stringBuffer.append("(");
        Iterator iterator = this.fields().iterator();
        while (iterator.hasNext()) {
            ((QueryInputField)iterator.next()).detailOn(stringBuffer);
            if (!iterator.hasNext()) continue;
            stringBuffer.append(", ");
        }
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    public boolean isEmpty() {
        return !this.fields().isEmpty();
    }
}

