/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wdo.mediator.rdb.queryengine;

import com.ibm.websphere.wdo.mediator.rdb.metadata.Metadata;
import com.ibm.ws.wdo.mediator.rdb.queryengine.QueryEngineException;
import com.ibm.ws.wdo.mediator.rdb.queryengine.QueryResultDescriptor;
import com.ibm.ws.wdo.mediator.rdb.queryengine.SelectBuilder;
import com.ibm.ws.wdo.mediator.rdb.queryengine.SelectStatementCreator;
import com.ibm.ws.wdo.mediator.rdb.queryengine.schema.RDBColumn;
import com.ibm.ws.wdo.mediator.rdb.queryengine.schema.RDBSchema;
import com.ibm.ws.wdo.mediator.rdb.queryengine.sqlquerytree.BasicPredicate;
import com.ibm.ws.wdo.mediator.rdb.queryengine.sqlquerytree.ColumnName;
import com.ibm.ws.wdo.mediator.rdb.queryengine.sqlquerytree.Literal;
import com.ibm.ws.wdo.mediator.rdb.queryengine.sqlquerytree.Predicate;
import com.ibm.ws.wdo.mediator.rdb.queryengine.sqlquerytree.SelectStatement;
import com.ibm.ws.wdo.mediator.rdb.queryengine.sqlquerytree.SqlStatement;

public class UniqueKeySelectBuilder
extends SelectBuilder {
    private Predicate fSearchCondition;

    public UniqueKeySelectBuilder() {
    }

    public UniqueKeySelectBuilder(Metadata metadata, RDBSchema rDBSchema) throws QueryEngineException {
        this.setMetadata(metadata);
        this.setSchema(rDBSchema);
        this.initialize();
    }

    public UniqueKeySelectBuilder(Metadata metadata) throws QueryEngineException {
        this(metadata, new RDBSchema(metadata));
    }

    public SqlStatement defaultStatement() throws QueryEngineException {
        SelectStatementCreator selectStatementCreator = new SelectStatementCreator();
        selectStatementCreator.setSingle();
        selectStatementCreator.resultColumns(this.resultDescriptor().resultSetElements());
        if (this.searchCondition() != null) {
            selectStatementCreator.extraSearchCondition(this.searchCondition());
        }
        selectStatementCreator.forUpdate();
        SelectStatement selectStatement = selectStatementCreator.build();
        return selectStatement;
    }

    public void initialize() throws QueryEngineException {
        ColumnName columnName = new ColumnName((RDBColumn)this.getSchema().uniqueKeyTable().getPrimaryKey().getMembers().get(0));
        Literal literal = new Literal(new Integer(1));
        this.searchCondition(BasicPredicate.equality(columnName, literal));
        super.initialize();
    }

    public void searchCondition(Predicate predicate) {
        this.fSearchCondition = predicate;
    }

    public Predicate searchCondition() {
        return this.fSearchCondition;
    }

    public QueryResultDescriptor createResultDescriptor() {
        return new QueryResultDescriptor(this.getSchema().uniqueKeyTable());
    }
}

