/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wdo.mediator.rdb.queryengine;

import com.ibm.etools.wdo.DataObject;
import com.ibm.etools.wdo.datagraph.impl.EDataObjectImpl;
import com.ibm.websphere.wdo.mediator.rdb.metadata.Column;
import com.ibm.websphere.wdo.mediator.rdb.metadata.Key;
import com.ibm.websphere.wdo.mediator.rdb.metadata.Metadata;
import com.ibm.websphere.wdo.mediator.rdb.metadata.Relationship;
import com.ibm.websphere.wdo.mediator.rdb.metadata.Table;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;

public class ValueMapper {
    private DataObject dataObject;
    private Metadata metadata;
    private EClass eClass;

    public ValueMapper(Metadata metadata, DataObject dataObject) {
        this.metadata = metadata;
        this.dataObject = dataObject;
        this.eClass = ((EDataObjectImpl)dataObject).eClass();
    }

    public Map fieldValues() {
        EList eList = this.eClass.getEAllAttributes();
        Iterator iterator = eList.iterator();
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        while (iterator.hasNext()) {
            EAttribute eAttribute = (EAttribute)iterator.next();
            String string = eAttribute.getName();
            Object object = this.valueForFieldName(string);
            hashMap.put(string, object);
        }
        return hashMap;
    }

    private Object valueForFieldName(String string) {
        if (this.isFKField(string)) {
            return this.valueForFKFieldName(string);
        }
        return this.dataObject.get(string);
    }

    private Object valueForFKFieldName(String string) {
        DataObject dataObject = this.getParent(string);
        if (dataObject == null) {
            return null;
        }
        String string2 = this.getRelatedParentFieldName(string);
        return dataObject.get(string2);
    }

    private boolean isFKField(String string) {
        Table table = this.metadata.getTable(this.eClass.getName());
        Iterator iterator = table.getForeignKeys().iterator();
        while (iterator.hasNext()) {
            Key key = (Key)iterator.next();
            Iterator iterator2 = key.getColumns().iterator();
            while (iterator2.hasNext()) {
                Column column = (Column)iterator2.next();
                if (!string.equals(column.getName())) continue;
                return true;
            }
        }
        return false;
    }

    private DataObject getParent(String string) {
        Key key = this.getFK(string);
        Relationship relationship = this.getRelationship(key);
        String string2 = relationship.getOppositeName();
        return (DataObject)this.dataObject.get(string2);
    }

    private Relationship getRelationship(Key key) {
        Iterator iterator = this.metadata.getRelationships().iterator();
        while (iterator.hasNext()) {
            Relationship relationship = (Relationship)iterator.next();
            if (!relationship.getChildKey().equals(key)) continue;
            return relationship;
        }
        return null;
    }

    private Key getFK(String string) {
        Table table = this.metadata.getTable(this.eClass.getName());
        Iterator iterator = table.getForeignKeys().iterator();
        while (iterator.hasNext()) {
            Key key = (Key)iterator.next();
            Iterator iterator2 = key.getColumns().iterator();
            while (iterator2.hasNext()) {
                Column column = (Column)iterator2.next();
                if (!string.equals(column.getName())) continue;
                return key;
            }
        }
        return null;
    }

    private String getRelatedParentFieldName(String string) {
        Key key = this.getFK(string);
        Relationship relationship = this.getRelationship(key);
        Key key2 = relationship.getParentKey();
        Iterator iterator = key.getColumns().iterator();
        int n = 0;
        while (iterator.hasNext()) {
            Column column = (Column)iterator.next();
            if (column.getName().equals(string)) {
                return ((Column)key2.getColumns().get(n)).getName();
            }
            ++n;
        }
        return null;
    }
}

