/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wdo.mediator.rdb.queryengine.schema;

import com.ibm.ObjectQuery.crud.util.ClassShortName;
import com.ibm.ObjectQuery.crud.util.EqualityRelation;
import com.ibm.ObjectQuery.crud.util.HashFunction;
import com.ibm.ObjectQuery.crud.util.ListWrapper;
import com.ibm.ObjectQuery.crud.util.StSet;
import com.ibm.ws.wdo.mediator.rdb.queryengine.schema.RDBColumn;
import com.ibm.ws.wdo.mediator.rdb.queryengine.schema.RDBReferenceByKey;
import com.ibm.ws.wdo.mediator.rdb.queryengine.schema.RDBTable;
import com.ibm.ws.wdo.mediator.rdb.queryengine.sqlquerytree.ColumnInfo;
import java.util.Iterator;
import java.util.List;

public class Connection {
    private static final String copyright = "(c) Copyright IBM Corporation 2001.";
    private RDBReferenceByKey fReference;

    public Connection() {
    }

    public Connection(RDBReferenceByKey rDBReferenceByKey) {
        this.reference(rDBReferenceByKey);
    }

    public boolean areZeroMembersAllowed() {
        return true;
    }

    public boolean areZeroParentsAllowed() {
        return true;
    }

    public RDBColumn correspondingColumn(RDBColumn rDBColumn) {
        int n = this.parentKeyColumns().indexOf(rDBColumn);
        if (n > -1) {
            return (RDBColumn)this.memberKeyColumns().get(n);
        }
        n = this.memberKeyColumns().indexOf(rDBColumn);
        if (n == -1) {
            return null;
        }
        return (RDBColumn)this.parentKeyColumns().get(n);
    }

    public void detailStringOn(StringBuffer stringBuffer) {
        stringBuffer.append("p[");
        Iterator iterator = this.parentKeyColumns().iterator();
        while (iterator.hasNext()) {
            stringBuffer.append(this.getColumnName(iterator.next()));
            if (!iterator.hasNext()) continue;
            stringBuffer.append(", ");
        }
        stringBuffer.append("] m[");
        iterator = this.memberKeyColumns().iterator();
        while (iterator.hasNext()) {
            stringBuffer.append(this.getColumnName(iterator.next()));
            if (!iterator.hasNext()) continue;
            stringBuffer.append(", ");
        }
        stringBuffer.append("]");
    }

    public String getColumnName(Object object) {
        return new ColumnInfo((RDBColumn)object).getTableQualifiedName();
    }

    public boolean includesColumn(RDBColumn rDBColumn) {
        return this.memberKeyColumns().contains(rDBColumn) || this.parentKeyColumns().contains(rDBColumn);
    }

    public boolean includesTable(RDBTable rDBTable) {
        return this.memberTable().equals(rDBTable) || this.parentTable().equals(rDBTable);
    }

    public void infoStringOn(StringBuffer stringBuffer) {
        stringBuffer.append(this.name());
        stringBuffer.append(" - ");
        this.detailStringOn(stringBuffer);
    }

    public boolean isPKToPK() {
        StSet stSet = new StSet(this.memberTable().getPrimaryKey().getMembers());
        Iterator iterator = this.memberKeyColumns().iterator();
        while (iterator.hasNext()) {
            if (stSet.contains(iterator.next())) continue;
            return false;
        }
        return true;
    }

    public static EqualityRelation equalityRelation() {
        return new EqualityRelation(){

            public boolean equals(Object object, Object object2) {
                if (object == object2) {
                    return true;
                }
                if (object2 == null) {
                    return object.equals(object2);
                }
                if (object == null) {
                    return object2.equals(object);
                }
                if (!(object instanceof Connection) || !(object2 instanceof Connection)) {
                    return object.equals(object2);
                }
                if (((Connection)object).reference() == null) {
                    return ((Connection)object2).reference() == null;
                }
                return ((Connection)object).reference().equals(((Connection)object2).reference());
            }
        };
    }

    public static HashFunction hashFunction() {
        return new HashFunction(){

            public int hashValue(Object object) {
                if (object == null) {
                    throw new RuntimeException("nulls have no hash codes");
                }
                if (!(object instanceof Connection)) {
                    return object.hashCode();
                }
                if (((Connection)object).reference() == null) {
                    return object.hashCode();
                }
                return ((Connection)object).reference().hashCode();
            }
        };
    }

    public boolean isSelfReferencing() {
        return this.memberTable().equals(this.parentTable());
    }

    public List keyColumnsFor(RDBTable rDBTable) {
        if (this.isSelfReferencing()) {
            throw new RuntimeException("self referencing FK");
        }
        if (this.parentTable().equals(rDBTable)) {
            return this.parentKeyColumns();
        }
        return this.memberKeyColumns();
    }

    public List memberKeyColumns() {
        return this.reference().getMembers();
    }

    public RDBTable memberTable() {
        return ((RDBColumn)this.memberKeyColumns().get(0)).getOwningTable();
    }

    public String name() {
        return this.reference().getName();
    }

    public RDBTable opposite(RDBTable rDBTable) {
        if (this.memberTable().equals(rDBTable)) {
            return this.parentTable();
        }
        return this.memberTable();
    }

    public List parentKeyColumns() {
        return this.reference().getTarget().getPrimaryKey().getMembers();
    }

    public RDBTable parentTable() {
        return ((RDBColumn)this.parentKeyColumns().get(0)).getOwningTable();
    }

    public RDBReferenceByKey reference() {
        return this.fReference;
    }

    public void reference(RDBReferenceByKey rDBReferenceByKey) {
        this.fReference = rDBReferenceByKey;
    }

    public List tables() {
        return ListWrapper.list(this.parentTable(), this.memberTable());
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(ClassShortName.name(this));
        stringBuffer.append("(");
        this.infoStringOn(stringBuffer);
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    public boolean isExclusive() {
        return this.reference().getWDORelationship().isExclusive();
    }
}

