/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wdo.mediator.rdb.queryengine.schema;

import com.ibm.websphere.wdo.mediator.rdb.metadata.Column;
import com.ibm.websphere.wdo.mediator.rdb.metadata.Table;
import com.ibm.ws.wdo.mediator.rdb.queryengine.schema.RDBColumn;
import com.ibm.ws.wdo.mediator.rdb.queryengine.schema.RDBEntity;
import com.ibm.ws.wdo.mediator.rdb.queryengine.schema.RDBReferenceByKey;
import com.ibm.ws.wdo.mediator.rdb.queryengine.schema.SQLReference;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class RDBTable
extends RDBEntity {
    private Table fTable;
    private List fColumns;
    private List fRelationships;

    public RDBTable(Table table) {
        this.setWDOTable(table);
        this.initialize();
    }

    public Table getWDOTable() {
        return this.fTable;
    }

    public void setWDOTable(Table table) {
        this.fTable = table;
    }

    public String getName() {
        return this.getWDOTable().getName();
    }

    public void initialize() {
        Iterator iterator = this.getWDOTable().getColumns().iterator();
        while (iterator.hasNext()) {
            this.add(new RDBColumn((Column)iterator.next(), this));
        }
    }

    public List getColumns() {
        if (this.fColumns == null) {
            this.fColumns = new ArrayList();
        }
        return this.fColumns;
    }

    public List getForeignKeys() {
        Iterator iterator = this.getRelationships().iterator();
        ArrayList<RDBReferenceByKey> arrayList = new ArrayList<RDBReferenceByKey>();
        while (iterator.hasNext()) {
            RDBReferenceByKey rDBReferenceByKey = (RDBReferenceByKey)iterator.next();
            if (!rDBReferenceByKey.getTable().equals(this)) continue;
            arrayList.add(rDBReferenceByKey);
        }
        return arrayList;
    }

    public List getRelationships() {
        if (this.fRelationships == null) {
            this.fRelationships = new ArrayList();
        }
        return this.fRelationships;
    }

    public void add(RDBColumn rDBColumn) {
        this.getColumns().add(rDBColumn);
    }

    public void add(RDBReferenceByKey rDBReferenceByKey) {
        this.getRelationships().add(rDBReferenceByKey);
    }

    public RDBColumn findColumn(Column column) {
        Iterator iterator = this.getColumns().iterator();
        while (iterator.hasNext()) {
            RDBColumn rDBColumn = (RDBColumn)iterator.next();
            if (!rDBColumn.getWDOColumn().equals(column)) continue;
            return rDBColumn;
        }
        return null;
    }

    public SQLReference getPrimaryKey() {
        SQLReference sQLReference = new SQLReference();
        Iterator iterator = this.getWDOTable().getPrimaryKey().getColumns().iterator();
        while (iterator.hasNext()) {
            sQLReference.addMember(this.findColumn((Column)iterator.next()));
        }
        return sQLReference;
    }

    public void printDetailOn(StringBuffer stringBuffer) {
        Iterator iterator = this.getColumns().iterator();
        stringBuffer.append(this.getName()).append("[");
        while (iterator.hasNext()) {
            stringBuffer.append(((RDBColumn)iterator.next()).getName());
            if (!iterator.hasNext()) continue;
            stringBuffer.append(", ");
        }
        stringBuffer.append("]");
    }

    public boolean isMemberOfPrimaryKey(RDBColumn rDBColumn) {
        return this.getPrimaryKey().contains(rDBColumn);
    }

    public String getSchemaName() {
        return this.getWDOTable().getSchemaName();
    }

    public boolean hasCollisionColumn() {
        return this.getWDOTable().getCollisionColumn() != null;
    }

    public RDBColumn collisionColumn() {
        return this.findColumn(this.getWDOTable().getCollisionColumn());
    }

    public List getNonPrimaryKeyColumns() {
        Iterator iterator = this.getColumns().iterator();
        ArrayList<RDBColumn> arrayList = new ArrayList<RDBColumn>();
        while (iterator.hasNext()) {
            RDBColumn rDBColumn = (RDBColumn)iterator.next();
            if (this.isMemberOfPrimaryKey(rDBColumn)) continue;
            arrayList.add(rDBColumn);
        }
        return arrayList;
    }

    public boolean hasFilter() {
        return this.getWDOTable().getFilter() != null;
    }
}

