/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wdo.mediator.rdb.queryengine.sqlquerytree;

import com.ibm.ws.wdo.mediator.rdb.queryengine.sqlquerytree.AbstractBasicPredicate;
import com.ibm.ws.wdo.mediator.rdb.queryengine.sqlquerytree.ColumnName;
import com.ibm.ws.wdo.mediator.rdb.queryengine.sqlquerytree.Expression;
import com.ibm.ws.wdo.mediator.rdb.queryengine.sqlquerytree.NullPredicate;
import com.ibm.ws.wdo.mediator.rdb.queryengine.sqlquerytree.SqlNull;
import com.ibm.ws.wdo.mediator.rdb.queryengine.sqlquerytree.Variable;
import java.util.ArrayList;
import java.util.List;

public class BasicPredicate
extends AbstractBasicPredicate {
    private static final String copyright = "(c) Copyright IBM Corporation 2001.";
    private Expression rOperand;

    public BasicPredicate(Expression expression, String string, Expression expression2) {
        this.leftHandSide(expression);
        this.operator(string);
        this.rightHandSide(expression2);
    }

    public List children() {
        ArrayList<Expression> arrayList = new ArrayList<Expression>();
        arrayList.add(this.leftHandSide());
        arrayList.add(this.rightHandSide());
        return arrayList;
    }

    public void equal() {
        this.operator(AbstractBasicPredicate.getOp("equals"));
    }

    public static BasicPredicate equality(Expression expression, Expression expression2) {
        return new BasicPredicate(expression, AbstractBasicPredicate.getOp("equals"), expression2);
    }

    public void evaluateAsNullConditionOn(Expression expression, StringBuffer stringBuffer) {
        NullPredicate nullPredicate = new NullPredicate(expression);
        if (this.isNotEquals()) {
            nullPredicate.negate();
        }
        nullPredicate.evaluateOn(stringBuffer);
    }

    public void evaluateOn(StringBuffer stringBuffer) {
        if (this.isRhsNull()) {
            this.evaluateAsNullConditionOn(this.rightHandSide(), stringBuffer);
            return;
        }
        if (this.isLhsNull()) {
            this.evaluateAsNullConditionOn(this.leftHandSide(), stringBuffer);
            return;
        }
        this.leftHandSide().evaluateOn(stringBuffer);
        if (this.useExtraSpaces()) {
            stringBuffer.append(" ");
        }
        stringBuffer.append(this.operator());
        if (this.useExtraSpaces()) {
            stringBuffer.append(" ");
        }
        this.rightHandSide().evaluateOn(stringBuffer);
    }

    public void gatherVariableColumnsInOrderOn(List list) {
        if (this.isRhsVariable()) {
            list.add(this.leftHandSide());
            return;
        }
        if (this.isLhsVariable()) {
            list.add(this.rightHandSide());
        }
    }

    public void gatherVariablesInOrderOn(List list) {
        if (this.isRhsVariable()) {
            list.add(this.rightHandSide());
            return;
        }
        if (this.isLhsVariable()) {
            list.add(this.leftHandSide());
        }
    }

    public void greaterThan() {
        this.operator(">");
    }

    public static BasicPredicate greaterThan(Expression expression, Expression expression2) {
        return new BasicPredicate(expression, AbstractBasicPredicate.getOp("greaterthan"), expression2);
    }

    public static BasicPredicate greaterThanOrEquals(Expression expression, Expression expression2) {
        return new BasicPredicate(expression, AbstractBasicPredicate.getOp("greaterthanorequals"), expression2);
    }

    public boolean isEquals() {
        return this.operator().equals("=");
    }

    public boolean isEquiJoin() {
        return this.isRhsColumn() && this.isLhsColumn() && this.isEquals();
    }

    public boolean isLhsColumn() {
        return this.leftHandSide() instanceof ColumnName;
    }

    public boolean isLhsNull() {
        return this.leftHandSide() instanceof SqlNull;
    }

    public boolean isLhsVariable() {
        return this.leftHandSide() instanceof Variable;
    }

    public boolean isNotEquals() {
        return this.operator().equals("<>");
    }

    public boolean isRhsColumn() {
        return this.rightHandSide() instanceof ColumnName;
    }

    public boolean isRhsNull() {
        return this.rightHandSide() instanceof SqlNull;
    }

    public boolean isRhsVariable() {
        return this.rightHandSide() instanceof Variable;
    }

    public static BasicPredicate lessThan(Expression expression, Expression expression2) {
        return new BasicPredicate(expression, AbstractBasicPredicate.getOp("lessthan"), expression2);
    }

    public static BasicPredicate lessThanOrEquals(Expression expression, Expression expression2) {
        return new BasicPredicate(expression, AbstractBasicPredicate.getOp("lessthanorequals"), expression2);
    }

    public void notEqual() {
        this.operator("<>");
    }

    public static BasicPredicate notEqual(Expression expression, Expression expression2) {
        return new BasicPredicate(expression, AbstractBasicPredicate.getOp("notequals"), expression2);
    }

    public static BasicPredicate notEquals(Expression expression, Expression expression2) {
        return new BasicPredicate(expression, AbstractBasicPredicate.getOp("notequals"), expression2);
    }

    public void printDetailOn(StringBuffer stringBuffer) {
        stringBuffer.append(this.leftHandSide());
        stringBuffer.append(this.operator());
        stringBuffer.append(this.rightHandSide());
    }

    public Expression rightHandSide() {
        return this.rOperand;
    }

    public void rightHandSide(Expression expression) {
        this.rOperand = expression;
    }
}

