/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wdo.mediator.rdb.queryengine.sqlquerytree;

import com.ibm.ws.wdo.mediator.rdb.queryengine.schema.RDBColumn;
import com.ibm.ws.wdo.mediator.rdb.queryengine.schema.RDBPredefinedType;
import com.ibm.ws.wdo.mediator.rdb.queryengine.sqlquerytree.TableInfo;
import java.util.ArrayList;
import java.util.List;

public class ColumnInfo {
    private static final String copyright = "(c) Copyright IBM Corporation 2001.";
    private RDBColumn fColumn;

    public ColumnInfo() {
    }

    public ColumnInfo(RDBColumn rDBColumn) {
        this.column(rDBColumn);
    }

    public boolean allowsNulls() {
        return this.column().isAllowNull();
    }

    public RDBColumn column() {
        return this.fColumn;
    }

    public void column(RDBColumn rDBColumn) {
        this.fColumn = rDBColumn;
    }

    public void columnStringOn(StringBuffer stringBuffer) {
    }

    public String columnTypeString() {
        StringBuffer stringBuffer = new StringBuffer();
        this.printColumnTypeOn(stringBuffer);
        return stringBuffer.toString();
    }

    public String getQualifiedName() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getTableQualifier());
        stringBuffer.append(".");
        stringBuffer.append(this.column().getName());
        return stringBuffer.toString();
    }

    public String getQualifier() {
        return this.getTableQualifier();
    }

    public List getQualifiers() {
        ArrayList<String> arrayList = new ArrayList<String>();
        TableInfo tableInfo = new TableInfo(this.column().getOwningTable());
        String string = tableInfo.getQualifier();
        if (string != null) {
            arrayList.add(string);
        }
        arrayList.add(tableInfo.name());
        return arrayList;
    }

    public String getTableName() {
        return this.column().getOwningTable().getName();
    }

    public String getTableQualifiedName() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getTableName());
        stringBuffer.append(".");
        stringBuffer.append(this.column().getName());
        return stringBuffer.toString();
    }

    public String getTableQualifier() {
        return new TableInfo(this.column().getOwningTable()).getQualifiedName();
    }

    public RDBPredefinedType getType() {
        return this.column().getType();
    }

    public String getTypeString() {
        return this.column().getType().getTypeString();
    }

    public boolean hasLength() {
        return this.isString() || this.isBlob() || this.isBitString();
    }

    public void infoStringOn(StringBuffer stringBuffer) {
        stringBuffer.append("\t\t");
        stringBuffer.append(this.name());
        for (int i = 0; i < 50 - this.name().length(); ++i) {
            stringBuffer.append(" ");
        }
        this.printColumnTypeOn(stringBuffer);
        if (!this.allowsNulls()) {
            stringBuffer.append(" ");
            stringBuffer.append("not null");
        }
    }

    public boolean isBitString() {
        return this.column().getType().isBitString();
    }

    public boolean isBlob() {
        return this.column().getType().isBlob();
    }

    public boolean isCharacterLargeObjectType() {
        return this.column().getType().isCharacterLargeObjectType();
    }

    public boolean isCharacterStringType() {
        return this.column().getType().isCharacterStringType();
    }

    public boolean isDecimal() {
        return this.column().getType().isDecimal();
    }

    public boolean isFixedNumeric() {
        return this.column().getType().isFixedNumeric();
    }

    public boolean isFloat() {
        return this.column().getType().isFloat();
    }

    public boolean isNumericType() {
        return this.column().getType().isNumericType();
    }

    public boolean isString() {
        return this.column().getType().isString();
    }

    public boolean isTemporalType() {
        return this.column().getType().isTemporalType();
    }

    public boolean isValidPredicateType() {
        if (this.isCharacterLargeObjectType()) {
            return false;
        }
        return !this.isBlob();
    }

    public String name() {
        return this.column().getName();
    }

    public void printColumnTypeOn(StringBuffer stringBuffer) {
        stringBuffer.append(this.getTypeString());
    }

    public void printDdlOn(StringBuffer stringBuffer) {
        stringBuffer.append("\t\t");
        stringBuffer.append(this.name());
        stringBuffer.append(" ");
        this.printColumnTypeOn(stringBuffer);
        if (this.allowsNulls()) {
            stringBuffer.append(" ");
            stringBuffer.append("NOT NULL");
        }
    }

    public void printFixedNumericOn(StringBuffer stringBuffer) {
    }

    public String castType() {
        return this.column().getType().castType();
    }
}

