/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wdo.mediator.rdb.queryengine.sqlquerytree;

import com.ibm.ws.wdo.mediator.rdb.queryengine.schema.RDBColumn;
import com.ibm.ws.wdo.mediator.rdb.queryengine.schema.RDBPredefinedType;
import com.ibm.ws.wdo.mediator.rdb.queryengine.schema.RDBTable;
import com.ibm.ws.wdo.mediator.rdb.queryengine.sqlquerytree.AbstractSqlIdentifier;
import com.ibm.ws.wdo.mediator.rdb.queryengine.sqlquerytree.ColumnInfo;
import com.ibm.ws.wdo.mediator.rdb.queryengine.sqlquerytree.ResultSetElement;
import com.ibm.ws.wdo.mediator.rdb.queryengine.sqlquerytree.SqlIdentifier;
import java.util.Iterator;

public class ColumnName
extends AbstractSqlIdentifier
implements ResultSetElement {
    private static final String copyright = "(c) Copyright IBM Corporation 2001.";
    private static final String PERIOD = ".";
    private String tableAliasString;
    private boolean qualifyFlag = true;
    private boolean fAliasSetFlag = false;
    private boolean fIncludeInInputFlag = true;

    public ColumnName() {
    }

    public ColumnName(RDBColumn rDBColumn) {
        super(rDBColumn);
    }

    public ColumnName(SqlIdentifier sqlIdentifier) {
        super(sqlIdentifier);
    }

    public ColumnName(RDBColumn rDBColumn, String string) {
        super(rDBColumn);
        this.tableAlias(string);
    }

    public ColumnName(SqlIdentifier sqlIdentifier, String string) {
        super(sqlIdentifier);
        this.tableAlias(string);
    }

    public String aliasQualifiedName() {
        if (this.isNull()) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (this.hasTableAlias()) {
            stringBuffer.append(this.tableAlias());
            stringBuffer.append(PERIOD);
            if (this.isUsingDelimitedIdentifiers()) {
                stringBuffer.append(this.delimitedName());
            } else {
                stringBuffer.append(this.columnName());
            }
            return stringBuffer.toString();
        }
        return this.columnName();
    }

    public RDBColumn column() {
        return (RDBColumn)this.value();
    }

    public String columnName() {
        if (this.isString() || this.isNull()) {
            return (String)this.value();
        }
        String string = this.isSqlIdentifier() ? ((SqlIdentifier)this.value()).name() : this.column().getName();
        if (this.isUsingDelimitedIdentifiers()) {
            return this.asDelimitedIdentifier(string);
        }
        return string;
    }

    public void doNotQualify() {
        this.qualifyFlag = false;
    }

    public void evaluateOn(StringBuffer stringBuffer) {
        if (this.isString()) {
            stringBuffer.append(this.value());
            return;
        }
        if (this.isQualified()) {
            stringBuffer.append(this.qualifiedName());
        } else {
            stringBuffer.append(this.columnName());
        }
    }

    public boolean hasTableAlias() {
        return this.tableAliasString != null;
    }

    public boolean isQualified() {
        return this.qualifyFlag;
    }

    public String name() {
        if (this.isSqlIdentifier()) {
            return ((SqlIdentifier)this.value()).name();
        }
        return this.column().getName();
    }

    public String qualifiedName() {
        if (this.isNull()) {
            return null;
        }
        if (this.hasTableAlias() && this.isUsingTableAliases() || this.isAliasAlreadySet()) {
            return this.aliasQualifiedName();
        }
        if (this.isQualified()) {
            if (this.isUsingDelimitedIdentifiers()) {
                StringBuffer stringBuffer = new StringBuffer();
                Iterator iterator = new ColumnInfo(this.column()).getQualifiers().iterator();
                while (iterator.hasNext()) {
                    stringBuffer.append(this.asDelimitedIdentifier((String)iterator.next()));
                    stringBuffer.append(PERIOD);
                }
                stringBuffer.append(this.columnName());
                return stringBuffer.toString();
            }
            if (this.isSqlIdentifier()) {
                return ((SqlIdentifier)this.value()).name();
            }
            return new ColumnInfo(this.column()).getQualifiedName();
        }
        return this.columnName();
    }

    public void qualify() {
        this.qualifyFlag = true;
    }

    public boolean same(RDBColumn rDBColumn) {
        return this.column().equals(rDBColumn);
    }

    public RDBTable table() {
        if (!this.isColumn()) {
            return null;
        }
        return ((RDBColumn)this.value()).getOwningTable();
    }

    public String tableAlias() {
        return this.tableAliasString;
    }

    public void tableAlias(String string) {
        if (this.isAliasAlreadySet()) {
            return;
        }
        this.tableAliasString = string;
    }

    public boolean isColumn() {
        return this.value() instanceof RDBColumn;
    }

    public String tableQualifiedName() {
        if (!this.isColumn()) {
            return null;
        }
        return new ColumnInfo((RDBColumn)this.value()).getQualifiedName();
    }

    public RDBPredefinedType type() {
        return this.column().getType();
    }

    public boolean isAliasAlreadySet() {
        return this.fAliasSetFlag;
    }

    public void aliasSet() {
        this.fAliasSetFlag = true;
    }

    public void invariantTableAlias(String string) {
        this.tableAliasString = string;
        this.aliasSet();
    }

    public void doNotIncludeInInput() {
        this.fIncludeInInputFlag = false;
    }

    public boolean isIncludedInInput() {
        return this.fIncludeInInputFlag;
    }
}

