/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wdo.mediator.rdb.queryengine.sqlquerytree;

import com.ibm.ObjectQuery.crud.util.ClassName;
import com.ibm.ObjectQuery.crud.util.IteratorWithIndex;
import com.ibm.ObjectQuery.crud.util.NameFunction;
import com.ibm.ObjectQuery.crud.util.NamedCollection;
import com.ibm.ws.wdo.mediator.rdb.queryengine.schema.RDBTable;
import com.ibm.ws.wdo.mediator.rdb.queryengine.sqlquerytree.CorrelationAliasTableNameFunction;
import com.ibm.ws.wdo.mediator.rdb.queryengine.sqlquerytree.TableName;
import java.util.Iterator;
import java.util.List;

public class CorrelationAliasTable {
    private static final String copyright = "(c) Copyright IBM Corporation 2001.";
    private NamedCollection fCollection;
    private String rootNameString;
    private static String TableAliasRootNameString;
    private static int fnextRoot;
    private static String ALPHA;
    private boolean fSortFlag = true;

    public CorrelationAliasTable() {
    }

    public CorrelationAliasTable(List list) {
        this.initialize(list);
    }

    public String aliasAt(RDBTable rDBTable) {
        if (rDBTable == null) {
            return null;
        }
        TableName tableName = (TableName)this.collection().named(new TableName(rDBTable).tableName());
        if (tableName == null) {
            return null;
        }
        return tableName.alias();
    }

    public String aliasAt(TableName tableName) {
        if (tableName == null) {
            return null;
        }
        return ((TableName)this.collection().named(tableName.tableName())).alias();
    }

    public TableName aliasedTableAt(RDBTable rDBTable) {
        return (TableName)this.collection().named(rDBTable.getName());
    }

    public TableName aliasedTableAt(TableName tableName) {
        return (TableName)this.collection().named(tableName.tableName());
    }

    public TableName basicGenerateAlias(RDBTable rDBTable) {
        TableName tableName = this.aliasedTableAt(rDBTable);
        if (tableName == null) {
            tableName = this.rebuildAliasTable(rDBTable);
        }
        return tableName;
    }

    public String defaultRootName() {
        return CorrelationAliasTable.tableAliasRootName();
    }

    public static String defaultTableAliasRootName() {
        return "T";
    }

    public void doNotSortEntries() {
        this.fSortFlag = false;
    }

    public NameFunction defaultNameFunction() {
        return new CorrelationAliasTableNameFunction();
    }

    public TableName generateAlias(RDBTable rDBTable) {
        TableName tableName = this.aliasedTableAt(rDBTable);
        if (tableName == null) {
            tableName = this.rebuildAliasTable(rDBTable);
        }
        return tableName;
    }

    public TableName generateAlias(TableName tableName) {
        return this.generateAlias((RDBTable)tableName.value());
    }

    public boolean includes(RDBTable rDBTable) {
        return this.collection().includesName(rDBTable.getName());
    }

    public boolean includes(TableName tableName) {
        return this.collection().includesName(tableName.tableName());
    }

    public void initialize(List list) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            this.generateAlias((RDBTable)iterator.next());
        }
    }

    public TableName rebuildAliasTable(RDBTable rDBTable) {
        return this.rebuildAliasTable(new TableName(rDBTable));
    }

    public TableName rebuildAliasTable(TableName tableName) {
        this.collection().add(tableName);
        if (this.sortFlag()) {
            this.collection().sort();
        }
        IteratorWithIndex iteratorWithIndex = new IteratorWithIndex(this.collection());
        while (iteratorWithIndex.hasNext()) {
            ((TableName)iteratorWithIndex.next()).alias(this.nextName(iteratorWithIndex.position()));
        }
        return tableName;
    }

    private String nextName(int n) {
        return this.rootName() + (n + 1);
    }

    public void sortEntries() {
        this.fSortFlag = true;
    }

    public boolean sortFlag() {
        return this.fSortFlag;
    }

    public static String tableAliasRootName() {
        if (TableAliasRootNameString == null) {
            TableAliasRootNameString = CorrelationAliasTable.defaultTableAliasRootName();
        }
        return TableAliasRootNameString;
    }

    public static void tableAliasRootName(String string) {
        TableAliasRootNameString = string;
    }

    public String rootName() {
        if (this.rootNameString == null) {
            this.rootNameString = this.defaultRootName();
        }
        return this.rootNameString;
    }

    public void rootName(String string) {
        this.rootNameString = string;
    }

    public int size() {
        return this.collection().size();
    }

    public NamedCollection collection() {
        if (this.fCollection == null) {
            this.fCollection = new NamedCollection(this.defaultNameFunction());
        }
        return this.fCollection;
    }

    public static synchronized String nextRootName() {
        String string = new Character(ALPHA.charAt(++fnextRoot % 24)).toString();
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < fnextRoot / 24 + 1; ++i) {
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(ClassName.name(this));
        this.collection().detailOn(stringBuffer);
        return stringBuffer.toString();
    }

    public static synchronized void reset() {
        fnextRoot = -1;
    }

    static {
        fnextRoot = -1;
        ALPHA = "ABCDEFGHIJKLMNOPQRSUVWXYZ";
    }
}

