/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wdo.mediator.rdb.queryengine.sqlquerytree;

import com.ibm.ObjectQuery.crud.util.StSet;
import com.ibm.ObjectQuery.crud.util.TreeNode;
import com.ibm.ws.wdo.mediator.rdb.queryengine.JoinMap;
import com.ibm.ws.wdo.mediator.rdb.queryengine.JoinMapNode;
import com.ibm.ws.wdo.mediator.rdb.queryengine.QueryEngineInfo;
import com.ibm.ws.wdo.mediator.rdb.queryengine.schema.RDBTable;
import com.ibm.ws.wdo.mediator.rdb.queryengine.sqlquerytree.AbstractSqlStatementClause;
import com.ibm.ws.wdo.mediator.rdb.queryengine.sqlquerytree.CorrelationAliasTable;
import com.ibm.ws.wdo.mediator.rdb.queryengine.sqlquerytree.JoinedTable;
import com.ibm.ws.wdo.mediator.rdb.queryengine.sqlquerytree.SubSelect;
import com.ibm.ws.wdo.mediator.rdb.queryengine.sqlquerytree.TableExpression;
import com.ibm.ws.wdo.mediator.rdb.queryengine.sqlquerytree.TableName;
import com.ibm.ws.wdo.mediator.rdb.queryengine.sqlquerytree.TableReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class FromClause
extends AbstractSqlStatementClause {
    private static final String copyright = "(c) Copyright IBM Corporation 2001.";
    public static final String FROM = "FROM ";
    private List fTableReferences;
    private CorrelationAliasTable fAliasTable;
    private boolean fAliasFlag = true;

    public FromClause() {
    }

    public FromClause(List list) {
        this.addTables(list);
    }

    public void addTable(RDBTable rDBTable) {
        if (!this.includes(rDBTable)) {
            this.addTable(new TableReference(this.aliasTable().generateAlias(rDBTable)));
        }
    }

    public void addTable(TableName tableName) {
        if (!this.includes(tableName.table())) {
            this.getTables().add(new TableReference(this.aliasTable().generateAlias(tableName)));
        }
    }

    public void addTable(TableExpression tableExpression) {
        if (!this.includes(tableExpression)) {
            this.getTables().add(new TableReference(tableExpression));
        }
    }

    public void addTable(TableReference tableReference) {
        this.getTables().add(tableReference);
    }

    public void addTables(Collection collection) {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (e instanceof RDBTable) {
                this.addTable((RDBTable)e);
                continue;
            }
            if (e instanceof TableReference) {
                this.addTable((TableReference)e);
                continue;
            }
            if (e instanceof TableName) {
                this.addTable((TableName)e);
                continue;
            }
            if (!(e instanceof TableExpression)) continue;
            this.addTable((TableExpression)e);
        }
    }

    public void addTablesAndLeftOuterJoins(JoinMap joinMap, Collection collection) {
        TableReference tableReference = this.createLeftOuterJoins(joinMap);
        if (tableReference == null) {
            this.addTables(collection);
            return;
        }
        this.addTable(tableReference);
        StSet stSet = new StSet();
        stSet.addAll((Collection)tableReference.tables());
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            RDBTable rDBTable = (RDBTable)iterator.next();
            if (stSet.contains(rDBTable)) continue;
            this.addTable(rDBTable);
        }
    }

    public TableReference createLeftOuterJoins(JoinMap joinMap) {
        TableReference tableReference = null;
        Iterator iterator = ((TreeNode)((Object)joinMap)).toRootIterator();
        while (iterator.hasNext()) {
            JoinMap joinMap2 = (JoinMap)iterator.next();
            if (joinMap2.isRoot()) {
                return tableReference;
            }
            if (tableReference == null) {
                tableReference = new TableReference(new JoinedTable((JoinMapNode)joinMap2, this.aliasTable()));
                continue;
            }
            tableReference = new TableReference(new JoinedTable((JoinMapNode)joinMap2, tableReference, this.aliasTable()));
        }
        return null;
    }

    public CorrelationAliasTable aliasTable() {
        if (this.fAliasTable == null) {
            this.fAliasTable = new CorrelationAliasTable();
        }
        return this.fAliasTable;
    }

    public void aliasTable(CorrelationAliasTable correlationAliasTable) {
        this.fAliasTable = correlationAliasTable;
    }

    public List children() {
        ArrayList arrayList = new ArrayList();
        arrayList.addAll(this.getTables());
        return arrayList;
    }

    public void createAliases() {
        this.fAliasFlag = true;
    }

    public void doNotCreateAliases() {
        this.fAliasFlag = false;
    }

    public void evaluateOn(StringBuffer stringBuffer) {
        stringBuffer.append(FROM);
        Iterator iterator = this.getTables().iterator();
        while (iterator.hasNext()) {
            TableReference tableReference = (TableReference)iterator.next();
            if (!this.isCreatingAliases()) {
                tableReference.doNotUseAlias();
            }
            if (this.isQualifyingTableNames()) {
                tableReference.useQualifiedTableName();
            }
            tableReference.evaluateOn(stringBuffer);
            if (!iterator.hasNext()) continue;
            if (this.useExtraSpaces()) {
                stringBuffer.append(", ");
                continue;
            }
            stringBuffer.append(" ");
        }
    }

    public List getTables() {
        if (this.fTableReferences == null) {
            this.fTableReferences = new ArrayList();
        }
        return this.fTableReferences;
    }

    public boolean includes(RDBTable rDBTable) {
        Iterator iterator = this.getTables().iterator();
        while (iterator.hasNext()) {
            if (!((TableReference)iterator.next()).includes(rDBTable)) continue;
            return true;
        }
        return false;
    }

    public boolean includes(TableExpression tableExpression) {
        Iterator iterator = this.getTables().iterator();
        while (iterator.hasNext()) {
            if (!((TableReference)iterator.next()).includes(tableExpression)) continue;
            return true;
        }
        return false;
    }

    public boolean includes(TableReference tableReference) {
        Iterator iterator = this.getTables().iterator();
        while (iterator.hasNext()) {
            if (!((TableReference)iterator.next()).equals(tableReference)) continue;
            return true;
        }
        return false;
    }

    public boolean includesAlias(RDBTable rDBTable) {
        return this.aliasTable().includes(rDBTable);
    }

    public boolean isCreatingAliases() {
        return this.fAliasFlag;
    }

    public boolean isQualifyingTableNames() {
        return QueryEngineInfo.singleton().useQualifiedTableNames();
    }

    public boolean isSimpleReferences() {
        Iterator iterator = this.getTables().iterator();
        while (iterator.hasNext()) {
            if (((TableReference)iterator.next()).isSimpleReference()) continue;
            return false;
        }
        return true;
    }

    public List joinedTableReferences() {
        Iterator iterator = this.getTables().iterator();
        ArrayList<TableReference> arrayList = new ArrayList<TableReference>();
        while (iterator.hasNext()) {
            TableReference tableReference = (TableReference)iterator.next();
            if (!tableReference.isJoinedTable()) continue;
            arrayList.add(tableReference);
        }
        return arrayList;
    }

    public boolean isSingleTable() {
        if (this.getTables().size() != 1) {
            return false;
        }
        return this.isSimpleReferences();
    }

    public void printDetailOn(StringBuffer stringBuffer) {
        Iterator iterator = this.getTables().iterator();
        while (iterator.hasNext()) {
            TableReference tableReference = (TableReference)iterator.next();
            if (tableReference.isSimpleReference()) {
                stringBuffer.append(tableReference.table().getName());
            } else {
                stringBuffer.append("<joined table>");
            }
            if (!iterator.hasNext()) continue;
            stringBuffer.append(", ");
        }
    }

    public void setTables(List list) {
        this.fTableReferences = list;
    }

    public List tableNames() {
        Iterator iterator = this.getTables().iterator();
        ArrayList arrayList = new ArrayList();
        while (iterator.hasNext()) {
            TableReference tableReference = (TableReference)iterator.next();
            List list = tableReference.tableNames();
            if (list == null) continue;
            arrayList.addAll(list);
        }
        return arrayList;
    }

    public List tables() {
        Iterator iterator = this.getTables().iterator();
        ArrayList arrayList = new ArrayList();
        while (iterator.hasNext()) {
            TableReference tableReference = (TableReference)iterator.next();
            List list = tableReference.tables();
            if (list == null) continue;
            arrayList.addAll(list);
        }
        return arrayList;
    }

    public void qualifyColumnNames(List list) {
        if (list == null || list.isEmpty()) {
            return;
        }
        Iterator iterator = this.getTables().iterator();
        while (iterator.hasNext()) {
            ((TableReference)iterator.next()).qualifyColumnNames(list);
        }
    }

    public String aliasFor(RDBTable rDBTable) {
        if (rDBTable == null) {
            return null;
        }
        String string = this.aliasTable().aliasAt(rDBTable);
        if (string == null) {
            Iterator iterator = this.getTables().iterator();
            while (iterator.hasNext()) {
                string = ((TableReference)iterator.next()).aliasFor(rDBTable);
                if (string == null) continue;
                return string;
            }
        }
        return string;
    }

    public List allAliasTables() {
        Iterator iterator = this.getTables().iterator();
        ArrayList arrayList = new ArrayList();
        while (iterator.hasNext()) {
            ((TableReference)iterator.next()).addAliasTables(arrayList);
        }
        return arrayList;
    }

    public void replaceTablesWith(RDBTable rDBTable, SubSelect subSelect, String string) {
        Iterator iterator = this.getTables().iterator();
        while (iterator.hasNext()) {
            TableReference tableReference = (TableReference)iterator.next();
            tableReference.replaceTablesWith(rDBTable, subSelect, string);
        }
    }
}

