/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wdo.mediator.rdb.queryengine.sqlquerytree;

import com.ibm.ObjectQuery.crud.util.Array;
import com.ibm.ObjectQuery.crud.util.ListWrapper;
import com.ibm.ObjectQuery.crud.util.MultiIterator;
import com.ibm.ObjectQuery.crud.util.VoidFunction;
import com.ibm.ws.wdo.mediator.rdb.queryengine.schema.RDBColumn;
import com.ibm.ws.wdo.mediator.rdb.queryengine.schema.RDBTable;
import com.ibm.ws.wdo.mediator.rdb.queryengine.sqlquerytree.AbstractSqlParseTreeNode;
import com.ibm.ws.wdo.mediator.rdb.queryengine.sqlquerytree.AbstractSqlStatement;
import com.ibm.ws.wdo.mediator.rdb.queryengine.sqlquerytree.ColumnsClause;
import com.ibm.ws.wdo.mediator.rdb.queryengine.sqlquerytree.Expression;
import com.ibm.ws.wdo.mediator.rdb.queryengine.sqlquerytree.SqlStatement;
import com.ibm.ws.wdo.mediator.rdb.queryengine.sqlquerytree.TableName;
import com.ibm.ws.wdo.mediator.rdb.queryengine.sqlquerytree.ValuesClause;
import com.ibm.ws.wdo.mediator.rdb.queryengine.sqlquerytree.Variable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class Insert
extends AbstractSqlStatement
implements SqlStatement {
    private static final String copyright = "(c) Copyright IBM Corporation 2001.";
    private ColumnsClause fColumnsClause = new ColumnsClause();
    private TableName fTable;
    private List fValueClauses = new ArrayList();

    public Insert() {
    }

    public Insert(RDBTable rDBTable) {
        this.table(rDBTable);
        this.addColumnsFromTable();
    }

    public Insert(RDBTable rDBTable, List list) {
        this.table(rDBTable);
        this.addColumns(list);
    }

    public Insert(RDBTable rDBTable, List list, List list2) {
        this.table(rDBTable);
        this.addColumns(list);
        this.addValues(list2);
    }

    public void addColumn(RDBColumn rDBColumn) {
        this.columnsClause().addColumn(rDBColumn);
        this.valuesClause().addNewVariable();
    }

    public void addColumn(RDBColumn rDBColumn, Object object) {
        if (this.columnsClause().addColumn(rDBColumn)) {
            this.valuesClause().addVariable(rDBColumn, object);
        }
    }

    public VoidFunction addColumnFunction() {
        return new VoidFunction(){

            public void value(Object object) {
                Insert.this.addColumn((RDBColumn)object);
            }
        };
    }

    public void addColumns(List list) {
        new ListWrapper(list).apply(this.addColumnFunction());
    }

    public void addColumnsFromTable() {
        new Array(this.schemaTable().getColumns()).apply(this.addColumnFunction());
    }

    public void addExpression(Expression expression) {
        this.valuesClause().addExpression(expression);
    }

    public void addValues(List list) {
        ValuesClause valuesClause = this.createValuesClause();
        valuesClause.values(list);
        this.valuesClauses().add(valuesClause);
    }

    public void setValues(List list) {
        ValuesClause valuesClause = this.valuesClause();
        valuesClause.values(list);
    }

    public List children() {
        ArrayList<AbstractSqlParseTreeNode> arrayList = new ArrayList<AbstractSqlParseTreeNode>();
        arrayList.add(this.columnsClause());
        arrayList.add(this.table());
        arrayList.add(this.valuesClause());
        return arrayList;
    }

    public ColumnsClause columnsClause() {
        return this.fColumnsClause;
    }

    public ValuesClause createValuesClause() {
        return new ValuesClause(this);
    }

    public void evaluateOn(StringBuffer stringBuffer) {
        this.generateVariableNames();
        this.statementOn(stringBuffer);
        Iterator iterator = this.valuesClauses().iterator();
        while (iterator.hasNext()) {
            ((ValuesClause)iterator.next()).evaluateOn(stringBuffer);
            if (!iterator.hasNext()) continue;
            stringBuffer.append(", ");
        }
    }

    public void evaluateOn(StringBuffer stringBuffer, List list) {
        this.generateVariableNames();
        this.statementOn(stringBuffer);
        Iterator iterator = this.valuesClauses().iterator();
        while (iterator.hasNext()) {
            ((ValuesClause)iterator.next()).evaluateOn(stringBuffer, list);
            if (!iterator.hasNext()) continue;
            stringBuffer.append(", ");
        }
    }

    public void gatherVariableColumnsInOrderOn(List list) {
        MultiIterator multiIterator = new MultiIterator(this.columnsClause().columns().iterator(), this.valuesClause().values().iterator());
        while (multiIterator.hasNext()) {
            Object[] objectArray = (Object[])multiIterator.next();
            if (!(objectArray[1] instanceof Variable)) continue;
            list.add(objectArray[0]);
        }
    }

    public void gatherVariablesInOrderOn(List list) {
        MultiIterator multiIterator = new MultiIterator(this.columnsClause().columns().iterator(), this.valuesClause().values().iterator());
        while (multiIterator.hasNext()) {
            Object[] objectArray = (Object[])multiIterator.next();
            if (!(objectArray[1] instanceof Variable)) continue;
            list.add(objectArray[1]);
        }
    }

    public boolean isSingleTable() {
        return true;
    }

    public RDBTable schemaTable() {
        return this.table().table();
    }

    public void statementOn(StringBuffer stringBuffer) {
        stringBuffer.append("INSERT INTO ");
        if (this.isQualifyingTableNames()) {
            this.table().useQualifier();
        }
        this.table().evaluateOn(stringBuffer);
        stringBuffer.append(" ");
        this.columnsClause().evaluateOn(stringBuffer);
        if (this.isFullFormat()) {
            this.crTab(stringBuffer);
        }
        stringBuffer.append(" VALUES ");
    }

    public TableName table() {
        return this.fTable;
    }

    public void table(RDBTable rDBTable) {
        this.fTable = new TableName(rDBTable);
    }

    public void table(TableName tableName) {
        this.fTable = tableName;
    }

    public void values(List list) {
        this.valuesClause().values(list);
    }

    public ValuesClause valuesClause() {
        if (this.valuesClauses().isEmpty()) {
            ValuesClause valuesClause = this.createValuesClause();
            this.valuesClauses().add(valuesClause);
            return valuesClause;
        }
        return (ValuesClause)this.valuesClauses().get(0);
    }

    public List valuesClauses() {
        return this.fValueClauses;
    }
}

