/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wdo.mediator.rdb.queryengine.sqlquerytree;

import com.ibm.ws.wdo.mediator.rdb.queryengine.JoinMapNode;
import com.ibm.ws.wdo.mediator.rdb.queryengine.schema.RDBTable;
import com.ibm.ws.wdo.mediator.rdb.queryengine.sqlquerytree.AbstractSqlStatementClause;
import com.ibm.ws.wdo.mediator.rdb.queryengine.sqlquerytree.ColumnName;
import com.ibm.ws.wdo.mediator.rdb.queryengine.sqlquerytree.CorrelationAliasTable;
import com.ibm.ws.wdo.mediator.rdb.queryengine.sqlquerytree.Predicate;
import com.ibm.ws.wdo.mediator.rdb.queryengine.sqlquerytree.PredicateWithVariables;
import com.ibm.ws.wdo.mediator.rdb.queryengine.sqlquerytree.SqlParseTreeElement;
import com.ibm.ws.wdo.mediator.rdb.queryengine.sqlquerytree.SubSelect;
import com.ibm.ws.wdo.mediator.rdb.queryengine.sqlquerytree.TableReference;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class JoinedTable
extends AbstractSqlStatementClause {
    private static final String copyright = "(c) Copyright IBM Corporation 2001.";
    private static final String OPEN = "(";
    private static final String CLOSE = ")";
    private static final String ON = " ON ";
    private static final String SPACE = " ";
    private static final String LEFTOUTER = "LEFT OUTER JOIN";
    private static final String INNER = "INNER JOIN";
    private static final String RIGHTOUTER = "RIGHT OUTER JOIN";
    private static final String FULLOUTER = "FULL OUTER JOIN";
    private TableReference leftTableRef;
    private String joinOperatorString;
    private TableReference rightTableRef;
    private Predicate joinConditionValue;
    private CorrelationAliasTable fAliasTable;

    public void evaluateOn(StringBuffer stringBuffer) {
        if (this.leftTable().isJoinedTable()) {
            stringBuffer.append(OPEN);
            this.leftTable().evaluateOn(stringBuffer);
            stringBuffer.append(CLOSE);
        } else {
            this.leftTable().evaluateOn(stringBuffer);
        }
        stringBuffer.append(SPACE);
        stringBuffer.append(this.joinOperator());
        stringBuffer.append(SPACE);
        if (this.rightTable().isJoinedTable()) {
            stringBuffer.append(OPEN);
            this.rightTable().evaluateOn(stringBuffer);
            stringBuffer.append(CLOSE);
        } else {
            this.rightTable().evaluateOn(stringBuffer);
        }
        stringBuffer.append(ON);
        this.joinCondition().evaluateOn(stringBuffer);
    }

    public List tables() {
        ArrayList arrayList = new ArrayList();
        arrayList.addAll(this.leftTable().tables());
        arrayList.addAll(this.rightTable().tables());
        return arrayList;
    }

    public List tableNames() {
        ArrayList arrayList = new ArrayList();
        arrayList.addAll(this.leftTable().tableNames());
        arrayList.addAll(this.rightTable().tableNames());
        return arrayList;
    }

    public JoinedTable(TableReference tableReference, TableReference tableReference2, Predicate predicate, boolean bl) {
        if (bl) {
            this.innerJoin();
        } else {
            this.leftOuterJoin();
        }
        this.joinCondition(predicate);
        this.leftTable(tableReference);
        this.rightTable(tableReference2);
    }

    public JoinedTable(JoinMapNode joinMapNode, CorrelationAliasTable correlationAliasTable) {
        if (joinMapNode.isEquiJoin()) {
            this.innerJoin();
        } else {
            this.leftOuterJoin();
        }
        PredicateWithVariables predicateWithVariables = new PredicateWithVariables();
        predicateWithVariables.createEquiJoinFilter(joinMapNode.connection());
        this.leftTable(new TableReference(this.aliasTable().generateAlias(joinMapNode.parentSideTable())));
        this.rightTable(new TableReference(this.aliasTable().generateAlias(joinMapNode.childSideTable())));
        this.joinCondition(predicateWithVariables);
    }

    public JoinedTable(JoinMapNode joinMapNode, TableReference tableReference, CorrelationAliasTable correlationAliasTable) {
        if (joinMapNode.isEquiJoin()) {
            this.innerJoin();
        } else {
            this.leftOuterJoin();
        }
        PredicateWithVariables predicateWithVariables = new PredicateWithVariables();
        predicateWithVariables.createEquiJoinFilter(joinMapNode.connection());
        this.leftTable(new TableReference(this.aliasTable().generateAlias(joinMapNode.parentSideTable())));
        this.rightTable(tableReference);
        this.joinCondition(predicateWithVariables);
    }

    public void fullOuterJoin() {
        this.joinOperatorString = FULLOUTER;
    }

    public void innerJoin() {
        this.joinOperatorString = INNER;
    }

    public Predicate joinCondition() {
        return this.joinConditionValue;
    }

    public void joinCondition(Predicate predicate) {
        this.joinConditionValue = predicate;
    }

    public String joinOperator() {
        if (this.joinOperatorString == null) {
            this.innerJoin();
        }
        return this.joinOperatorString;
    }

    public void leftOuterJoin() {
        this.joinOperatorString = LEFTOUTER;
    }

    public TableReference leftTable() {
        return this.leftTableRef;
    }

    public void leftTable(TableReference tableReference) {
        this.leftTableRef = tableReference;
    }

    public void rightOuterJoin() {
        this.joinOperatorString = RIGHTOUTER;
    }

    public TableReference rightTable() {
        return this.rightTableRef;
    }

    public void rightTable(TableReference tableReference) {
        this.rightTableRef = tableReference;
    }

    public void qualifyColumnNames(List list) {
        if (list == null || list.isEmpty()) {
            return;
        }
        Iterator iterator = this.joinCondition().gatherColumns().iterator();
        while (iterator.hasNext()) {
            ColumnName columnName = (ColumnName)iterator.next();
            RDBTable rDBTable = columnName.table();
            String string = this.aliasTable().aliasAt(rDBTable);
            if (string == null) {
                string = this.aliasFor(rDBTable);
            }
            if (string == null) {
                string = this.firstAlias(list, rDBTable);
            }
            if (string == null) {
                throw new RuntimeException("missing table alias");
            }
            columnName.tableAlias(string);
        }
        if (this.leftTable().isJoinedTable()) {
            this.leftTable().qualifyColumnNames(list);
        }
        if (this.rightTable().isJoinedTable()) {
            this.rightTable().qualifyColumnNames(list);
        }
    }

    public String firstAlias(List list, RDBTable rDBTable) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            CorrelationAliasTable correlationAliasTable = (CorrelationAliasTable)iterator.next();
            String string = correlationAliasTable.aliasAt(rDBTable);
            if (string == null) continue;
            return string;
        }
        return null;
    }

    public void useQualifiedTableName() {
        this.leftTable().useQualifiedTableName();
        this.rightTable().useQualifiedTableName();
    }

    public CorrelationAliasTable aliasTable() {
        if (this.fAliasTable == null) {
            this.fAliasTable = new CorrelationAliasTable();
            this.fAliasTable.rootName(CorrelationAliasTable.nextRootName());
        }
        return this.fAliasTable;
    }

    public void aliasTable(CorrelationAliasTable correlationAliasTable) {
        this.fAliasTable = correlationAliasTable;
    }

    public String aliasFor(RDBTable rDBTable) {
        if (rDBTable == null) {
            return null;
        }
        String string = this.aliasTable().aliasAt(rDBTable);
        if (string != null) {
            return string;
        }
        string = this.leftTable().aliasFor(rDBTable);
        if (string != null) {
            return string;
        }
        return this.rightTable().aliasFor(rDBTable);
    }

    public void addAliasTables(List list) {
        list.add(this.aliasTable());
        this.leftTable().addAliasTables(list);
        this.rightTable().addAliasTables(list);
    }

    public List children() {
        ArrayList<SqlParseTreeElement> arrayList = new ArrayList<SqlParseTreeElement>();
        arrayList.add(this.leftTable());
        arrayList.add(this.rightTable());
        arrayList.add(this.joinCondition());
        return arrayList;
    }

    public void replaceTablesWith(RDBTable rDBTable, SubSelect subSelect, String string) {
        this.leftTable().replaceTablesWith(rDBTable, subSelect, string);
        this.rightTable().replaceTablesWith(rDBTable, subSelect, string);
    }
}

