/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wdo.mediator.rdb.queryengine.sqlquerytree;

import com.ibm.ObjectQuery.crud.util.Association;
import com.ibm.ws.wdo.mediator.rdb.queryengine.schema.RDBColumn;
import com.ibm.ws.wdo.mediator.rdb.queryengine.sqlquerytree.AbstractSqlStatementClause;
import com.ibm.ws.wdo.mediator.rdb.queryengine.sqlquerytree.ColumnName;
import com.ibm.ws.wdo.mediator.rdb.queryengine.sqlquerytree.Expression;
import com.ibm.ws.wdo.mediator.rdb.queryengine.sqlquerytree.ExpressionList;
import com.ibm.ws.wdo.mediator.rdb.queryengine.sqlquerytree.SortKey;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class OrderByClause
extends AbstractSqlStatementClause {
    public static final String ORDER_BY = " ORDER BY ";
    public static final String PREFIX = "O_";
    private ExpressionList fSortKeys;
    private int fIndex = 1;

    public OrderByClause(List list) {
        this.add(list);
    }

    public OrderByClause() {
    }

    public ExpressionList sortKeys() {
        if (this.fSortKeys == null) {
            this.fSortKeys = new ExpressionList();
        }
        return this.fSortKeys;
    }

    public void evaluateOn(StringBuffer stringBuffer) {
        stringBuffer.append(ORDER_BY);
        this.sortKeys().evaluateListOnNoParens(stringBuffer);
    }

    public void add(Expression expression, boolean bl) {
        this.sortKeys().add(new SortKey(expression, bl));
    }

    public void add(List list) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Association association = (Association)iterator.next();
            boolean bl = (Boolean)association.value();
            if (association.key() instanceof ColumnName || association.key() instanceof ColumnName) {
                this.add((Expression)association.key(), bl);
                continue;
            }
            if (!(association.key() instanceof RDBColumn)) continue;
            this.add(new ColumnName((RDBColumn)association.key()), bl);
        }
    }

    public List children() {
        ArrayList arrayList = new ArrayList();
        Iterator iterator = this.sortKeys().iterator();
        while (iterator.hasNext()) {
            arrayList.addAll(((SortKey)iterator.next()).children());
        }
        return arrayList;
    }

    public void printDetailOn(StringBuffer stringBuffer) {
        Iterator iterator = this.sortKeys().iterator();
        while (iterator.hasNext()) {
            stringBuffer.append(((SortKey)iterator.next()).toString());
            if (!iterator.hasNext()) continue;
            stringBuffer.append(", ");
        }
    }

    public int nextIndex() {
        return this.fIndex++;
    }

    public String nextAlias() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(PREFIX).append(this.nextIndex());
        return stringBuffer.toString();
    }

    public void generateAliases() {
        Iterator iterator = this.sortKeys().iterator();
        while (iterator.hasNext()) {
            ((SortKey)iterator.next()).alias(this.nextAlias());
        }
    }
}

