/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wdo.mediator.rdb.queryengine.sqlquerytree;

import com.ibm.ObjectQuery.crud.util.StSet;
import com.ibm.ws.wdo.mediator.rdb.queryengine.sqlquerytree.AbstractSqlStatement;
import com.ibm.ws.wdo.mediator.rdb.queryengine.sqlquerytree.ExpressionList;
import com.ibm.ws.wdo.mediator.rdb.queryengine.sqlquerytree.ForUpdateClause;
import com.ibm.ws.wdo.mediator.rdb.queryengine.sqlquerytree.FromClause;
import com.ibm.ws.wdo.mediator.rdb.queryengine.sqlquerytree.FullOrSubSelect;
import com.ibm.ws.wdo.mediator.rdb.queryengine.sqlquerytree.FullSelect;
import com.ibm.ws.wdo.mediator.rdb.queryengine.sqlquerytree.ParentSelect;
import com.ibm.ws.wdo.mediator.rdb.queryengine.sqlquerytree.Predicate;
import com.ibm.ws.wdo.mediator.rdb.queryengine.sqlquerytree.ReadOnlyClause;
import com.ibm.ws.wdo.mediator.rdb.queryengine.sqlquerytree.SelectClause;
import com.ibm.ws.wdo.mediator.rdb.queryengine.sqlquerytree.SqlParseTreeElement;
import com.ibm.ws.wdo.mediator.rdb.queryengine.sqlquerytree.SqlStatement;
import com.ibm.ws.wdo.mediator.rdb.queryengine.sqlquerytree.SubSelect;
import com.ibm.ws.wdo.mediator.rdb.queryengine.sqlquerytree.TableExpression;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class SelectStatement
extends AbstractSqlStatement
implements ParentSelect,
SqlStatement {
    private static final String copyright = "(c) Copyright IBM Corporation 2001.";
    private static final String WITH = "WITH ";
    private static final String BLANK = " ";
    private ExpressionList fCommonTableExpressions;
    private FullOrSubSelect fSelect;
    private ForUpdateClause fForUpdate;
    private ReadOnlyClause fReadOnly;
    private boolean fIsSingle = false;

    public SelectStatement() {
    }

    public SelectStatement(FullOrSubSelect fullOrSubSelect) {
        this.select(fullOrSubSelect);
    }

    public boolean isSingle() {
        return this.fIsSingle;
    }

    public void setSingle() {
        this.fIsSingle = true;
    }

    public void addWhereClause() {
        this.select().addWhereClause();
    }

    public void addForUpdateClause() {
        this.fForUpdate = new ForUpdateClause(this);
    }

    public void addForUpdateClauseWithOneColumn() {
        this.addForUpdateClause();
        this.forUpdate().addSingleColumn();
    }

    public void addForUpdateClauseWithColumns() {
        this.addForUpdateClause();
        this.forUpdate().addAllColumns();
    }

    public boolean hasForUpdateClause() {
        return this.forUpdate() != null;
    }

    public boolean isSelectInto() {
        return this.select().isSelectInto();
    }

    public List children() {
        ArrayList<SqlParseTreeElement> arrayList = new ArrayList<SqlParseTreeElement>();
        if (this.select() == null) {
            return arrayList;
        }
        arrayList.add(this.select());
        if (this.forUpdate() != null) {
            arrayList.add(this.forUpdate());
        }
        if (this.forUpdate() != null) {
            arrayList.add(this.forUpdate());
        }
        if (this.readOnly() != null) {
            arrayList.add(this.readOnly());
        }
        return arrayList;
    }

    public ExpressionList commonTableExpressions() {
        if (this.fCommonTableExpressions == null) {
            this.fCommonTableExpressions = new ExpressionList();
        }
        return this.fCommonTableExpressions;
    }

    public void evaluateOn(StringBuffer stringBuffer) {
        this.generateVariableNames();
        if (this.hasForUpdateClause() && this.isSQLServer()) {
            this.select().setForUpdateOnTables();
        }
        if (!this.commonTableExpressions().isEmpty()) {
            stringBuffer.append(WITH);
            this.commonTableExpressions().evaluateListOnNoParens(stringBuffer);
        }
        stringBuffer.append(BLANK);
        if (this.select() != null) {
            this.select().evaluateOn(stringBuffer);
        }
        if (this.hasForUpdateClause()) {
            this.forUpdate().evaluateOn(stringBuffer);
        }
        if (this.readOnly() != null) {
            this.readOnly().evaluateOn(stringBuffer);
        }
    }

    public void evaluateOn(StringBuffer stringBuffer, List list) {
        this.generateVariableNames();
        if (this.hasForUpdateClause() && this.isSQLServer()) {
            this.select().setForUpdateOnTables();
        }
        if (!this.commonTableExpressions().isEmpty()) {
            stringBuffer.append(WITH);
            this.commonTableExpressions().evaluateListOnNoParens(stringBuffer);
        }
        stringBuffer.append(BLANK);
        if (this.select() != null) {
            this.select().evaluateOn(stringBuffer, list);
        }
        if (this.hasForUpdateClause()) {
            this.forUpdate().evaluateOn(stringBuffer);
        }
        if (this.readOnly() != null) {
            this.readOnly().evaluateOn(stringBuffer);
        }
    }

    public void except(FullOrSubSelect fullOrSubSelect) {
        FullSelect fullSelect = new FullSelect();
        fullSelect.except(this.select(), fullOrSubSelect);
        this.select(fullSelect);
    }

    public void exceptAll(FullOrSubSelect fullOrSubSelect) {
        FullSelect fullSelect = new FullSelect();
        fullSelect.exceptAll(this.select(), fullOrSubSelect);
        this.select(fullSelect);
    }

    public FromClause firstFromClause() {
        return this.select().firstFromClause();
    }

    public SelectClause firstSelectClause() {
        return this.select().firstSelectClause();
    }

    public Collection getSelectClauses() {
        return this.select().getSelectClauses();
    }

    public ForUpdateClause forUpdate() {
        return this.fForUpdate;
    }

    public void gatherVariableColumnsInOrderOn(List list) {
        this.select().gatherVariableColumnsInOrderOn(list);
    }

    public void gatherVariablesInOrderOn(List list) {
        Iterator iterator = this.commonTableExpressions().iterator();
        while (iterator.hasNext()) {
            ((TableExpression)iterator.next()).gatherVariablesInOrderOn(list);
        }
        this.select().gatherVariablesInOrderOn(list);
    }

    public boolean hasWhereClause() {
        return this.select().hasWhereClause();
    }

    public void intersect(FullOrSubSelect fullOrSubSelect) {
        FullSelect fullSelect = new FullSelect();
        fullSelect.intersect(this.select(), fullOrSubSelect);
        this.select(fullSelect);
    }

    public List getColumns() {
        Iterator iterator = this.getSelectClauses().iterator();
        StSet stSet = new StSet();
        while (iterator.hasNext()) {
            SelectClause selectClause = (SelectClause)iterator.next();
            stSet.addAll((Collection)selectClause.getColumns());
        }
        return stSet.toList();
    }

    public void intersectAll(FullOrSubSelect fullOrSubSelect) {
        FullSelect fullSelect = new FullSelect();
        fullSelect.intersectAll(this.select(), fullOrSubSelect);
        this.select(fullSelect);
    }

    public boolean isDistinct() {
        return this.select().isDistinct();
    }

    public boolean isSingleTable() {
        return this.select().isSingleTable();
    }

    public void addNativeFilter(String string) {
        this.select().addNativeFilter(string);
    }

    public ReadOnlyClause readOnly() {
        return this.fReadOnly;
    }

    public FullOrSubSelect select() {
        return this.fSelect;
    }

    public void select(FullOrSubSelect fullOrSubSelect) {
        this.fSelect = fullOrSubSelect;
        fullOrSubSelect.parentSelect(this);
    }

    public void selectFrom(List list) {
        this.select(new SubSelect(list));
    }

    public void selectFrom(List list, List list2) {
        this.select(new SubSelect(list, list2));
    }

    public void selectFromWhere(List list, List list2, Predicate predicate) {
        this.select(new SubSelect(list, list2, predicate));
    }

    public List tableScope() {
        return this.select().tableScope();
    }

    public List tableNamesInSelect() {
        return this.select().tableNames();
    }

    public void union(FullOrSubSelect fullOrSubSelect) {
        FullSelect fullSelect = new FullSelect();
        fullSelect.union(this.select(), fullOrSubSelect);
        this.select(fullSelect);
    }

    public void unionAll(FullOrSubSelect fullOrSubSelect) {
        FullSelect fullSelect = new FullSelect();
        fullSelect.unionAll(this.select(), fullOrSubSelect);
        this.select(fullSelect);
    }

    public void useEmptyWhereClause() {
        this.select().useEmptyWhereClause();
    }

    public int numberOfOutputHostVariables() {
        return this.select().numberOfOutputHostVariables();
    }

    public void normalSelectClause() {
        this.select().normalSelectClause();
    }

    public List outputArgNamesAndColumns() {
        return this.select().outputArgNamesAndColumns();
    }

    public boolean hasSetOperations() {
        return this.select().hasSetOperations();
    }

    public void addTableExpression(TableExpression tableExpression) {
        this.commonTableExpressions().add(tableExpression);
    }

    public List branches() {
        ArrayList arrayList = new ArrayList();
        this.select().addBranches(arrayList);
        return arrayList;
    }

    public boolean hasCTEs() {
        return this.fCommonTableExpressions != null && !this.fCommonTableExpressions.isEmpty();
    }
}

