/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wdo.mediator.rdb.queryengine.sqlquerytree;

import com.ibm.ObjectQuery.crud.util.ListWrapper;
import com.ibm.ws.wdo.mediator.rdb.queryengine.schema.RDBColumn;
import com.ibm.ws.wdo.mediator.rdb.queryengine.sqlquerytree.AbstractSqlParseTreeNode;
import com.ibm.ws.wdo.mediator.rdb.queryengine.sqlquerytree.ColumnName;
import com.ibm.ws.wdo.mediator.rdb.queryengine.sqlquerytree.Expression;
import com.ibm.ws.wdo.mediator.rdb.queryengine.sqlquerytree.SqlIdentifier;
import java.util.List;

public class SortKey
extends AbstractSqlParseTreeNode
implements Expression {
    public static final String ASC = " ASC";
    public static final String DESC = " DESC";
    private Expression fExpression;
    private boolean fAscending = true;
    private String fAlias;

    public SortKey(Expression expression, boolean bl) {
        this.expression(expression);
        if (!bl) {
            this.descending();
        }
    }

    public SortKey(Expression expression, boolean bl, String string) {
        this.expression(expression);
        this.alias(string);
        if (!bl) {
            this.descending();
        }
    }

    public void expression(Expression expression) {
        this.fExpression = expression;
    }

    public Expression expression() {
        return this.fExpression;
    }

    public void printDetailOn(StringBuffer stringBuffer) {
        stringBuffer.append(this.expression().toString());
    }

    public boolean isColumn() {
        return this.expression() instanceof ColumnName;
    }

    public boolean isIdentifier() {
        return this.expression() instanceof SqlIdentifier;
    }

    public void descending() {
        this.fAscending = false;
    }

    public boolean isAscending() {
        return this.fAscending;
    }

    public void evaluateOn(StringBuffer stringBuffer) {
        if (this.alias() != null) {
            stringBuffer.append(this.alias());
        } else {
            if (this.isColumn()) {
                ((ColumnName)this.expression()).doNotQualify();
            }
            this.expression().evaluateOn(stringBuffer);
        }
        if (this.isAscending()) {
            stringBuffer.append(ASC);
        } else {
            stringBuffer.append(DESC);
        }
    }

    public List children() {
        if (this.isColumn() || this.isIdentifier()) {
            return ListWrapper.list(this.expression());
        }
        return this.expression().children();
    }

    public String alias() {
        return this.fAlias;
    }

    public void alias(String string) {
        this.fAlias = string;
    }

    public RDBColumn column() {
        if (this.isColumn()) {
            return ((ColumnName)this.expression()).column();
        }
        return null;
    }
}

