/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wdo.mediator.rdb.queryengine.sqlquerytree;

import com.ibm.ws.wdo.mediator.rdb.queryengine.sqlquerytree.AbstractSqlStatement;
import com.ibm.ws.wdo.mediator.rdb.queryengine.sqlquerytree.ColumnName;
import com.ibm.ws.wdo.mediator.rdb.queryengine.sqlquerytree.CorrelationAliasTable;
import com.ibm.ws.wdo.mediator.rdb.queryengine.sqlquerytree.Predicate;
import com.ibm.ws.wdo.mediator.rdb.queryengine.sqlquerytree.WhereClause;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public abstract class SqlStatementWithWhereClause
extends AbstractSqlStatement {
    private static final String copyright = "(c) Copyright IBM Corporation 2001.";
    private WhereClause fWhereClause;
    private boolean fEmptyWhereClauseFlag = false;

    public void addEmptyWhereClause() {
        this.whereClause(new WhereClause());
    }

    public void addWhereClause() {
        if (!this.hasWhereClause()) {
            this.whereClause(new WhereClause(this));
        }
    }

    public abstract CorrelationAliasTable aliasTable();

    public List allAliasTables() {
        ArrayList<CorrelationAliasTable> arrayList = new ArrayList<CorrelationAliasTable>();
        if (this.aliasTable() == null) {
            return arrayList;
        }
        arrayList.add(this.aliasTable());
        return arrayList;
    }

    public void and(Predicate predicate) {
        this.initWhereClause();
        this.whereClause().and(predicate);
    }

    public void and(WhereClause whereClause) {
        this.initWhereClause();
        this.whereClause().and(whereClause);
    }

    public void doNotQualify() {
        if (this.whereClause() == null) {
            return;
        }
        Iterator iterator = this.whereClause().gatherColumns().iterator();
        while (iterator.hasNext()) {
            ((ColumnName)iterator.next()).doNotQualify();
        }
    }

    public void evaluateOn(StringBuffer stringBuffer) {
        this.generateVariableNames();
        this.statementOn(stringBuffer);
        if (this.whereClause() == null) {
            return;
        }
        if (this.isSingleTable() && !this.isQualifyingColumnNames() && !this.isUsingAliases()) {
            this.doNotQualify();
        }
        if (this.isQualifyingColumnNames() && !this.isUsingAliases()) {
            this.qualify();
        }
        if (this.isUsingAliases()) {
            this.whereClause().qualifyColumnNames(this.allAliasTables());
        }
        this.whereClause().evaluateOn(this.isUsingEmptyWhereClause(), stringBuffer);
    }

    public void evaluateOn(StringBuffer stringBuffer, List list) {
        this.generateVariableNames();
        this.statementOn(stringBuffer);
        if (this.whereClause() == null) {
            return;
        }
        if (this.isSingleTable() && !this.isQualifyingColumnNames() && !this.isUsingAliases()) {
            this.doNotQualify();
        }
        if (this.isQualifyingColumnNames() && !this.isUsingAliases()) {
            this.qualify();
        }
        if (this.isUsingAliases()) {
            this.whereClause().qualifyColumnNames(this.allAliasTables());
        }
        this.whereClause().evaluateOn(this.isUsingEmptyWhereClause(), stringBuffer, list);
    }

    public void gatherVariableColumnsInOrderOn(List list) {
        if (this.hasWhereClause()) {
            this.whereClause().gatherVariableColumnsInOrderOn(list);
        }
    }

    public void gatherVariablesInOrderOn(List list) {
        if (this.hasWhereClause()) {
            this.whereClause().gatherVariablesInOrderOn(list);
        }
    }

    public boolean hasWhereClause() {
        return this.fWhereClause != null;
    }

    public void initWhereClause() {
        if (this.fWhereClause == null) {
            this.fWhereClause = new WhereClause(this);
        }
    }

    public abstract boolean isSingleTable();

    public boolean isUsingEmptyWhereClause() {
        return this.fEmptyWhereClauseFlag;
    }

    public List nativeFilters() {
        if (this.whereClause() == null) {
            return null;
        }
        return this.whereClause().nativeFilters();
    }

    public void addNativeFilter(String string) {
        if (this.whereClause() == null) {
            this.fWhereClause = new WhereClause();
        }
        this.whereClause().addNativeFilter(string);
    }

    public void not() {
        this.whereClause().not();
    }

    public void or(Predicate predicate) {
        this.initWhereClause();
        this.whereClause().or(predicate);
    }

    public void or(WhereClause whereClause) {
        this.initWhereClause();
        this.whereClause().or(whereClause);
    }

    public void qualify() {
        if (this.whereClause() == null) {
            return;
        }
        Iterator iterator = this.whereClause().gatherColumns().iterator();
        while (iterator.hasNext()) {
            ((ColumnName)iterator.next()).qualify();
        }
    }

    public abstract void statementOn(StringBuffer var1);

    public void useEmptyWhereClause() {
        this.fEmptyWhereClauseFlag = true;
    }

    public WhereClause whereClause() {
        return this.fWhereClause;
    }

    public void whereClause(WhereClause whereClause) {
        this.fWhereClause = whereClause;
        whereClause.statement(this);
    }

    public int predicateSize() {
        return this.whereClause().predicateSize();
    }
}

