/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wdo.mediator.rdb.queryengine.sqlquerytree;

import com.ibm.ObjectQuery.crud.util.ListWrapper;
import com.ibm.ObjectQuery.crud.util.StSet;
import com.ibm.ws.wdo.mediator.rdb.queryengine.schema.RDBColumn;
import com.ibm.ws.wdo.mediator.rdb.queryengine.schema.RDBTable;
import com.ibm.ws.wdo.mediator.rdb.queryengine.sqlquerytree.AbstractSqlStatementClause;
import com.ibm.ws.wdo.mediator.rdb.queryengine.sqlquerytree.ColumnName;
import com.ibm.ws.wdo.mediator.rdb.queryengine.sqlquerytree.CorrelationAliasTable;
import com.ibm.ws.wdo.mediator.rdb.queryengine.sqlquerytree.FromClause;
import com.ibm.ws.wdo.mediator.rdb.queryengine.sqlquerytree.FullOrSubSelect;
import com.ibm.ws.wdo.mediator.rdb.queryengine.sqlquerytree.FullSelect;
import com.ibm.ws.wdo.mediator.rdb.queryengine.sqlquerytree.GroupByClause;
import com.ibm.ws.wdo.mediator.rdb.queryengine.sqlquerytree.HavingClause;
import com.ibm.ws.wdo.mediator.rdb.queryengine.sqlquerytree.OrderByClause;
import com.ibm.ws.wdo.mediator.rdb.queryengine.sqlquerytree.ParentSelect;
import com.ibm.ws.wdo.mediator.rdb.queryengine.sqlquerytree.Predicate;
import com.ibm.ws.wdo.mediator.rdb.queryengine.sqlquerytree.ResultSetElement;
import com.ibm.ws.wdo.mediator.rdb.queryengine.sqlquerytree.ResultSetExpression;
import com.ibm.ws.wdo.mediator.rdb.queryengine.sqlquerytree.SelectClause;
import com.ibm.ws.wdo.mediator.rdb.queryengine.sqlquerytree.SelectOrExpression;
import com.ibm.ws.wdo.mediator.rdb.queryengine.sqlquerytree.SelectStatement;
import com.ibm.ws.wdo.mediator.rdb.queryengine.sqlquerytree.SqlIdentifier;
import com.ibm.ws.wdo.mediator.rdb.queryengine.sqlquerytree.SqlStatementWithWhereClause;
import com.ibm.ws.wdo.mediator.rdb.queryengine.sqlquerytree.TableExpression;
import com.ibm.ws.wdo.mediator.rdb.queryengine.sqlquerytree.TableName;
import com.ibm.ws.wdo.mediator.rdb.queryengine.sqlquerytree.TableReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class SubSelect
extends SqlStatementWithWhereClause
implements FullOrSubSelect,
SelectOrExpression {
    private static final String copyright = "(c) Copyright IBM Corporation 2001.";
    private static final String SELECT = "SELECT ";
    private static final String BLANK = " ";
    private SelectClause fSelectClause;
    private FromClause fFromClause;
    private GroupByClause fGroupByClause;
    private HavingClause fHavingClause;
    private SubSelect fContainingSubSelect;
    private ParentSelect fParentSelect;
    private OrderByClause fOrderByClause;

    public SubSelect() {
    }

    public SubSelect(List list) {
        this.select(list);
    }

    public SubSelect(TableReference tableReference) {
        this.select(tableReference);
    }

    public SubSelect(List list, List list2) {
        this.selectFrom(list, list2);
    }

    public SubSelect(List list, List list2, Predicate predicate) {
        this.selectFromWhere(list, list2, predicate);
    }

    public void parentSelect(ParentSelect parentSelect) {
        this.fParentSelect = parentSelect;
    }

    public ParentSelect parentSelect() {
        return this.fParentSelect;
    }

    public void addColumn(RDBColumn rDBColumn) {
        if (!this.includesTable(rDBColumn.getOwningTable())) {
            this.addTable(rDBColumn.getOwningTable());
        }
        this.selectClause().addColumn(rDBColumn);
    }

    public void addColumn(ResultSetElement resultSetElement) {
        if (resultSetElement.table() != null && resultSetElement instanceof ColumnName && !this.includesTable(resultSetElement.table())) {
            this.addTable(resultSetElement.table());
        }
        this.selectClause().addColumn(resultSetElement);
    }

    public void addColumnFirst(ResultSetExpression resultSetExpression) {
        if (resultSetExpression.table() != null && !this.includesTable(resultSetExpression.table())) {
            this.addTable(resultSetExpression.table());
        }
        this.selectClause().addColumnFirst(resultSetExpression);
    }

    public void addColumnFirst(ResultSetElement resultSetElement) {
        if (resultSetElement.table() != null && !this.includesTable(resultSetElement.table())) {
            this.addTable(resultSetElement.table());
        }
        this.selectClause().addColumnFirst(resultSetElement);
    }

    public void addColumns(List list) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            this.addColumn((ResultSetElement)iterator.next());
        }
    }

    public void addTable(RDBTable rDBTable) {
        if (!this.fromClause().includes(rDBTable)) {
            this.fromClause().addTable(rDBTable);
        }
    }

    public void addTable(TableName tableName) {
        if (!this.fromClause().includes(tableName.table())) {
            this.fromClause().addTable(tableName);
        }
    }

    public void addTable(TableExpression tableExpression) {
        if (!this.fromClause().includes(tableExpression)) {
            this.fromClause().addTable(tableExpression);
        }
    }

    public void addTable(TableReference tableReference) {
        if (!this.fromClause().includes(tableReference)) {
            this.fromClause().addTable(tableReference);
        }
    }

    public void addTables(Collection collection) {
        this.fromClause().addTables(collection);
    }

    public void addTablesFrom(List list) {
        StSet stSet = new StSet();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!(e instanceof RDBColumn)) continue;
            stSet.add(((RDBColumn)e).getOwningTable());
        }
        this.fromClause().addTables(stSet.toList());
    }

    public void addTablesTo(Collection collection) {
        Iterator iterator = this.fromClause().getTables().iterator();
        while (iterator.hasNext()) {
            collection.add(((TableReference)iterator.next()).table());
        }
    }

    public void addTableNamesTo(Collection collection) {
        collection.addAll(this.fromClause().tableNames());
    }

    public String aliasFor(RDBTable rDBTable) {
        return this.aliasTable().aliasAt(rDBTable);
    }

    public CorrelationAliasTable aliasTable() {
        return this.fromClause().aliasTable();
    }

    public void aliasTable(CorrelationAliasTable correlationAliasTable) {
        this.fromClause().aliasTable(correlationAliasTable);
    }

    public List allAliasTables() {
        ArrayList<CorrelationAliasTable> arrayList = new ArrayList<CorrelationAliasTable>();
        arrayList.add(this.aliasTable());
        arrayList.addAll(this.fromClause().allAliasTables());
        return arrayList;
    }

    public List children() {
        ArrayList<AbstractSqlStatementClause> arrayList = new ArrayList<AbstractSqlStatementClause>();
        if (this.selectClause() != null) {
            arrayList.add(this.selectClause());
        }
        arrayList.add(this.fromClause());
        if (this.whereClause() != null) {
            arrayList.add(this.whereClause());
        }
        if (this.hasOrderByClause()) {
            arrayList.add(this.orderByClause());
        }
        return arrayList;
    }

    public SelectClause createSelectClause(List list) {
        SelectClause selectClause = new SelectClause(this);
        this.selectClause(selectClause);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (e instanceof RDBColumn) {
                selectClause.addColumn((ColumnName)this.asLiteral(e));
                continue;
            }
            if (e instanceof SqlIdentifier) {
                selectClause.addColumn(new ColumnName((SqlIdentifier)e));
                continue;
            }
            selectClause.addColumn((ResultSetElement)e);
        }
        return selectClause;
    }

    public void gatherVariableColumnsInOrderOn(List list) {
        this.selectClause().gatherVariableColumnsInOrderOn(list);
        super.gatherVariableColumnsInOrderOn(list);
    }

    public void gatherVariablesInOrderOn(List list) {
        this.selectClause().gatherVariablesInOrderOn(list);
        super.gatherVariablesInOrderOn(list);
    }

    public void distinct() {
        this.selectClause().distinct();
    }

    public void evaluateOn(StringBuffer stringBuffer) {
        this.statementOn(stringBuffer);
        if (this.whereClause() != null) {
            if (this.isSingleTable() && !this.isQualifyingColumnNames() && !this.isUsingAliases()) {
                this.doNotQualify();
            }
            if (this.isQualifyingColumnNames() && !this.isUsingAliases()) {
                this.qualify();
            }
            if (this.isUsingAliases() || !this.isSingleTable()) {
                this.whereClause().qualifyColumnNames(this.allAliasTables());
            }
            this.whereClause().evaluateOn(this.isUsingEmptyWhereClause(), stringBuffer);
        }
        if (this.hasOrderByClause()) {
            this.orderByClause().evaluateOn(stringBuffer);
        }
    }

    public void evaluateOn(StringBuffer stringBuffer, List list) {
        this.statementOn(stringBuffer);
        if (this.whereClause() != null) {
            if (this.isSingleTable() && !this.isQualifyingColumnNames() && !this.isUsingAliases()) {
                this.doNotQualify();
            }
            if (this.isQualifyingColumnNames() && !this.isUsingAliases()) {
                this.qualify();
            }
            if (this.isUsingAliases() || !this.isSingleTable()) {
                this.whereClause().qualifyColumnNames(this.allAliasTables());
            }
            this.whereClause().evaluateOn(this.isUsingEmptyWhereClause(), stringBuffer, list);
        }
        if (this.hasOrderByClause()) {
            this.orderByClause().evaluateOn(stringBuffer);
        }
    }

    public FullSelect except(FullOrSubSelect fullOrSubSelect) {
        FullSelect fullSelect = new FullSelect();
        fullSelect.except(this, fullOrSubSelect);
        return fullSelect;
    }

    public FullSelect exceptAll(FullOrSubSelect fullOrSubSelect) {
        FullSelect fullSelect = new FullSelect();
        fullSelect.exceptAll(this, fullOrSubSelect);
        return fullSelect;
    }

    public FromClause firstFromClause() {
        return this.fromClause();
    }

    public FromClause fromClause() {
        if (this.fFromClause == null) {
            this.fFromClause = new FromClause();
        }
        return this.fFromClause;
    }

    public void fromClause(FromClause fromClause) {
        this.fFromClause = fromClause;
    }

    public boolean includesColumn(RDBColumn rDBColumn) {
        return this.selectClause().includes(rDBColumn);
    }

    public boolean includesTable(RDBTable rDBTable) {
        return this.fromClause().includes(rDBTable);
    }

    public FullSelect intersect(FullOrSubSelect fullOrSubSelect) {
        FullSelect fullSelect = new FullSelect();
        fullSelect.intersect(this, fullOrSubSelect);
        return fullSelect;
    }

    public FullSelect intersectAll(FullOrSubSelect fullOrSubSelect) {
        FullSelect fullSelect = new FullSelect();
        fullSelect.intersectAll(this, fullOrSubSelect);
        return fullSelect;
    }

    public boolean isDistinct() {
        return this.selectClause().isDistinct();
    }

    public boolean isSingleTable() {
        return this.fromClause().isSingleTable();
    }

    public boolean isSelectInto() {
        return this.selectClause().isSelectInto();
    }

    public boolean isSubQuery() {
        return this.containingSubSelect() != null;
    }

    public void addNativeFilter(String string) {
        if (this.whereClause() == null) {
            this.addWhereClause();
        }
        this.whereClause().addNativeFilter(string);
    }

    public SubSelect containingSubSelect() {
        return this.fContainingSubSelect;
    }

    public boolean isSingle() {
        return this.parentSelect().isSingle();
    }

    public void containingSubSelect(SubSelect subSelect) {
        this.fContainingSubSelect = subSelect;
    }

    public void select(List list) {
        this.addTablesFrom(list);
        this.selectClause(this.createSelectClause(list));
    }

    public void select(TableReference tableReference) {
        this.addTable(tableReference);
        ArrayList<ColumnName> arrayList = new ArrayList<ColumnName>();
        if (tableReference.isFullSelect()) {
            Iterator iterator = tableReference.fullSelect().selectClause().getColumnsAndExpressions().iterator();
            while (iterator.hasNext()) {
                ColumnName columnName;
                Object e = iterator.next();
                if (e instanceof RDBColumn) {
                    columnName = this.asColumnName((RDBColumn)e);
                } else if (e instanceof SqlIdentifier) {
                    columnName = this.asColumnName((SqlIdentifier)e);
                } else {
                    throw new RuntimeException("unknown element in projection clause list: " + e.toString());
                }
                columnName.invariantTableAlias(tableReference.correlationName());
                arrayList.add(columnName);
            }
            this.selectClause(this.createSelectClause(arrayList));
        }
    }

    public void select(List list, List list2, Predicate predicate) {
        this.addColumns(list);
        this.addTables(list2);
        this.and(predicate);
    }

    public SelectClause selectClause() {
        return this.fSelectClause;
    }

    public void addSelectClausesTo(Collection collection) {
        collection.add(this.selectClause());
    }

    public Collection getSelectClauses() {
        return ListWrapper.list(this.selectClause());
    }

    public void selectClause(SelectClause selectClause) {
        this.fSelectClause = selectClause;
    }

    public void selectFrom(List list, List list2) {
        this.createSelectClause(list);
        this.addTables(list2);
    }

    public void selectFromWhere(List list, List list2, Predicate predicate) {
        this.createSelectClause(list);
        this.addTables(list2);
        this.and(predicate);
    }

    public void statementOn(StringBuffer stringBuffer) {
        if (this.isSingleTable() && !this.isUsingAliases() && !this.isQualifyingColumnNames()) {
            Iterator iterator = this.gatherColumns().iterator();
            while (iterator.hasNext()) {
                ((ColumnName)iterator.next()).doNotQualify();
            }
        } else if (!this.isUsingAliases() && this.isQualifyingColumnNames()) {
            Iterator iterator = this.gatherColumns().iterator();
            while (iterator.hasNext()) {
                ((ColumnName)iterator.next()).qualify();
            }
        }
        stringBuffer.append(SELECT);
        if (this.isUsingAliases() || !this.isSingleTable()) {
            this.selectClause().setAliasesFrom(this.allAliasTables());
        }
        this.selectClause().evaluateOn(stringBuffer);
        stringBuffer.append(BLANK);
        if (this.isSingleTable() && !this.isUsingAliases() || this.isQualifyingColumnNames()) {
            this.fromClause().doNotCreateAliases();
        }
        if (this.isUsingAliases() || !this.isSingleTable()) {
            this.fromClause().createAliases();
        }
        if (this.isUsingAliases() || !this.isSingleTable()) {
            this.fromClause().qualifyColumnNames(this.allAliasTables());
        }
        this.fromClause().evaluateOn(stringBuffer);
    }

    public List tableScope() {
        if (this.isSubQuery()) {
            StSet stSet = new StSet();
            this.addTablesTo(stSet);
            for (SubSelect subSelect = this.containingSubSelect(); subSelect != null; subSelect = subSelect.containingSubSelect()) {
                stSet.addAll((Collection)subSelect.tables());
            }
            return stSet.toList();
        }
        ArrayList arrayList = new ArrayList();
        arrayList.addAll(this.fromClause().tables());
        return arrayList;
    }

    public List tableNames() {
        if (this.isSubQuery()) {
            StSet stSet = new StSet();
            this.addTableNamesTo(stSet);
            for (SubSelect subSelect = this.containingSubSelect(); subSelect != null; subSelect = subSelect.containingSubSelect()) {
                stSet.addAll((Collection)subSelect.tableNames());
            }
            return stSet.toList();
        }
        ArrayList arrayList = new ArrayList();
        arrayList.addAll(this.fromClause().tableNames());
        return arrayList;
    }

    public SelectStatement toSelectStatement() {
        return new SelectStatement(this);
    }

    public FullSelect union(FullOrSubSelect fullOrSubSelect) {
        FullSelect fullSelect = new FullSelect();
        fullSelect.union(this, fullOrSubSelect);
        return fullSelect;
    }

    public FullSelect unionAll(FullOrSubSelect fullOrSubSelect) {
        FullSelect fullSelect = new FullSelect();
        fullSelect.unionAll(this, fullOrSubSelect);
        return fullSelect;
    }

    public int numberOfOutputHostVariables() {
        if (this.selectClause().isSelectInto()) {
            return this.selectClause().hostVariables().size();
        }
        return 0;
    }

    public void normalSelectClause() {
        this.selectClause().normalSelectClause();
    }

    public List outputArgNamesAndColumns() {
        if (this.isSelectInto()) {
            return this.selectClause().outputArgNamesAndColumns();
        }
        return new ArrayList();
    }

    public boolean hasSetOperations() {
        return false;
    }

    public void setForUpdateOnTables() {
        Iterator iterator = this.fromClause().getTables().iterator();
        while (iterator.hasNext()) {
            ((TableReference)iterator.next()).setForUpdate();
        }
    }

    public OrderByClause orderByClause() {
        return this.fOrderByClause;
    }

    public void createOrderByClause(List list) {
        this.fOrderByClause = new OrderByClause(list);
    }

    public boolean hasOrderByClause() {
        return this.fOrderByClause != null;
    }

    public void toResultSetExpressions() {
        this.selectClause().toResultSetExpressions();
    }

    public List branches() {
        ArrayList arrayList = new ArrayList();
        this.addBranches(arrayList);
        return arrayList;
    }

    public void addBranches(List list) {
        list.add(this);
    }

    public void replaceTablesWith(RDBTable rDBTable, SubSelect subSelect, String string) {
        this.fromClause().replaceTablesWith(rDBTable, subSelect, string);
    }

    public SelectClause firstSelectClause() {
        return this.selectClause();
    }
}

