/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wdo.mediator.rdb.queryengine.sqlquerytree;

import com.ibm.ws.wdo.mediator.rdb.queryengine.schema.RDBTable;
import com.ibm.ws.wdo.mediator.rdb.queryengine.sqlquerytree.AbstractSqlIdentifier;
import com.ibm.ws.wdo.mediator.rdb.queryengine.sqlquerytree.TableInfo;

public class TableName
extends AbstractSqlIdentifier {
    private static final String copyright = "(c) Copyright IBM Corporation 2001.";
    public static int id = 0;
    private int fId;
    private String aliasString;
    private boolean aliasFlag = true;
    private boolean qualifyFlag = false;
    private String fCteName;

    public TableName(RDBTable rDBTable) {
        super(rDBTable);
        this.fId = id++;
    }

    public TableName(RDBTable rDBTable, String string) {
        super(rDBTable);
        this.alias(string);
        this.fId = id++;
    }

    public String alias() {
        if (this.aliasString == null) {
            return this.tableName();
        }
        return this.aliasString;
    }

    public void alias(String string) {
        this.aliasString = string;
    }

    public void doNotUseAlias() {
        this.aliasFlag = false;
    }

    public boolean doNotUseQualifier() {
        this.qualifyFlag = true;
        return true;
    }

    public void evaluateOn(StringBuffer stringBuffer) {
        if (this.isString()) {
            stringBuffer.append(this.value());
        }
        if (this.hasCteName()) {
            stringBuffer.append(this.cteName());
        } else if (this.isUsingQualifier()) {
            stringBuffer.append(this.qualifiedTableName());
        } else {
            stringBuffer.append(this.tableName());
        }
        if (!this.isUsingAlias()) {
            return;
        }
        if (this.isAliasGiven() && this.isUsingTableAliases()) {
            stringBuffer.append("  ");
            stringBuffer.append(this.alias());
        }
    }

    public boolean isAliasGiven() {
        return this.aliasString != null;
    }

    public boolean isUsingAlias() {
        return this.aliasFlag;
    }

    public boolean isUsingQualifier() {
        return this.qualifyFlag;
    }

    public String name() {
        return this.table().getName();
    }

    public void printDetailOn(StringBuffer stringBuffer) {
        if (this.value() == null) {
            stringBuffer.append("null");
        } else {
            stringBuffer.append(this.name());
        }
        stringBuffer.append(" - ");
        stringBuffer.append(this.fId);
    }

    public String qualifiedTableName() {
        if (this.isUsingDelimitedIdentifiers()) {
            StringBuffer stringBuffer = new StringBuffer();
            String string = new TableInfo(this.table()).getQualifier();
            if (string != null && string.length() > 0) {
                stringBuffer.append(this.asDelimitedIdentifier(string));
                stringBuffer.append(".");
            }
            stringBuffer.append(this.tableName());
            return stringBuffer.toString();
        }
        return new TableInfo(this.table()).getQualifiedName();
    }

    public boolean same(RDBTable rDBTable) {
        return this.table().equals(rDBTable);
    }

    public RDBTable table() {
        return (RDBTable)this.value();
    }

    public String tableName() {
        String string = this.table().getName();
        if (this.isUsingDelimitedIdentifiers()) {
            return this.asDelimitedIdentifier(string);
        }
        return string;
    }

    public void useAlias() {
        this.aliasFlag = true;
    }

    public boolean useQualifier() {
        this.qualifyFlag = true;
        return true;
    }

    public boolean hasCteName() {
        return this.fCteName != null;
    }

    public String cteName() {
        return this.fCteName;
    }

    public void cteName(String string) {
        this.fCteName = string;
    }
}

